/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.web.controller.api;

import com.irdstudio.allinrdm.sam.console.facade.TplFolderInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TplFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class TplFolderInfoController
extends BaseController<TplFolderInfoDTO, TplFolderInfoService> {
    @RequestMapping(value={"/api/tpl/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TplFolderInfoDTO>> queryTplFolderInfoAll(TplFolderInfoDTO dto) {
        List outputVo = ((TplFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tpl/folder/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<TplFolderInfoDTO>> queryList(TplFolderInfoDTO dto) {
        List outputVo = ((TplFolderInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tpl/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<TplFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        TplFolderInfoDTO inVo = new TplFolderInfoDTO();
        inVo.setFolderId(folderId);
        TplFolderInfoDTO outputVo = (TplFolderInfoDTO)((TplFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tpl/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody TplFolderInfoDTO inTplFolderInfoDTO) {
        int outputVo = ((TplFolderInfoService)this.getService()).deleteByPk((Object)inTplFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tpl/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody TplFolderInfoDTO inTplFolderInfoDTO) {
        this.setUserInfoToVO(inTplFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTplFolderInfoDTO.setLastModifyUser(userId);
        inTplFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((TplFolderInfoService)this.getService()).updateByPk((Object)inTplFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/tpl/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertTplFolderInfo(@RequestBody TplFolderInfoDTO inTplFolderInfoDTO) {
        this.setUserInfoToVO(inTplFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inTplFolderInfoDTO.setCreateUser(userId);
        inTplFolderInfoDTO.setCreateTime(now);
        inTplFolderInfoDTO.setLastModifyUser(userId);
        inTplFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inTplFolderInfoDTO.getFolderId())) {
            inTplFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((TplFolderInfoService)this.getService()).insert((Object)inTplFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/tpl/folder/info/merge"})
    @ResponseBody
    public ResponseData<Integer> folderMerge(@RequestBody TplFolderInfoDTO paramDTO, @RequestParam(value="type") String type) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((TplFolderInfoService)this.getService()).folderMerge(paramDTO, type);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/tpl/folder/info/move"})
    @ResponseBody
    public ResponseData<Integer> folderMove(@RequestBody TplFolderInfoDTO paramDTO) {
        this.setUserInfoToVO(paramDTO);
        int outputVo = ((TplFolderInfoService)this.getService()).folderMove(paramDTO);
        return this.getResponseData(outputVo);
    }
}

