/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.wiki.console.web.controller.api;

import com.irdstudio.allinrdm.wiki.console.facade.WikiPageCommentService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiPageCommentDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WikiPageCommentController
extends BaseController<WikiPageCommentDTO, WikiPageCommentService> {
    @Autowired
    @Qualifier(value="wikiPageCommentServiceImpl")
    private WikiPageCommentService wikiPageCommentService;

    @RequestMapping(value={"/api/wiki/page/comments"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<WikiPageCommentDTO>> queryWikiPageCommentAll(WikiPageCommentDTO vo) {
        List outputVo = this.wikiPageCommentService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/page/comment/{commentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<WikiPageCommentDTO> queryByPk(@PathVariable(value="commentId") String commentId) {
        WikiPageCommentDTO inVo = new WikiPageCommentDTO();
        inVo.setCommentId(commentId);
        WikiPageCommentDTO outputVo = (WikiPageCommentDTO)this.wikiPageCommentService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/page/comment"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody WikiPageCommentDTO inWikiPageCommentDTO) {
        int outputVo = this.wikiPageCommentService.deleteByPk((Object)inWikiPageCommentDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/page/comment"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody WikiPageCommentDTO inWikiPageCommentDTO) {
        int outputVo = this.wikiPageCommentService.updateByPk((Object)inWikiPageCommentDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/page/comment"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertWikiPageComment(@RequestBody WikiPageCommentDTO inWikiPageCommentDTO) {
        if (StringUtils.isBlank((CharSequence)inWikiPageCommentDTO.getCommentId())) {
            inWikiPageCommentDTO.setCommentId(UUIDUtil.getUUID());
        }
        inWikiPageCommentDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inWikiPageCommentDTO.setCreateUser(inWikiPageCommentDTO.getLoginUserId());
        int outputVo = this.wikiPageCommentService.insert((Object)inWikiPageCommentDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/WikiPageCommentService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody WikiPageCommentDTO param) {
        return ((WikiPageCommentService)this.getService()).deleteByCond(param);
    }
}

