/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.task;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinrdm.dam.console.application.service.task.DamTemplateTask;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.PublishState;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DictOptionInfoImportTask
implements DamTemplateTask {
    @Autowired
    @Qualifier(value="dictOptionInfoService")
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    protected SeqInstInfoService seqInstInfoService;

    @Override
    public Map<String, Object> handler(Map<String, Object> params, File uploadFile) {
        String excelUploadType = MapUtils.getString(params, (Object)"excelUploadType");
        final String accessLevel = MapUtils.getString(params, (Object)"accessLevel");
        final String subsId = MapUtils.getString(params, (Object)"subsId");
        final String appId = MapUtils.getString(params, (Object)"appId");
        final String userId = MapUtils.getString(params, (Object)"userId");
        final ArrayList list = new ArrayList();
        final HashMap dicIdMap = new HashMap();
        final HashMap map = new HashMap();
        final ArrayList enumList = new ArrayList();
        final String createTime = TimeUtil.getCurrentDateTime();
        List<String> HEAD = Arrays.asList("\u9009\u9879\u7f16\u53f7", "\u82f1\u6587\u540d\u79f0", "\u4e2d\u6587\u540d\u79f0", "\u9009\u9879\u503c", "\u9009\u9879\u679a\u4e3e\u503c", "\u9009\u9879\u63cf\u8ff0");
        final ArrayList headCellList = new ArrayList();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)new FileInputStream(uploadFile), (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
                    DictOptionInfoDTO info;
                    String dictId = data.get(0);
                    String dictCode = data.get(1);
                    String dictName = data.get(2);
                    String optionCode = data.get(3);
                    String optionEnum = data.get(4);
                    String optionName = data.get(5);
                    if (StringUtils.isBlank((String)dictId)) {
                        String id = (String)dicIdMap.get(dictCode);
                        if (StringUtils.isBlank((String)id)) {
                            id = DictOptionInfoImportTask.this.seqInstInfoService.nextSequence("DAM-DIC-OPTION-SEQ", subsId);
                            dicIdMap.put(dictCode, id);
                        }
                        dictId = id;
                    }
                    if ((info = (DictOptionInfoDTO)map.get(dictId)) == null) {
                        info = new DictOptionInfoDTO();
                        info.setDictId(dictId);
                        info.setDictCode(dictCode);
                        info.setDictName(dictName);
                        info.setDictIsStd("N");
                        info.setDictType("1");
                        info.setAccessLevel(accessLevel);
                        info.setSubsId(subsId);
                        info.setAppId(appId);
                        info.setCreateTime(createTime);
                        info.setCreateUser(userId);
                        info.setPublishState(PublishState.Publish.getCode());
                        info.setCodeLen(Integer.valueOf(0));
                        map.put(info.getDictId(), info);
                        if (StringUtils.isNotBlank((String)dictCode)) {
                            list.add(info);
                        }
                    }
                    info.setCodeLen(Integer.valueOf(Math.max(info.getCodeLen(), StringUtils.length((String)optionCode))));
                    DictOptionEnumDTO obj = new DictOptionEnumDTO();
                    obj.setOptionId(UUIDUtil.getUUID());
                    obj.setDictId(dictId);
                    obj.setOptionCode(optionCode);
                    obj.setOptionEnum(optionEnum);
                    obj.setOptionName(optionName);
                    obj.setOptionRemarks(optionName);
                    obj.setSubsId(subsId);
                    obj.setLastModifyTime(createTime);
                    obj.setLastModifyUser(userId);
                    enumList.add(obj);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doReadSync();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25 " + e.getMessage(), e);
        }
        if (headCellList.size() != HEAD.size()) {
            throw new RuntimeException("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
        }
        for (int i = 0; i < HEAD.size(); ++i) {
            if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
            throw new RuntimeException("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
        }
        if (list.size() > 0) {
            this.dictOptionInfoService.excelUpload(excelUploadType, list, enumList);
        }
        return Collections.emptyMap();
    }
}

