/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.sam.console.application.service.utils.JGitUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TerminalExecUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTemplateRepoPullTask
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(AppTemplateRepoPullTask.class);
    public static final String createDbSqlFileName = "create_db.sql";
    public static final String createAppSqlFileName = "create_app.sql";
    public static final String initDataSqlFileName = "init_data.sql";
    private static String gitUserName;
    private static String gitPassword;
    private static String branchName;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private String appTemplateId = null;
    private String gitUrl = null;
    private String appTemplatePath = null;

    public AppTemplateRepoPullTask(String appTemplateId, String gitUrl) {
        this.appTemplateId = appTemplateId;
        this.gitUrl = gitUrl;
    }

    public AppTemplateRepoPullTask(String appTemplateId) {
        this.appTemplateId = appTemplateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning.set(true);
        Object conn = null;
        try {
            if (gitUserName == null) {
                PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
                gitUserName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.username").getParamValue();
                gitPassword = paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.password").getParamValue();
                branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.prjtemplate.branch.name").getParamValue();
            }
            if (StringUtils.isBlank((CharSequence)this.gitUrl)) {
                PaasTemplateInfoService paasTemplateInfoService = (PaasTemplateInfoService)SpringContextUtils.getBean(PaasTemplateInfoService.class);
                PaasTemplateInfoDTO templateParam = new PaasTemplateInfoDTO();
                templateParam.setAppTemplateId(this.appTemplateId);
                PaasTemplateInfoDTO templateInfo = (PaasTemplateInfoDTO)paasTemplateInfoService.queryByPk((Object)templateParam);
                this.gitUrl = templateInfo.getAppTemplateGitUrl();
            }
            if (StringUtils.isBlank((CharSequence)this.gitUrl)) {
                return;
            }
            String gitLocalPathFileName = this.appTemplateId + "-template";
            String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
            boolean flag = false;
            if (gitLocalPath != null) {
                flag = this.repositoryCreate(gitLocalPath + gitLocalPathFileName, this.gitUrl, gitUserName, gitPassword, branchName);
                if (flag) {
                    this.appTemplatePath = new File(gitLocalPath + gitLocalPathFileName).getAbsolutePath();
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.gitUrl);
                } else {
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.gitUrl);
                }
                return;
            }
            return;
        }
        catch (Exception e) {
            logger.error("\u6587\u6863\u6a21\u677f\u4ed3\u5e93\u62c9\u53d6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
        }
        this.isRunning.set(false);
    }

    public void asyncRun() {
        this.start();
    }

    public void syncRun() {
        this.run();
    }

    private boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                logger.debug("git  \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25\uff0c\u6539\u514b\u9686");
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    logger.debug("git \u5220\u9664\u539f\u4ed3\u5e93\u76ee\u5f55\u91cd\u65b0\u514b\u9686");
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public String getAppTemplatePath() {
        return this.appTemplatePath;
    }
}

