/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinrdm.dev.console.types.YesOrNO;
import com.irdstudio.allinrdm.project.console.facade.RdmProjectInfoService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmProjectInfoDTO;
import com.irdstudio.allinrdm.project.console.types.ProjectState;
import com.irdstudio.allintpaas.sdk.job.application.operation.JobAbstractServiceImpl;
import com.irdstudio.allintpaas.sdk.job.facade.operation.JobBaseService;
import com.irdstudio.allintpaas.sdk.job.facade.operation.dto.JobExecuteParamDTO;
import com.irdstudio.allintpaas.sdk.notify.facade.operation.SdkNotifyMailService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.allintpaas.sdk.report.manual.facade.operation.RptExportManualService;
import com.irdstudio.allintpaas.sdk.report.types.RptModelCategoryEnum;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.FilterItem;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.mail.MailSendException;
import org.springframework.stereotype.Service;

@Service(value="RdmProjectRptMailSendServiceImpl")
public class RdmProjectRptMailSendServiceImpl
extends JobAbstractServiceImpl
implements JobBaseService,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final String JOB_ID = "RdmProjectRptMailSend";
    @Autowired
    protected RdmProjectInfoService rdmProjectInfoService;
    @Autowired
    protected RptInstInfoService rptInstInfoService;
    @Autowired
    protected SdkNotifyMailService sdkNotifyMailService;
    @Autowired
    private RptExportManualService rptExportManualService;
    private static final ConcurrentMap<String, Boolean> onlyOnceMap = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(JobExecuteParamDTO param) {
        int output = 0;
        boolean re = false;
        try {
            List projectList;
            if (onlyOnceMap.get(param.getBatchSerialNo()) != null) {
                int n = output;
                return n;
            }
            onlyOnceMap.put(param.getBatchSerialNo(), true);
            Map extParam = new HashMap();
            try {
                extParam = (Map)JSON.parseObject((String)param.getExtParam(), Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RdmProjectInfoDTO projectParam = new RdmProjectInfoDTO();
            projectParam.setProjectArchiveFlag(YesOrNO.NO.getCode());
            FilterItem stateFilter = new FilterItem();
            stateFilter.setOp(FilterItem.FilterOpEnum.NotIn.getCode());
            stateFilter.setKey("projectState");
            stateFilter.setValues(Arrays.asList(ProjectState.Done.getCode(), ProjectState.OverdueDone.getCode()));
            projectParam.setFilterCond(JSON.toJSONString(Arrays.asList(stateFilter)));
            if (StringUtils.isNotBlank((CharSequence)MapUtils.getString(extParam, (Object)"projectId"))) {
                projectParam.setProjectId(MapUtils.getString(extParam, (Object)"projectId"));
            }
            if (CollectionUtils.isEmpty((Collection)(projectList = this.rdmProjectInfoService.queryList((Object)projectParam)))) {
                logger.info("\u6ca1\u6709\u72b6\u6001\u4e3a\u672a\u5173\u95ed\u53ca\u672a\u5f52\u6863\u7684\u9879\u76ee\u53ef\u4ee5\u53d1\u9001\u62a5\u8868\u90ae\u4ef6");
                int n = output;
                return n;
            }
            for (RdmProjectInfoDTO project : projectList) {
                if (StringUtils.isBlank((CharSequence)project.getProjectReportAddressee())) {
                    logger.info("{} \u9879\u76ee\u6ca1\u6709\u9879\u76ee\u62a5\u8868\u6536\u4ef6\u4eba\uff0c\u4e0d\u53d1\u9001\u62a5\u8868", (Object)project.getProjectId());
                    continue;
                }
                RptInstInfoDTO rptInstParam = new RptInstInfoDTO();
                rptInstParam.setRptInstCategory(RptModelCategoryEnum.C.getCode());
                FilterItem rptInstIdFilter = new FilterItem();
                rptInstIdFilter.setOp(FilterItem.FilterOpEnum.Like.getCode());
                rptInstIdFilter.setKey("rptInstId");
                rptInstIdFilter.setValues(Arrays.asList(project.getProjectId()));
                rptInstParam.setFilterCond(JSON.toJSONString(Arrays.asList(rptInstIdFilter)));
                rptInstParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                List rptList = this.rptInstInfoService.queryList(rptInstParam);
                if (CollectionUtils.isEmpty((Collection)rptList)) {
                    logger.info("{} \u9879\u76ee\u6ca1\u6709\u9879\u76ee\u62a5\u8868\u5b9e\u4f8b\uff0c\u4e0d\u53d1\u9001\u62a5\u8868", (Object)project.getProjectId());
                    continue;
                }
                String addressee = project.getProjectReportAddressee();
                addressee = StringUtils.replace((String)addressee, (String)"\uff1b", (String)";");
                addressee = StringUtils.replace((String)addressee, (String)"\uff0c", (String)";");
                String now = CurrentDateUtil.getTodayDate();
                String startDate = "";
                String endDate = "";
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString(extParam, (Object)"now"))) {
                    now = MapUtils.getString(extParam, (Object)"now");
                }
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString(extParam, (Object)"startDate"))) {
                    startDate = MapUtils.getString(extParam, (Object)"startDate");
                }
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString(extParam, (Object)"endDate"))) {
                    endDate = MapUtils.getString(extParam, (Object)"endDate");
                }
                String subject = String.format("[%s]%s(%s)\u9879\u76ee\u62a5\u8868", now, project.getProjectName(), project.getProjectId());
                String text = String.format("<b>%s(%s)\u9879\u76ee\u62a5\u8868: </b><ul>", project.getProjectName(), project.getProjectId());
                HashMap<String, File> fileMap = new HashMap<String, File>();
                for (RptInstInfoDTO rpt : rptList) {
                    File pdf = this.rptExportManualService.exportToPdf(rpt.getRptInstId(), rpt.getRptModelId(), startDate, endDate, Collections.emptyMap());
                    if (pdf == null) continue;
                    String rptName = String.format("%s(%s)-%s.pdf", rpt.getRptInstName(), rpt.getRptInstId(), now);
                    fileMap.put(rptName, pdf);
                    text = text + String.format("<li>%s</li>", rptName);
                }
                text = text + "</ul>";
                try {
                    this.sdkNotifyMailService.sendMessage(addressee, subject, text, Boolean.valueOf(true), fileMap);
                    ++output;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof MailSendException && e.getCause().getMessage().contains("Broken pipe")) {
                        try {
                            this.sdkNotifyMailService.sendMessage(addressee, subject, text, Boolean.valueOf(true), fileMap);
                            ++output;
                        }
                        catch (Exception e1) {
                            logger.error("{} \u90ae\u4ef6\u518d\u6b21\u53d1\u9001\u5f02\u5e38 {}", new Object[]{project.getProjectId(), e1.getMessage(), e1});
                        }
                        continue;
                    }
                    logger.error("{} \u90ae\u4ef6\u53d1\u9001\u5f02\u5e38 {}", new Object[]{project.getProjectId(), e.getMessage(), e});
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5ffd\u7565\u4f5c\u4e1a{}\u6267\u884cSQL\u5f02\u5e38{}", new Object[]{JOB_ID, e.getMessage(), e});
        }
        finally {
            onlyOnceMap.remove(param.getBatchSerialNo());
        }
        return output;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.initService(applicationContext);
    }
}

