/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.project.console.application.service.impl;

import com.irdstudio.allinrdm.project.console.acl.repository.RdmTaskTmpRepository;
import com.irdstudio.allinrdm.project.console.domain.entity.RdmTaskTmpDO;
import com.irdstudio.allinrdm.project.console.facade.RdmTaskTmpService;
import com.irdstudio.allinrdm.project.console.facade.dto.RdmTaskTmpDTO;
import com.irdstudio.allinrdm.project.console.types.TaskValidState;
import com.irdstudio.allintpaas.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintpaas.admin.facade.dto.SUserDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmTaskTmpServiceImpl")
public class RdmTaskTmpServiceImpl
extends BaseServiceImpl<RdmTaskTmpDTO, RdmTaskTmpDO, RdmTaskTmpRepository>
implements RdmTaskTmpService {
    private static ConcurrentMap<String, String> taskDebounce = new ConcurrentHashMap<String, String>();
    @Autowired
    AllinCloudPortalClient portalClient;

    public int deleteByCond(RdmTaskTmpDTO param) {
        RdmTaskTmpDO rdmTaskTmpDO = new RdmTaskTmpDO();
        this.beanCopy(param, rdmTaskTmpDO);
        return ((RdmTaskTmpRepository)this.getRepository()).deleteByCond(rdmTaskTmpDO);
    }

    public String queryTaskValidStat(String serialNo) {
        return (String)taskDebounce.get(serialNo);
    }

    public String execTaskValid(String serialNo) {
        taskDebounce.put(serialNo, String.valueOf(true));
        RdmTaskTmpDO param = new RdmTaskTmpDO();
        param.setSerialNo(serialNo);
        List taskList = ((RdmTaskTmpRepository)this.getRepository()).queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            SUserDTO userParam = new SUserDTO();
            List userList = this.portalClient.querySUserList(userParam);
            HashMap userNameMap = new HashMap();
            userList.forEach(user -> userNameMap.put(user.getActorname(), user.getActorno()));
            for (RdmTaskTmpDO task : taskList) {
                ArrayList<String> validState = new ArrayList<String>();
                ArrayList<String> validMsg = new ArrayList<String>();
                if (userNameMap.get(task.getInchargeName()) != null) {
                    task.setIncharge((String)userNameMap.get(task.getInchargeName()));
                    validState.add(TaskValidState.Paas.getCode());
                } else if (StringUtils.isNotBlank((CharSequence)task.getInchargeName())) {
                    validState.add(TaskValidState.Warning.getCode());
                    validMsg.add(task.getInchargeName() + "\u7528\u6237\u4e0d\u5c5e\u4e8e\u7cfb\u7edf\u7528\u6237");
                } else {
                    validState.add(TaskValidState.Paas.getCode());
                }
                if (userNameMap.get(task.getCollaboratorName()) != null) {
                    task.setCollaborator((String)userNameMap.get(task.getCollaboratorName()));
                    validState.add(TaskValidState.Paas.getCode());
                } else if (StringUtils.isNotBlank((CharSequence)task.getCollaboratorName())) {
                    validState.add(TaskValidState.Warning.getCode());
                    validMsg.add(task.getCollaboratorName() + "\u7528\u6237\u4e0d\u5c5e\u4e8e\u7cfb\u7edf\u7528\u6237");
                } else {
                    validState.add(TaskValidState.Paas.getCode());
                }
                validState.sort((o1, o2) -> (NumberUtils.toInt((String)o1) - NumberUtils.toInt((String)o2)) * -1);
                task.setValidMsg(StringUtils.join(validMsg, (String)","));
                task.setValidState((String)validState.get(0));
                ((RdmTaskTmpRepository)this.getRepository()).updateByPk((Object)task);
            }
        }
        taskDebounce.put(serialNo, String.valueOf(false));
        return String.valueOf(true);
    }
}

