/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.DictCategoryInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictItemExtRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictItemInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.PubDbmsDatatypeRepository;
import com.irdstudio.allinrdm.dam.console.application.service.utils.ItemNameSplitUtil;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictCategoryInfoDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictItemInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.DictItemInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictCategoryInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictItemInfoDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictItemInfoService")
public class DictItemInfoServiceImpl
extends BaseServiceImpl<DictItemInfoDTO, DictItemInfoDO, DictItemInfoRepository>
implements DictItemInfoService {
    @Autowired
    private DictItemExtRepository dictItemExtRepository;
    @Autowired
    private DictCategoryInfoRepository dictCategoryInfoRepository;
    @Autowired
    private PubDbmsDatatypeRepository pubDbmsDatatypeRepository;

    public List<DictItemInfoDTO> queryByItemNames(List<String> itemNames, String objectId, String dslId, String appId) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + itemNames.toString());
        List dictItemInfos = ((DictItemInfoRepository)this.getRepository()).queryByItemNames(itemNames, objectId, dslId, appId);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictItemInfos, DictItemInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<DictItemInfoDTO> queryByItemExtNames(List<String> itemNames, String objectId, String dslId, String appId) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + itemNames.toString());
        List dictItemInfos = this.dictItemExtRepository.queryByItemNames(itemNames, objectId, dslId, appId);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictItemInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictItemInfos, DictItemInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int excelUpload(String type, List<DictItemInfoDTO> list, List<DictCategoryInfoDTO> cataList) {
        int num = -1;
        if (StringUtils.equals((String)"insert", (String)type)) {
            int rs;
            String subsId = null;
            String appId = null;
            if (CollectionUtils.isNotEmpty(list)) {
                subsId = list.get(0).getSubsId();
                appId = list.get(0).getAppId();
            }
            if ((rs = ((DictItemInfoRepository)this.getRepository()).deleteAll(subsId, appId)) == -1) {
                return rs;
            }
            if (appId == null) {
                rs = this.dictCategoryInfoRepository.deleteAll(subsId);
            }
            if (rs == -1) {
                return rs;
            }
        }
        List itemDOList = this.beansCopy(list, DictItemInfoDO.class);
        int len = 1000;
        if (itemDOList.size() < len) {
            num += ((DictItemInfoRepository)this.getRepository()).batchInsert(itemDOList);
        } else {
            int loop = this.calcLoop(itemDOList.size());
            int cur = 0;
            for (int i = 1; i <= loop; ++i) {
                int end = len * i;
                if (end > itemDOList.size()) {
                    end = itemDOList.size();
                }
                List sub = itemDOList.subList(cur, end);
                cur += len;
                num += ((DictItemInfoRepository)this.getRepository()).batchInsert(sub);
            }
        }
        if (CollectionUtils.isNotEmpty(cataList)) {
            List cataDOList = this.beansCopy(cataList, DictCategoryInfoDO.class);
            if (cataDOList.size() < len) {
                num += this.dictCategoryInfoRepository.batchInsert(cataDOList);
            } else {
                int loop = this.calcLoop(cataDOList.size());
                int cur = 0;
                for (int i = 1; i <= loop; ++i) {
                    int end = len * i;
                    if (end > cataDOList.size()) {
                        end = cataDOList.size();
                    }
                    List sub = cataDOList.subList(cur, end);
                    cur += len;
                    num += this.dictCategoryInfoRepository.batchInsert(sub);
                }
            }
        }
        return num;
    }

    public Map<String, Object> queryStandardSummary(Map<String, Object> param) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + param);
        try {
            Map result = ((DictItemInfoRepository)this.getRepository()).queryStandardSummary(param);
            return result;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    public List<Map<String, Object>> queryStdSummaryList(Map<String, Object> param) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + param);
        try {
            List result = ((DictItemInfoRepository)this.getRepository()).queryStdSummaryList(param);
            return result;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    private int calcLoop(int size) {
        int loop = size / 1000;
        if (size % 1000 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public List<DictItemInfoDTO> queryAllForExcelByPage(DictItemInfoDTO dictItemInfoDTO) {
        logger.debug("\u67e5\u770b\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = Collections.emptyList();
        try {
            DictItemInfoDO dictItemInfoDO = new DictItemInfoDO();
            this.beanCopy(dictItemInfoDTO, dictItemInfoDO);
            List doList = ((DictItemInfoRepository)this.getRepository()).queryAllForExcelByPage(dictItemInfoDO);
            list = this.beansCopy(doList, DictItemInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public String querySeqWithPrefix(String projectId) {
        String result = "";
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        try {
            result = ((DictItemInfoRepository)this.getRepository()).querySeqWithPrefix(projectId);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public DictItemInfoDTO getItemByFieldName(final String fieldName, String objectId) {
        DictItemInfoDO dictItemInfo = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return null;
        }
        List<String> itemNames = ItemNameSplitUtil.splitName(fieldName);
        if (itemNames.isEmpty()) {
            return null;
        }
        List dictList = null;
        try {
            List newList;
            dictList = this.dictItemExtRepository.queryByItemNames(itemNames, null, null, null);
            if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                dictList.sort(new Comparator<DictItemInfoDO>(){

                    @Override
                    public int compare(DictItemInfoDO o1, DictItemInfoDO o2) {
                        if (StringUtils.equals((String)o1.getExtName(), (String)fieldName)) {
                            return -1;
                        }
                        if (StringUtils.equals((String)o2.getExtName(), (String)fieldName)) {
                            return 1;
                        }
                        return Integer.compare(o1.getExtName().length(), o2.getExtName().length()) * -1;
                    }
                });
                dictItemInfo = (DictItemInfoDO)dictList.get(0);
            }
            if (CollectionUtils.isEmpty((Collection)dictList) && CollectionUtils.isNotEmpty((Collection)(dictList = this.beansCopy(newList = ((DictItemInfoRepository)this.getRepository()).queryByItemNames(itemNames, null, null, null), DictItemInfoDO.class)))) {
                dictList.sort(new Comparator<DictItemInfoDO>(){

                    @Override
                    public int compare(DictItemInfoDO o1, DictItemInfoDO o2) {
                        if (StringUtils.equals((String)o1.getItemName(), (String)fieldName)) {
                            return -1;
                        }
                        if (StringUtils.equals((String)o2.getItemName(), (String)fieldName)) {
                            return 1;
                        }
                        return Integer.compare(o1.getItemName().length(), o2.getItemName().length()) * -1;
                    }
                });
                dictItemInfo = (DictItemInfoDO)dictList.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (DictItemInfoDTO)this.beanCopy(dictItemInfo, DictItemInfoDTO.class);
    }

    public static enum PUB_DATA_TYPE {
        PUB_DATA_TYPE_100("100", "\u5b9a\u957f\u5b57\u7b26\u4e32", "CHAR"),
        PUB_DATA_TYPE_101("101", "\u5b9a\u957f\u5b57\u7b26\u4e32(\u53cc)", "NCHAR"),
        PUB_DATA_TYPE_200("200", "\u53ef\u53d8\u957f\u5b57\u7b26\u4e32", "VARCHAR"),
        PUB_DATA_TYPE_201("201", "\u53ef\u53d8\u957f\u5b57\u7b26\u4e32(\u53cc)", "NVARCHAR"),
        PUB_DATA_TYPE_300("300", "\u6574\u6570", "INT"),
        PUB_DATA_TYPE_301("301", "\u5927\u6574\u6570", "BIGINT"),
        PUB_DATA_TYPE_302("302", "\u5c0f\u6574\u6570", ""),
        PUB_DATA_TYPE_303("303", "\u65e0\u7b26\u53f7\u6574\u6570", ""),
        PUB_DATA_TYPE_310("310", "\u9ad8\u7cbe\u5ea6\u6d6e\u70b9\u6570", "DECIMAL"),
        PUB_DATA_TYPE_311("311", "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570", "DOUBLE"),
        PUB_DATA_TYPE_312("312", "\u5355\u7cbe\u5ea6\u6d6e\u70b9\u6570", "FLOAT"),
        PUB_DATA_TYPE_400("400", "\u957f\u6587\u672c", "LONGTEXT"),
        PUB_DATA_TYPE_401("401", "\u77ed\u6587\u672c", "TEXT"),
        PUB_DATA_TYPE_500("500", "\u65e5\u671f", "DATE"),
        PUB_DATA_TYPE_501("501", "\u65e5\u671f\u65f6\u95f4", "DATETIME"),
        PUB_DATA_TYPE_600("600", "\u65f6\u95f4\u6233", "TIMESTAMP"),
        PUB_DATA_TYPE_601("601", "\u65f6\u95f4", "TIME"),
        PUB_DATA_TYPE_700("700", "\u5b57\u7b26\u5927\u6570\u636e", ""),
        PUB_DATA_TYPE_800("800", "\u4e8c\u8fdb\u5236\u5927\u6570\u636e", "LONGBLOB");

        private String code;
        private String name;
        private String sqlType;

        private PUB_DATA_TYPE(String code, String name, String sqlType) {
            this.code = code;
            this.name = name;
            this.sqlType = sqlType;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public static PUB_DATA_TYPE getBySqlType(String dataType) {
            if (dataType == null) {
                return null;
            }
            for (PUB_DATA_TYPE data : PUB_DATA_TYPE.values()) {
                if (!dataType.toUpperCase().startsWith(data.getSqlType())) continue;
                return data;
            }
            return null;
        }
    }
}

