/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.application.service.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.DictItemInfoRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictOptionEnumRepository;
import com.irdstudio.allinrdm.dam.console.acl.repository.DictOptionInfoRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictItemInfoDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictOptionEnumDO;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictOptionInfoDO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.AccessLevel;
import com.irdstudio.allinrdm.dam.console.types.PublishState;
import com.irdstudio.allintpaas.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictOptionInfoService")
public class DictOptionInfoServiceImpl
extends BaseServiceImpl<DictOptionInfoDTO, DictOptionInfoDO, DictOptionInfoRepository>
implements DictOptionInfoService {
    @Autowired
    private DictOptionEnumRepository dictOptionEnumRepository;
    @Autowired
    private DictItemInfoRepository dictItemInfoRepository;
    @Autowired
    private SeqInstInfoRepository seqInstInfoRepository;

    public List<DictOptionInfoDTO> queryAllByProjectId(String projectId) {
        logger.debug("\u67e5\u8be2\u5de5\u7a0b{}\u4e0b\u6240\u6709\u5b57\u5178\u6570\u636e:", (Object)projectId);
        List dictOptionInfos = ((DictOptionInfoRepository)this.getRepository()).queryAllByProjectId(projectId);
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictOptionInfos, DictOptionInfoDTO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<DictOptionInfoDTO> queryByDictNames(List<String> dictNames) {
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + dictNames.toString());
        List dictOptionInfos = ((DictOptionInfoRepository)this.getRepository()).queryByDictNames(dictNames);
        logger.debug("\u6570\u636e\u6cbb\u7406\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + dictOptionInfos.size());
        List list = Collections.emptyList();
        try {
            list = this.beansCopy(dictOptionInfos, DictOptionInfoDTO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int excelUpload(String type, List<DictOptionInfoDTO> list, List<DictOptionEnumDTO> enumList) {
        int num = -1;
        List doList = this.beansCopy(list, DictOptionInfoDO.class);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"insert", (CharSequence)type)) {
            int n;
            String subsId = null;
            Object appId = null;
            if (CollectionUtils.isNotEmpty(list)) {
                subsId = list.get(0).getSubsId();
                appId = list.get(0).getAppId();
            }
            if ((n = this.dictOptionEnumRepository.deleteAll(subsId, appId)) == -1) {
                return n;
            }
            int n2 = ((DictOptionInfoRepository)this.getRepository()).deleteAll(subsId, (String)appId);
            if (n2 == -1) {
                return n2;
            }
            if (doList.size() < 1000) {
                num += ((DictOptionInfoRepository)this.getRepository()).batchInsert(doList);
            } else {
                int loop = this.calcLoop(doList.size());
                int cur = 0;
                for (int i = 1; i <= loop; ++i) {
                    int end = 1000 * i;
                    if (end > doList.size()) {
                        end = doList.size();
                    }
                    List sub = doList.subList(cur, end);
                    cur += 1000;
                    num += ((DictOptionInfoRepository)this.getRepository()).batchInsert(sub);
                }
            }
            List enumDOList = this.beansCopy(enumList, DictOptionEnumDO.class);
            if (enumDOList.size() <= 1000) {
                num += this.dictOptionEnumRepository.batchInsert(enumDOList);
            } else {
                int loop = this.calcLoop(enumDOList.size());
                int cur = 0;
                for (int i = 1; i <= loop; ++i) {
                    int end = 1000 * i;
                    if (end > enumDOList.size()) {
                        end = enumDOList.size();
                    }
                    List sub = enumDOList.subList(cur, end);
                    cur += 1000;
                    num += this.dictOptionEnumRepository.batchInsert(sub);
                }
            }
        } else {
            ArrayList<DictOptionEnumDO> insertList = new ArrayList<DictOptionEnumDO>();
            for (DictOptionInfoDTO dictOptionInfoDTO : list) {
                DictOptionInfoDO info = new DictOptionInfoDO();
                this.beanCopy(dictOptionInfoDTO, info);
                ((DictOptionInfoRepository)this.getRepository()).deleteByPk((Object)info);
                ((DictOptionInfoRepository)this.getRepository()).insert((Object)info);
            }
            List enumDOList = this.beansCopy(enumList, DictOptionEnumDO.class);
            for (DictOptionEnumDO enumVO : enumDOList) {
                DictOptionEnumDO enumParam = new DictOptionEnumDO();
                enumParam.setDictId(enumVO.getDictId());
                enumParam.setOptionCode(enumVO.getOptionCode());
                List exists = this.dictOptionEnumRepository.queryListByPage((Object)enumParam);
                if (CollectionUtils.isNotEmpty((Collection)exists)) {
                    DictOptionEnumDO existsObj = (DictOptionEnumDO)exists.get(0);
                    String optionId = existsObj.getOptionId();
                    this.beanCopy(enumVO, existsObj);
                    existsObj.setOptionId(optionId);
                    this.dictOptionEnumRepository.updateByPk((Object)existsObj);
                    continue;
                }
                insertList.add(enumVO);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                if (insertList.size() <= 1000) {
                    num += this.dictOptionEnumRepository.batchInsert(insertList);
                } else {
                    int n = this.calcLoop(insertList.size());
                    int cur = 0;
                    for (int i = 1; i <= n; ++i) {
                        int end = 1000 * i;
                        if (end > insertList.size()) {
                            end = insertList.size();
                        }
                        List sub = insertList.subList(cur, end);
                        cur += 1000;
                        num += this.dictOptionEnumRepository.batchInsert(sub);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)doList) && org.apache.commons.lang3.StringUtils.equals((CharSequence)((DictOptionInfoDO)doList.get(0)).getAccessLevel(), (CharSequence)AccessLevel.PrivateLevel.getCode())) {
            ArrayList<DictItemInfoDO> insertItemList = new ArrayList<DictItemInfoDO>();
            String now = CurrentDateUtil.getTodayDateEx2();
            for (DictOptionInfoDO infoVO : doList) {
                DictItemInfoDO itemInfo = new DictItemInfoDO();
                itemInfo.setSubsId(infoVO.getSubsId());
                itemInfo.setDictId(infoVO.getDictId());
                List checkObjs = this.dictItemInfoRepository.queryListByPage((Object)itemInfo);
                if (CollectionUtils.isEmpty((Collection)checkObjs)) {
                    itemInfo = new DictItemInfoDO();
                    String itemId = this.seqInstInfoRepository.nextSequence("DAM-DIC-ITEM-SEQ", new String[]{infoVO.getSubsId()});
                    itemInfo.setItemId(itemId);
                    itemInfo.setCreateUser(now);
                    itemInfo.setCreateTime(infoVO.getCreateUser());
                } else {
                    itemInfo = (DictItemInfoDO)checkObjs.get(0);
                }
                itemInfo.setItemCode(infoVO.getDictCode());
                itemInfo.setItemDataType(Integer.valueOf(100));
                itemInfo.setItemDataLength(infoVO.getCodeLen());
                itemInfo.setAccessLevel(infoVO.getAccessLevel());
                itemInfo.setAppId(infoVO.getAppId());
                itemInfo.setSubsId(infoVO.getSubsId());
                itemInfo.setItemName(infoVO.getDictName());
                itemInfo.setPublishState(PublishState.Publish.getCode());
                itemInfo.setLastModifyTime(now);
                itemInfo.setLastModifyUser(infoVO.getCreateUser());
                itemInfo.setSuitType("0");
                itemInfo.setDictId(infoVO.getDictId());
                itemInfo.setDictCode(infoVO.getDictCode());
                if (CollectionUtils.isEmpty((Collection)checkObjs)) {
                    DictItemInfoDO itemVO = new DictItemInfoDO();
                    this.beanCopy(itemInfo, itemVO);
                    insertItemList.add(itemVO);
                    continue;
                }
                this.dictItemInfoRepository.updateByPk((Object)itemInfo);
            }
            if (CollectionUtils.isNotEmpty(insertItemList)) {
                this.dictItemInfoRepository.batchInsert(insertItemList);
            }
        }
        return num;
    }

    public String querySeqWithPrefix(String appId) {
        String result = "";
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        try {
            result = ((DictOptionInfoRepository)this.getRepository()).querySeqWithPrefix(appId);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    private int calcLoop(int size) {
        int loop = size / 1000;
        if (size % 1000 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public DictOptionInfoDTO getDictOptionByFieldName(String fieldName) {
        DictOptionInfoDTO option = null;
        if (StringUtils.isBlank((String)fieldName)) {
            return option;
        }
        int strLen = fieldName.length();
        ArrayList<String> itemNames = new ArrayList<String>(strLen);
        itemNames.add(fieldName + "\u4ee3\u7801");
        for (int i = 0; i < strLen; ++i) {
            itemNames.add(StringUtils.substring((String)fieldName, (int)i, (int)strLen));
        }
        if (itemNames.isEmpty()) {
            return option;
        }
        List dictList = ((DictOptionInfoRepository)this.getRepository()).queryByDictNames(itemNames);
        try {
            if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                dictList.sort(new Comparator<DictOptionInfoDO>(){

                    @Override
                    public int compare(DictOptionInfoDO o1, DictOptionInfoDO o2) {
                        return Integer.compare(o1.getDictName().length(), o2.getDictName().length()) * -1;
                    }
                });
                option = (DictOptionInfoDTO)this.beanCopy(dictList.get(0), DictOptionInfoDTO.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return option;
    }
}

