/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.application.service.impl;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinrdm.dev.console.acl.repository.CodeProduceInfoRepository;
import com.irdstudio.allinrdm.dev.console.application.service.utils.MyFileUtil;
import com.irdstudio.allinrdm.dev.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinrdm.dev.console.domain.entity.CodeProduceInfoDO;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.bo.CodeProduceInfoBo;
import com.irdstudio.allinrdm.dev.console.facade.bo.CodeTemplateFileBo;
import com.irdstudio.allinrdm.dev.console.facade.dto.CodeProduceInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.CodeGenerateConstant;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComBaseInfoDTO;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import com.irdstudio.sdk.beans.zip.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="codeProduceInfoServiceImpl")
public class CodeProduceInfoServiceImpl
extends BaseServiceImpl<CodeProduceInfoDTO, CodeProduceInfoDO, CodeProduceInfoRepository>
implements CodeProduceInfoService {
    Formatter javaFormatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());
    private static final String TABLE_VAR_NOSPLIT = "XXX";
    private static final String TABLE_VAR_SPLIT = "X-X-X";
    @Value(value="${facenter.template.path:}")
    private String templatePath;
    @Value(value="${facenter.code.path:}")
    private String codePath;
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;

    public boolean produceModelBeanCode(String useThisTemplate, String author, CodeProduceInfoBo codeProduceInfoBo, TmProjectInfoBo tmProjectInfoBo, ModelTableInfoBo modelTableInfoBo, List<CodeTemplateFileBo> ctfbList, boolean zipFlag) {
        String localTemplatePath = this.templatePath + File.separator + codeProduceInfoBo.getCodeTemplateId();
        if (StringUtils.isNotBlank((CharSequence)useThisTemplate)) {
            localTemplatePath = useThisTemplate;
        }
        logger.info("\u5f00\u59cb\u751f\u6210\u4ee3\u7801,\u6a21\u677f\u6587\u4ef6\u76ee\u5f55" + localTemplatePath + "...");
        String temporaryPath = this.codePath + (codeProduceInfoBo.getUserAppId() != false ? codeProduceInfoBo.getProducePath() : codeProduceInfoBo.getProduceId());
        File dir = new File(temporaryPath);
        if (dir.exists()) {
            dir.delete();
            System.out.println("\u5220\u9664\u5b58\u5728\u7684\u76ee\u5f55\uff1a" + temporaryPath + "!");
        } else {
            dir.mkdir();
        }
        if (!temporaryPath.endsWith(File.separator)) {
            temporaryPath = temporaryPath + File.separator;
        }
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.setMainTableModel(modelTableInfoBo);
        ctdb.setTmProjectInfo(tmProjectInfoBo);
        ctdb.getEnvBo().setAuthor(author);
        ctdb.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        ctdb.getEnvBo().setDesc(modelTableInfoBo.getTableName());
        PaasAppsParamService paasAppsParamService = (PaasAppsParamService)SpringContextUtils.getBean(PaasAppsParamService.class);
        ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
        RdmModuleInfoService rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
        PaasAppsParamDTO package_prefix = new PaasAppsParamDTO();
        package_prefix.setAppId(tmProjectInfoBo.getProjectId());
        package_prefix.setParamCode("package_prefix");
        package_prefix = (PaasAppsParamDTO)paasAppsParamService.queryByPk((Object)package_prefix);
        String packagePrefixVal = "com.irdstudio";
        if (package_prefix != null && StringUtils.isNotBlank((CharSequence)package_prefix.getParamValue())) {
            packagePrefixVal = package_prefix.getParamValue();
        }
        if (StringUtils.isNotBlank((CharSequence)modelTableInfoBo.getComId())) {
            ComBaseInfoDTO comBaseInfo = new ComBaseInfoDTO();
            comBaseInfo.setComId(modelTableInfoBo.getComId());
            comBaseInfo.setSubsId(codeProduceInfoBo.getSubsId());
            comBaseInfo = (ComBaseInfoDTO)comBaseInfoService.queryByPk((Object)comBaseInfo);
            if (comBaseInfo != null) {
                packagePrefixVal = packagePrefixVal + "." + comBaseInfo.getComFeatureCode();
            }
        } else if (StringUtils.isNotBlank((CharSequence)modelTableInfoBo.getFolderCode())) {
            packagePrefixVal = packagePrefixVal + "." + modelTableInfoBo.getFolderCode().replaceAll("_|\\.|-", ".");
        }
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("appCode", SdEnvUtil.wrapperAppCode(tmProjectInfoBo.getProjectCode()));
        expMap.put("appCodePackage", packagePrefixVal.replaceAll("_|\\.|-", "/"));
        if (StringUtils.isNotBlank((CharSequence)modelTableInfoBo.getFolderCode())) {
            expMap.put("tablePackage", modelTableInfoBo.getFolderCode().replaceAll("_|\\.|-", "/"));
            expMap.put("tablePackageName", modelTableInfoBo.getFolderName());
        }
        ctdb.getMapData().put("appCode", SdEnvUtil.wrapperAppCode(tmProjectInfoBo.getProjectCode()));
        ctdb.getMapData().put("appCodePackage", packagePrefixVal.replaceAll("_|\\.|-", "."));
        if (StringUtils.isNotBlank((CharSequence)modelTableInfoBo.getFolderCode())) {
            ctdb.getMapData().put("tablePackage", modelTableInfoBo.getFolderCode().replaceAll("_|\\.|-", "."));
            ctdb.getMapData().put("tablePackageName", modelTableInfoBo.getFolderName());
        }
        for (CodeTemplateFileBo codeTemplateFieldBo : ctfbList) {
            if (StringUtils.equals((CharSequence)codeTemplateFieldBo.getFileType(), (CharSequence)"05")) {
                if (!CollectionUtils.isNotEmpty((Collection)modelTableInfoBo.getFieldOptionList())) continue;
                for (Map fieldOption : modelTableInfoBo.getFieldOptionList()) {
                    String dictCode = MapUtils.getString((Map)fieldOption, (Object)"dictCode");
                    logger.info("\u679a\u4e3e\u4ee3\u7801" + dictCode + " \u6a21\u677f\u6587\u4ef6\uff1a" + localTemplatePath + File.separator + codeTemplateFieldBo.getCodeTemplateFile());
                    String fileNameResult = codeTemplateFieldBo.getCodeTemplateFile().replaceAll(TABLE_VAR_NOSPLIT, dictCode);
                    fileNameResult = fileNameResult.replaceAll(TABLE_VAR_SPLIT, dictCode.replace("_", "-"));
                    String outputFileName = temporaryPath + fileNameResult;
                    String targetPath = codeTemplateFieldBo.getToTargetPath();
                    if (StringUtils.isBlank((CharSequence)targetPath)) {
                        targetPath = outputFileName;
                    } else {
                        String dirPath = ExpressionUtil.parse((String)targetPath, expMap);
                        dirPath = temporaryPath + File.separator + dirPath;
                        File dirFile = new File(dirPath);
                        if (!dirFile.exists()) {
                            dirFile.mkdirs();
                        }
                        File targetFile = new File(dirFile, fileNameResult);
                        targetPath = targetFile.getAbsolutePath();
                    }
                    logger.info("\u4ee3\u7801\u6587\u4ef6\uff1a" + outputFileName);
                    ctdb.getMapData().putAll(fieldOption);
                    FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)localTemplatePath, (String)(codeTemplateFieldBo.getCodeTemplateFile() + ".vm"), (String)targetPath);
                }
                continue;
            }
            logger.info("\u6a21\u677f\u6587\u4ef6\uff1a" + localTemplatePath + File.separator + codeTemplateFieldBo.getCodeTemplateFile());
            String fileNameResult = codeTemplateFieldBo.getCodeTemplateFile().replaceAll(TABLE_VAR_NOSPLIT, modelTableInfoBo.getModelClassName());
            fileNameResult = fileNameResult.replaceAll(TABLE_VAR_SPLIT, modelTableInfoBo.getTableCode().replace("_", "-"));
            String outputFileName = temporaryPath + fileNameResult;
            String targetPath = codeTemplateFieldBo.getToTargetPath();
            if (StringUtils.isBlank((CharSequence)targetPath)) {
                targetPath = outputFileName;
            } else {
                String dirPath = ExpressionUtil.parse((String)targetPath, expMap);
                dirPath = temporaryPath + File.separator + dirPath;
                File dirFile = new File(dirPath);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                File targetFile = new File(dirFile, fileNameResult);
                targetPath = targetFile.getAbsolutePath();
            }
            logger.info("\u4ee3\u7801\u6587\u4ef6\uff1a" + outputFileName);
            FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)localTemplatePath, (String)(codeTemplateFieldBo.getCodeTemplateFile() + ".vm"), (String)targetPath);
        }
        if (zipFlag) {
            try {
                FileOutputStream fos1 = new FileOutputStream(new File(temporaryPath + ".zip"));
                ZipUtil.toZip((String)temporaryPath, (OutputStream)fos1, (boolean)true);
            }
            catch (FileNotFoundException e) {
                logger.info("\u538b\u7f29\u4ee3\u7801\u6587\u4ef6\u5931\u8d25!");
                e.printStackTrace();
            }
        }
        return true;
    }

    public int deleteByCond(String appId, String modelTableId) {
        return ((CodeProduceInfoRepository)this.getRepository()).deleteByCond(appId, modelTableId);
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getCodePath() {
        return this.codePath;
    }

    public void setCodePath(String codePath) {
        this.codePath = codePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceCodeFile(String templateType, String templateFile, String replaceTarget, String replaceStr, String rootPath, String modelName, String codePath, PaasAppsInfoDTO appInfo, CodeTemplateDataBo ctdb) {
        block7: {
            String fileNameResult;
            block8: {
                String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
                String templatePath = CodeProduceInfoServiceImpl.getTemplatePath(appInfo, templateType);
                ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
                String targetPath = SdEnvUtil.PROJECT_PATH + rootPath + File.separator + String.format("%s-%s", appCode, modelName).replace(".", "-") + File.separator + codePath;
                if (modelName == null) {
                    targetPath = SdEnvUtil.PROJECT_PATH + rootPath + File.separator + codePath;
                }
                if (!MyFileUtil.checkFileExist(targetPath = CodeProduceInfoServiceImpl.pathMatchSystem(targetPath)).booleanValue()) {
                    File targetDic = new File(targetPath);
                    targetDic.mkdirs();
                }
                fileNameResult = templateFile.replaceAll(replaceStr, replaceTarget);
                fileNameResult = fileNameResult.replaceAll(CodeGenerateConstant.TABLE_VAR_SPLIT, replaceTarget.replace("_", "-"));
                String outputFileName = targetPath + fileNameResult;
                ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
                FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
                if (!fileNameResult.endsWith(".java")) break block8;
                FileInputStream io = null;
                FileOutputStream out = null;
                try {
                    io = new FileInputStream(new File(outputFileName));
                    String sourceJavaCode = IOUtils.toString((InputStream)io, (String)"utf-8");
                    String formatted = this.javaFormatter.formatSource(sourceJavaCode);
                    out = new FileOutputStream(new File(outputFileName));
                    IOUtils.write((String)formatted, (OutputStream)out, (String)"utf-8");
                }
                catch (Exception e) {
                    try {
                        logger.error(fileNameResult + "\u683c\u5f0f\u5316\u5931\u8d25 " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(io);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)io);
                    IOUtils.closeQuietly(out);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)io);
                IOUtils.closeQuietly((OutputStream)out);
                break block7;
            }
            if (fileNameResult.endsWith(".xml")) {
                // empty if block
            }
        }
    }

    public void produceCodeFile(String templateType, String templateFile, String replaceTarget, String replaceStr, String rootPath, String modelName, String codePath, String appId, CodeTemplateDataBo ctdb) {
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        this.produceCodeFile(templateType, templateFile, replaceTarget, replaceStr, rootPath, modelName, codePath, appInfo, ctdb);
    }

    public static final String getTemplatePath(PaasAppsInfoDTO appInfo, String templateType) {
        String appTemplateId = appInfo.getAppTemplateId();
        File srvDir = new File(SdEnvUtil.TEMPLATE_PATH + File.separator + "allincloud-template" + File.separator + templateType);
        return srvDir.getAbsolutePath();
    }

    public static String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    public static String formatClassPath(String appCode) {
        return appCode.replace(".", "/").replace("-", "/").replace("_", "/");
    }
}

