/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.application.service.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.StdBaseInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.StdRuleInfoRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.StdTaskDetailRepository;
import com.irdstudio.allinrdm.sam.console.acl.repository.StdTaskInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdRuleInfoDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdTaskDetailDO;
import com.irdstudio.allinrdm.sam.console.domain.entity.StdTaskInfoDO;
import com.irdstudio.allinrdm.sam.console.facade.StdTaskInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.StdTaskInfoDTO;
import com.irdstudio.allintpaas.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stdTaskInfoServiceImpl")
public class StdTaskInfoServiceImpl
extends BaseServiceImpl<StdTaskInfoDTO, StdTaskInfoDO, StdTaskInfoRepository>
implements StdTaskInfoService {
    @Autowired
    private SeqInstInfoRepository seqInstInfoRepository;
    @Autowired
    private StdBaseInfoRepository stdBaseInfoRepository;
    @Autowired
    private StdRuleInfoRepository stdRuleInfoRepository;
    @Autowired
    private StdTaskDetailRepository stdTaskDetailRepository;

    @DynamicLog(action=DynamicLog.Action.Add, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].taskId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].taskId} ${args[0].taskName}")
    public int insert(StdTaskInfoDTO paramDTO) {
        if (StringUtils.isBlank((CharSequence)paramDTO.getTaskId())) {
            paramDTO.setTaskId(this.seqInstInfoRepository.nextAndSave("STD-TASK-ID", "\u89c4\u8303\u4efb\u52a1\u7f16\u53f7", "00", "1", "999", "1", "08", "0", "{{owner1}}-STD-{{SEQ}}", "3", "Y", new String[]{paramDTO.getProjectId()}));
        }
        StdRuleInfoDO ruleParam = new StdRuleInfoDO();
        ruleParam.setStdId(paramDTO.getStdId());
        List ruleList = this.stdRuleInfoRepository.queryList((Object)ruleParam);
        if (CollectionUtils.isNotEmpty((Collection)ruleList)) {
            ArrayList<StdTaskDetailDO> detailList = new ArrayList<StdTaskDetailDO>(ruleList.size());
            for (StdRuleInfoDO rule : ruleList) {
                StdTaskDetailDO taskDetail = new StdTaskDetailDO();
                this.beanCopy(rule, taskDetail);
                taskDetail.setTaskDetailId(UUIDUtil.getShortUUID());
                taskDetail.setTaskDetailName(rule.getRuleName());
                taskDetail.setTaskDetailContent(rule.getRuleContent());
                taskDetail.setTaskDetailDesc(rule.getRuleDesc());
                taskDetail.setTaskDetailScene(rule.getRuleScene());
                taskDetail.setTaskDetailCheckType(rule.getRuleCheckType());
                taskDetail.setTaskDetailCheckStage(rule.getRuleCheckStage());
                taskDetail.setTaskDetailDeadlineStage(rule.getRuleDeadlineStage());
                taskDetail.setTaskDetailCheckDate(paramDTO.getStdCheckDate());
                taskDetail.setTaskDetailCheckUser(paramDTO.getStdCheckUser());
                taskDetail.setTaskDetailCheckUserName(paramDTO.getStdCheckUserName());
                taskDetail.setTaskId(paramDTO.getTaskId());
                taskDetail.setCreateUser(paramDTO.getCreateUser());
                taskDetail.setCreateTime(paramDTO.getCreateTime());
                taskDetail.setLastModifyUser(paramDTO.getLastModifyUser());
                taskDetail.setLastModifyTime(paramDTO.getLastModifyTime());
                detailList.add(taskDetail);
            }
            this.stdTaskDetailRepository.batchInsert(detailList);
        }
        return super.insert((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Update, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].taskId}")
    public int updateByPk(StdTaskInfoDTO paramDTO) {
        StdTaskInfoDTO oldData = (StdTaskInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @DynamicLog(action=DynamicLog.Action.Delete, dynamicType=DynamicLog.DynamicLogType.Project, moduleCode="rdm", bizKey="${args[0].taskId}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].taskId} ${args[0].taskName}")
    public int deleteByPk(StdTaskInfoDTO paramDTO) {
        return super.deleteByPk((BaseInfo)paramDTO);
    }
}

