/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.infra.repository.impl;

import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyIssueRepository;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyIssueDO;
import com.irdstudio.allinrdm.admin.console.infra.persistence.mapper.RdmWeeklyInfoMapper;
import com.irdstudio.allinrdm.admin.console.infra.persistence.mapper.RdmWeeklyIssueMapper;
import com.irdstudio.allinrdm.admin.console.infra.persistence.po.RdmWeeklyInfoPO;
import com.irdstudio.allinrdm.admin.console.infra.persistence.po.RdmWeeklyIssuePO;
import com.irdstudio.allinrdm.admin.console.types.WeeklyIssueSrc;
import com.irdstudio.allinrdm.project.console.infra.persistence.mapper.RdmIssueInfoMapper;
import com.irdstudio.allinrdm.project.console.infra.persistence.po.RdmIssueInfoPO;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmWeeklyIssueRepositoryImpl")
public class RdmWeeklyIssueRepositoryImpl
extends BaseRepositoryImpl<RdmWeeklyIssueDO, RdmWeeklyIssuePO, RdmWeeklyIssueMapper>
implements RdmWeeklyIssueRepository {
    @Autowired
    protected RdmWeeklyInfoMapper rdmWeeklyInfoMapper;
    @Autowired
    protected RdmWeeklyIssueMapper rdmWeeklyIssueMapper;
    @Autowired
    protected RdmIssueInfoMapper rdmIssueInfoMapper;

    public int deleteByCond(RdmWeeklyIssueDO param) {
        RdmWeeklyIssuePO rdmWeeklyIssuePO = new RdmWeeklyIssuePO();
        this.beanCopy(param, (Object)rdmWeeklyIssuePO);
        return ((RdmWeeklyIssueMapper)this.getMapper()).deleteByCond(rdmWeeklyIssuePO);
    }

    public int autoFillWeekIssue(RdmWeeklyIssueDO paramDO) {
        String reportId = paramDO.getReportId();
        RdmWeeklyInfoPO reportParam = new RdmWeeklyInfoPO();
        reportParam.setReportId(reportId);
        RdmWeeklyInfoPO reportInfo = (RdmWeeklyInfoPO)((Object)this.rdmWeeklyInfoMapper.queryByPk((Object)reportParam));
        if (reportInfo == null) {
            return 0;
        }
        RdmWeeklyIssuePO checkParam = new RdmWeeklyIssuePO();
        checkParam.setReportId(reportInfo.getReportId());
        List checkList = ((RdmWeeklyIssueMapper)this.getMapper()).queryList((Object)checkParam);
        HashMap<String, RdmWeeklyIssuePO> checkMap = new HashMap<String, RdmWeeklyIssuePO>(checkList.size());
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (RdmWeeklyIssuePO issue : checkList) {
                checkMap.put(issue.getIssueId(), issue);
            }
        }
        ArrayList<RdmWeeklyIssuePO> reportIssueList = new ArrayList<RdmWeeklyIssuePO>();
        RdmIssueInfoPO issueParam = new RdmIssueInfoPO();
        issueParam.setLoginUserId(reportInfo.getInchargeUserId());
        issueParam.setStartDate(reportInfo.getStartDate());
        issueParam.setEndDate(reportInfo.getEndDate());
        List issueList = this.rdmIssueInfoMapper.queryList((Object)issueParam);
        if (CollectionUtils.isNotEmpty((Collection)issueList)) {
            for (RdmIssueInfoPO issue : issueList) {
                if (checkMap.get(issue.getIssueId()) != null) continue;
                RdmWeeklyIssuePO rt = new RdmWeeklyIssuePO();
                this.beanCopy((Object)issue, (Object)rt);
                rt.setReportId(reportInfo.getReportId());
                rt.setWeeklyIssueSrc(WeeklyIssueSrc.Plan.getCode());
                rt.setWeeklyIssueId(UUIDUtil.getShortUUID());
                rt.setIssueId(issue.getIssueId());
                reportIssueList.add(rt);
            }
        }
        if (CollectionUtils.isNotEmpty(reportIssueList)) {
            return ((RdmWeeklyIssueMapper)this.getMapper()).batchInsert(reportIssueList);
        }
        return 0;
    }
}

