/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.admin.console.infra.repository.impl;

import com.irdstudio.allinrdm.admin.console.acl.repository.RdmWeeklyTaskRepository;
import com.irdstudio.allinrdm.admin.console.domain.entity.RdmWeeklyTaskDO;
import com.irdstudio.allinrdm.admin.console.infra.persistence.mapper.RdmWeeklyInfoMapper;
import com.irdstudio.allinrdm.admin.console.infra.persistence.mapper.RdmWeeklyTaskMapper;
import com.irdstudio.allinrdm.admin.console.infra.persistence.po.RdmWeeklyInfoPO;
import com.irdstudio.allinrdm.admin.console.infra.persistence.po.RdmWeeklyTaskPO;
import com.irdstudio.allinrdm.admin.console.types.WeeklyTaskSrc;
import com.irdstudio.allinrdm.project.console.infra.persistence.mapper.RdmObjectiveKrMapper;
import com.irdstudio.allinrdm.project.console.infra.persistence.mapper.RdmTaskInfoMapper;
import com.irdstudio.allinrdm.project.console.infra.persistence.po.RdmObjectiveKrPO;
import com.irdstudio.allinrdm.project.console.infra.persistence.po.RdmTaskInfoPO;
import com.irdstudio.allinrdm.project.console.types.TaskState;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rdmWeeklyTaskRepositoryImpl")
public class RdmWeeklyTaskRepositoryImpl
extends BaseRepositoryImpl<RdmWeeklyTaskDO, RdmWeeklyTaskPO, RdmWeeklyTaskMapper>
implements RdmWeeklyTaskRepository {
    @Autowired
    protected RdmWeeklyInfoMapper rdmWeeklyInfoMapper;
    @Autowired
    protected RdmWeeklyTaskMapper rdmWeeklyTaskMapper;
    @Autowired
    protected RdmTaskInfoMapper rdmTaskInfoMapper;
    @Autowired
    protected RdmObjectiveKrMapper rdmObjectiveKrMapper;

    public int deleteByCond(RdmWeeklyTaskDO param) {
        RdmWeeklyTaskPO rdmWeeklyTaskPO = new RdmWeeklyTaskPO();
        this.beanCopy(param, (Object)rdmWeeklyTaskPO);
        return ((RdmWeeklyTaskMapper)this.getMapper()).deleteByCond(rdmWeeklyTaskPO);
    }

    public int autoFillWeekTask(RdmWeeklyTaskDO paramDO) {
        String reportId = paramDO.getReportId();
        RdmWeeklyInfoPO reportParam = new RdmWeeklyInfoPO();
        reportParam.setReportId(reportId);
        RdmWeeklyInfoPO reportInfo = (RdmWeeklyInfoPO)((Object)this.rdmWeeklyInfoMapper.queryByPk((Object)reportParam));
        if (reportInfo == null) {
            return 0;
        }
        RdmWeeklyTaskPO checkParam = new RdmWeeklyTaskPO();
        checkParam.setReportId(reportInfo.getReportId());
        List checkList = ((RdmWeeklyTaskMapper)this.getMapper()).queryList((Object)checkParam);
        HashMap<String, RdmWeeklyTaskPO> checkMap = new HashMap<String, RdmWeeklyTaskPO>(checkList.size());
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (RdmWeeklyTaskPO task : checkList) {
                checkMap.put(task.getTaskId(), task);
            }
        }
        ArrayList<RdmWeeklyTaskPO> reportTaskList = new ArrayList<RdmWeeklyTaskPO>();
        RdmTaskInfoPO taskParam = new RdmTaskInfoPO();
        taskParam.setLoginUserId(reportInfo.getInchargeUserId());
        taskParam.setStartDate(reportInfo.getReportBeginDate());
        taskParam.setEndDate(reportInfo.getReportEndDate());
        taskParam.setProjectId(reportInfo.getProjectId());
        List taskList = this.rdmTaskInfoMapper.queryList((Object)taskParam);
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            for (RdmTaskInfoPO task : taskList) {
                if (checkMap.get(task.getTaskId()) != null) continue;
                RdmWeeklyTaskPO rt = new RdmWeeklyTaskPO();
                rt.setReportId(reportInfo.getReportId());
                rt.setWeeklyTaskSrc(WeeklyTaskSrc.Plan.getCode());
                rt.setWeeklyTaskTitle(task.getTaskName());
                rt.setWeeklyTaskContent(task.getTaskContent());
                rt.setWeeklyTaskComment(task.getTaskRemark());
                rt.setWeeklyTaskState(task.getTaskState());
                rt.setWeeklyTaskEstWorkload(task.getTaskEstWorkload());
                rt.setWeeklyTaskRealWorkload(task.getTaskRealWorkload());
                rt.setWeeklyTaskId(UUIDUtil.getShortUUID());
                rt.setTaskId(task.getTaskId());
                reportTaskList.add(rt);
            }
        }
        RdmObjectiveKrPO krParam = new RdmObjectiveKrPO();
        krParam.setLoginUserId(reportInfo.getInchargeUserId());
        krParam.setStartDate(reportInfo.getReportBeginDate());
        krParam.setEndDate(reportInfo.getReportEndDate());
        List krList = this.rdmObjectiveKrMapper.queryList((Object)krParam);
        if (CollectionUtils.isNotEmpty((Collection)krList)) {
            for (RdmObjectiveKrPO kr : krList) {
                if (checkMap.get(kr.getKrId()) != null) continue;
                RdmWeeklyTaskPO rt = new RdmWeeklyTaskPO();
                rt.setReportId(reportInfo.getReportId());
                rt.setWeeklyTaskSrc(WeeklyTaskSrc.Plan.getCode());
                rt.setWeeklyTaskTitle(kr.getKrDesc());
                rt.setWeeklyTaskContent(kr.getKrDesc());
                rt.setWeeklyTaskState(StringUtils.equalsAny((CharSequence)kr.getObjectiveState(), (CharSequence[])new CharSequence[]{TaskState.Done.getCode(), TaskState.OverdueDone.getCode()}) ? TaskState.Done.getCode() : TaskState.Processing.getCode());
                rt.setWeeklyTaskEstWorkload(null);
                rt.setWeeklyTaskRealWorkload(null);
                if (kr.getKrRop() != null) {
                    rt.setWeeklyTaskRop(kr.getKrRop());
                }
                rt.setWeeklyTaskId(UUIDUtil.getShortUUID());
                rt.setTaskId(kr.getKrId());
                reportTaskList.add(rt);
            }
        }
        if (CollectionUtils.isNotEmpty(reportTaskList)) {
            return ((RdmWeeklyTaskMapper)this.getMapper()).batchInsert(reportTaskList);
        }
        return 0;
    }
}

