/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dam.console.infra.repository.impl;

import com.irdstudio.allinrdm.dam.console.acl.repository.DictCategoryInfoRepository;
import com.irdstudio.allinrdm.dam.console.domain.entity.DictCategoryInfoDO;
import com.irdstudio.allinrdm.dam.console.infra.persistence.mapper.DictCategoryInfoMapper;
import com.irdstudio.allinrdm.dam.console.infra.persistence.po.DictCategoryInfoPO;
import com.irdstudio.allinrdm.dam.console.types.CategoryPackagePrefix;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Repository;

@Repository(value="dictCategoryInfoRepositoryImpl")
public class DictCategoryInfoRepositoryImpl
extends BaseRepositoryImpl<DictCategoryInfoDO, DictCategoryInfoPO, DictCategoryInfoMapper>
implements DictCategoryInfoRepository,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(DictCategoryInfoRepositoryImpl.class);
    private static Map<String, Queue<String>> packageIdHolder = new ConcurrentHashMap<String, Queue<String>>();

    public int deleteAll(String subsId) {
        int num = 0;
        try {
            num = ((DictCategoryInfoMapper)this.getMapper()).deleteAll(subsId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Map<String, Queue<String>> map = packageIdHolder;
        synchronized (map) {
            if (packageIdHolder.size() == 0) {
                this.growUpPackage(CategoryPackagePrefix.Theme.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.FirstLevel.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.SecondLevel.getCode(), null);
                this.growUpPackage(CategoryPackagePrefix.ThirdLevel.getCode(), null);
            }
        }
    }

    private void growUpPackage(String prefix, Integer last) {
        Queue<String> queue = packageIdHolder.get(prefix);
        if (queue == null) {
            queue = new LinkedList<String>();
            packageIdHolder.put(prefix, queue);
        }
        if (queue.size() == 0) {
            Integer num = last;
            if (last != null) {
                num = last;
            } else {
                DictCategoryInfoPO param = new DictCategoryInfoPO();
                param.setPackageId(prefix);
                DictCategoryInfoPO max = ((DictCategoryInfoMapper)this.getMapper()).queryMaxPackageId(param);
                if (max == null) {
                    max = new DictCategoryInfoPO();
                    max.setPackageId(prefix + "000000");
                }
                String packageId = max.getPackageId();
                num = Integer.valueOf(packageId.substring(prefix.length()));
            }
            for (int i = 1; i <= 100; ++i) {
                String suffix = StringUtils.leftPad((String)String.valueOf(num + i), (int)6, (String)"0");
                queue.add(String.format("%s%s", prefix, suffix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequencePackageId(String prefix) {
        Map<String, Queue<String>> map = packageIdHolder;
        synchronized (map) {
            Queue<String> queue = packageIdHolder.get(prefix);
            String id = queue.poll();
            Integer last = NumberUtils.toInt((String)id.substring(prefix.length()), (int)1);
            if (queue.size() == 0) {
                this.growUpPackage(prefix, last);
            }
            return id;
        }
    }
}

