/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.infra.repository.impl;

import com.irdstudio.allinrdm.dam.console.types.DataMarkFlag;
import com.irdstudio.allinrdm.dev.console.acl.repository.HldDatastdInfoRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.HldDatastdInfoDO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.HldDatastdInfoMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.HldDatastdInfoPO;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@Service(value="hldDatastdInfoRepositoryImpl")
public class HldDatastdInfoRepositoryImpl
extends BaseRepositoryImpl<HldDatastdInfoDO, HldDatastdInfoPO, HldDatastdInfoMapper>
implements HldDatastdInfoRepository {
    public boolean statisticDatastdInfo(String subsId, String userId) {
        boolean flag = true;
        try {
            int sysFieldTotal = ((HldDatastdInfoMapper)this.getMapper()).countFieldStdNum(subsId, null);
            int fullTotal = ((HldDatastdInfoMapper)this.getMapper()).countFieldStdNum(subsId, Arrays.asList(DataMarkFlag.NameToOption.getCode()));
            int partTotal = ((HldDatastdInfoMapper)this.getMapper()).countFieldStdNum(subsId, Arrays.asList(DataMarkFlag.TypeToOption.getCode(), DataMarkFlag.TypeToPrecision.getCode()));
            int reasonTotal = ((HldDatastdInfoMapper)this.getMapper()).countUnableStdNum(subsId);
            int cannotFind = ((HldDatastdInfoMapper)this.getMapper()).countUnusedStdNum(subsId);
            int unusedTotal = 0;
            int innerTotal = 0;
            BigDecimal matchedRatio = new BigDecimal(fullTotal + partTotal + reasonTotal).divide(new BigDecimal(sysFieldTotal), 6, RoundingMode.HALF_UP);
            BigDecimal implementRatio = new BigDecimal(fullTotal + partTotal).divide(new BigDecimal(fullTotal + partTotal + reasonTotal), 6, RoundingMode.HALF_UP);
            HldDatastdInfoPO infoPO = new HldDatastdInfoPO();
            infoPO.setSubsId(subsId);
            infoPO = (HldDatastdInfoPO)((Object)((HldDatastdInfoMapper)this.getMapper()).queryByPk((Object)infoPO));
            boolean update = false;
            if (infoPO == null) {
                infoPO = new HldDatastdInfoPO();
                infoPO.setSubsId(subsId);
            } else {
                update = true;
            }
            infoPO.setDataTime(CurrentDateUtil.getTodayDateEx2());
            infoPO.setFullTotal(fullTotal);
            infoPO.setPartTotal(partTotal);
            infoPO.setReasonTotal(reasonTotal);
            infoPO.setCannotFind(cannotFind);
            infoPO.setUnusedTotal(unusedTotal);
            infoPO.setInnerTotal(innerTotal);
            infoPO.setMatchedRatio(matchedRatio);
            infoPO.setImplementRatio(implementRatio);
            if (update) {
                ((HldDatastdInfoMapper)this.getMapper()).updateByPk((Object)infoPO);
            } else {
                ((HldDatastdInfoMapper)this.getMapper()).batchInsert(Arrays.asList(infoPO));
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u843d\u6807\u7edf\u8ba1\u5f02\u5e38!", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    public int deleteByCond(HldDatastdInfoDO param) {
        return ((HldDatastdInfoMapper)this.getMapper()).deleteByCond((HldDatastdInfoPO)((Object)this.beanCopy(param, HldDatastdInfoPO.class)));
    }
}

