/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.infra.repository.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinrdm.dev.console.acl.repository.OsrvArrangeTableRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.OsrvArrangeTableDO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.OsrvArrangeTableMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.OsrvArrangeVarMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.OsrvEvalIsrvMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.OsrvEvalVarMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.SrvModelConditionMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.SrvModelInfoMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.OsrvArrangeTablePO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.OsrvArrangeVarPO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.OsrvEvalIsrvPO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.OsrvEvalVarPO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.SrvModelConditionPO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.SrvModelInfoPO;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.RowOpType;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="osrvArrangeTableRepositoryImpl")
public class OsrvArrangeTableRepositoryImpl
extends BaseRepositoryImpl<OsrvArrangeTableDO, OsrvArrangeTablePO, OsrvArrangeTableMapper>
implements OsrvArrangeTableRepository {
    @Autowired
    private SrvModelInfoMapper srvModelInfoMapper;
    @Autowired
    private OsrvArrangeVarMapper osrvArrangeVarMapper;
    @Autowired
    private OsrvEvalIsrvMapper osrvEvalIsrvMapper;
    @Autowired
    private OsrvEvalVarMapper osrvEvalVarMapper;
    @Autowired
    private SrvModelConditionMapper srvModelConditionMapper;

    public int deleteByPk(OsrvArrangeTableDO inOsrvArrangeTableDO) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inOsrvArrangeTableDO);
        int num = 0;
        OsrvArrangeTablePO osrvArrangeTable = new OsrvArrangeTablePO();
        this.beanCopy(inOsrvArrangeTableDO, (Object)osrvArrangeTable);
        num = ((OsrvArrangeTableMapper)this.getMapper()).deleteByPk((Object)osrvArrangeTable);
        if (inOsrvArrangeTableDO.getRowOpType() != null && (inOsrvArrangeTableDO.getRowOpType().equals(RowOpType.Serve.getCode()) || inOsrvArrangeTableDO.getRowOpType().equals(RowOpType.TServe.getCode()) || inOsrvArrangeTableDO.getRowOpType().equals(RowOpType.BServe.getCode()) || inOsrvArrangeTableDO.getRowOpType().equals(RowOpType.RServe.getCode()) || inOsrvArrangeTableDO.getRowOpType().equals(RowOpType.SServe.getCode()))) {
            OsrvArrangeVarPO varParam = new OsrvArrangeVarPO();
            varParam.setSrvModelId(inOsrvArrangeTableDO.getSrvModelId());
            varParam.setDomainVarType(DomainVarType.Var.getCode());
            varParam.setTableRowId(inOsrvArrangeTableDO.getTableRowId());
            this.osrvArrangeVarMapper.deleteByTableRowId(varParam);
            OsrvEvalIsrvPO osrvEvalIsrv = new OsrvEvalIsrvPO();
            osrvEvalIsrv.setTableRowId(osrvArrangeTable.getTableRowId());
            this.osrvEvalIsrvMapper.deleteByTableRowId(osrvEvalIsrv);
        }
        OsrvEvalIsrvPO osrvEvalIsrv = new OsrvEvalIsrvPO();
        osrvEvalIsrv.setTableRowId(osrvArrangeTable.getTableRowId());
        this.osrvEvalIsrvMapper.deleteByTableRowId(osrvEvalIsrv);
        OsrvEvalVarPO osrvEvalVar = new OsrvEvalVarPO();
        osrvEvalVar.setTableRowId(osrvArrangeTable.getTableRowId());
        this.osrvEvalVarMapper.deleteByTableRowId(osrvEvalVar);
        SrvModelConditionPO condDelParam = new SrvModelConditionPO();
        condDelParam.setCondRefId(osrvArrangeTable.getTableRowId());
        this.srvModelConditionMapper.deleteByRefId(condDelParam);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inOsrvArrangeTableDO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateByPk(OsrvArrangeTableDO inOsrvArrangeTableDO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inOsrvArrangeTableDO.toString());
        int num = 0;
        OsrvArrangeTablePO osrvArrangeTable = new OsrvArrangeTablePO();
        this.beanCopy(inOsrvArrangeTableDO, (Object)osrvArrangeTable);
        try {
            OsrvArrangeTableDO checkParam = new OsrvArrangeTableDO();
            checkParam.setTableRowId(osrvArrangeTable.getTableRowId());
            OsrvArrangeTableDO checkObj = (OsrvArrangeTableDO)this.queryByPk((BaseInfo)checkParam);
            Map oldMap = (Map)JSON.parseObject((String)checkObj.getRowContent(), Map.class);
            Map newMap = (Map)JSON.parseObject((String)osrvArrangeTable.getRowContent(), Map.class);
            oldMap.putAll(newMap);
            osrvArrangeTable.setRowContent(JSON.toJSONString((Object)oldMap));
        }
        catch (Exception e) {
            logger.error("\u5408\u5e76\u884c\u8be6\u60c5\u5185\u5bb9\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        num = ((OsrvArrangeTableMapper)this.getMapper()).updateByPk((Object)osrvArrangeTable);
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inOsrvArrangeTableDO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateTableRowNo(OsrvArrangeTableDO inOsrvArrangeTableDO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inOsrvArrangeTableDO.toString());
        int num = 0;
        try {
            OsrvArrangeTablePO osrvArrangeTable = new OsrvArrangeTablePO();
            this.beanCopy(inOsrvArrangeTableDO, (Object)osrvArrangeTable);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inOsrvArrangeTableDO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public boolean updateOpTargetName(String projectId, String tableModelId, String tableModelCode, String tableModelName) {
        SrvModelInfoPO srvParam = new SrvModelInfoPO();
        srvParam.setTableModelId(tableModelId);
        List srvs = this.srvModelInfoMapper.queryList((Object)srvParam);
        if (CollectionUtils.isNotEmpty((Collection)srvs)) {
            ArrayList<String> srvModelIds = new ArrayList<String>(srvs.size());
            for (SrvModelInfoPO info : srvs) {
                srvModelIds.add(info.getSrvModelId());
                info.setTableModelCode(tableModelCode);
                info.setTableModelName(tableModelName);
                this.srvModelInfoMapper.updateByPk((Object)info);
            }
            List<OsrvArrangeTablePO> tableRows = ((OsrvArrangeTableMapper)this.getMapper()).queryAllBySrvModelIds(srvModelIds);
            if (CollectionUtils.isEmpty(tableRows)) {
                return true;
            }
            for (OsrvArrangeTablePO row : tableRows) {
                Object[] opNameA;
                String opName = row.getRowOpTargetName();
                if (StringUtils.isBlank((CharSequence)opName) || (opNameA = StringUtils.split((String)opName, (String)"-")) == null || opNameA.length <= 2) continue;
                opNameA[1] = String.format("[%s]", tableModelName);
                opName = StringUtils.join((Object[])opNameA, (String)"-");
                row.setRowOpTargetName(opName);
                OsrvArrangeTablePO updateObj = new OsrvArrangeTablePO();
                updateObj.setTableRowId(row.getTableRowId());
                updateObj.setRowOpTargetName(row.getRowOpTargetName());
                ((OsrvArrangeTableMapper)this.getMapper()).updateByPk((Object)row);
            }
        }
        return false;
    }

    public String dealWithTableOrder(String firstId, String secondId) {
        OsrvArrangeTablePO firstRow = new OsrvArrangeTablePO();
        firstRow.setTableRowId(firstId);
        firstRow = (OsrvArrangeTablePO)((Object)((OsrvArrangeTableMapper)this.getMapper()).queryByPk((Object)firstRow));
        OsrvArrangeTablePO secondRow = new OsrvArrangeTablePO();
        secondRow.setTableRowId(secondId);
        secondRow = (OsrvArrangeTablePO)((Object)((OsrvArrangeTableMapper)this.getMapper()).queryByPk((Object)secondRow));
        if (firstRow == null || secondRow == null) {
            return "\u6392\u5e8f\u5931\u8d25";
        }
        int oldFirstNo = firstRow.getTableRowNo();
        int oldSecondNo = secondRow.getTableRowNo();
        firstRow.setTableRowNo(secondRow.getTableRowNo());
        secondRow.setTableRowNo(oldFirstNo);
        ((OsrvArrangeTableMapper)this.getMapper()).updateByPk((Object)firstRow);
        ((OsrvArrangeTableMapper)this.getMapper()).updateByPk((Object)secondRow);
        this.updateVarFromOrder(firstRow, oldFirstNo);
        this.updateVarFromOrder(secondRow, oldSecondNo);
        return "\u6392\u5e8f\u6210\u529f";
    }

    public Boolean saveTableList(String appId, String srvModelId, List<OsrvArrangeTableDO> list) {
        List<String> ignoreRowContents = Arrays.asList(RowOpType.AssignResult.getCode(), RowOpType.AssignList.getCode());
        for (OsrvArrangeTableDO t : list) {
            if (StringUtils.isBlank((CharSequence)t.getTableRowId())) {
                t.setTableRowId(UUIDUtil.getUUID());
                this.insert(t);
                continue;
            }
            OsrvArrangeTableDO checkParam = new OsrvArrangeTableDO();
            checkParam.setTableRowId(t.getTableRowId());
            OsrvArrangeTableDO checkObj = (OsrvArrangeTableDO)this.queryByPk((BaseInfo)checkParam);
            if (checkObj == null) {
                this.insert(t);
                continue;
            }
            if (ignoreRowContents.contains(t.getRowOpType())) {
                t.setRowContent(null);
            }
            this.updateByPk(t);
        }
        return true;
    }

    private void updateVarFromOrder(OsrvArrangeTablePO row, int oldTableRowNo) {
        OsrvArrangeVarPO varParam = new OsrvArrangeVarPO();
        varParam.setTableRowId(row.getTableRowId());
        List vars = this.osrvArrangeVarMapper.queryList((Object)varParam);
        if (CollectionUtils.isEmpty((Collection)vars)) {
            return;
        }
        for (OsrvArrangeVarPO var : vars) {
            var.setTableRowNo(row.getTableRowNo());
            String varCode = var.getDomainVarCode();
            varCode = varCode.replaceFirst("\\d+$", String.valueOf(row.getTableRowNo()));
            String varName = var.getDomainVarName().replaceFirst("\\[\u5e8f\u53f7\\d+\u51fa\u53c2\\]", String.format("[\u5e8f\u53f7%s\u51fa\u53c2]", row.getTableRowNo()));
            var.setDomainVarName(varName);
            this.osrvArrangeVarMapper.updateByPk((Object)var);
        }
    }
}

