/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.dev.console.infra.repository.impl;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.acl.repository.SrvModelInfoRepository;
import com.irdstudio.allinrdm.dev.console.domain.entity.SrvModelInfoDO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.OsrvArrangeTableMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.SrvModelInfoMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.mapper.SrvModelInoutMapper;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.OsrvArrangeTablePO;
import com.irdstudio.allinrdm.dev.console.infra.persistence.po.SrvModelInfoPO;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="srvModelInfoRepositoryImpl")
public class SrvModelInfoRepositoryImpl
extends BaseRepositoryImpl<SrvModelInfoDO, SrvModelInfoPO, SrvModelInfoMapper>
implements SrvModelInfoRepository {
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private SrvModelInfoMapper srvModelInfoMapper;
    @Autowired
    private SrvModelInoutMapper srvModelInoutMapper;
    @Autowired
    private OsrvArrangeTableMapper osrvArrangeTableMapper;

    public int insert(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + srvModelInfoDO.toString());
        int num = 0;
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        SrvModelInfoPO maxOrder = this.srvModelInfoMapper.queryMaxOrderValue(srvModelInfoPO.getAppId());
        Integer orderValue = 0;
        if (maxOrder != null && maxOrder.getOrderValue() != null) {
            orderValue = maxOrder.getOrderValue();
        }
        orderValue = orderValue + 1;
        srvModelInfoPO.setOrderValue(orderValue);
        SrvModelInfoPO checkObj = (SrvModelInfoPO)((Object)this.srvModelInfoMapper.queryByPk((Object)srvModelInfoPO));
        if (checkObj != null) {
            srvModelInfoPO.setCreateUser(null);
            srvModelInfoPO.setCreateTime(null);
            num = this.srvModelInfoMapper.updateByPk((Object)srvModelInfoPO);
            srvModelInfoPO.setCreateUser(checkObj.getCreateUser());
            srvModelInfoPO.setCreateTime(checkObj.getCreateTime());
        } else {
            num = this.srvModelInfoMapper.insert((Object)srvModelInfoPO);
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int deleteSrvCompileDataById(String srvModelId) {
        logger.debug("\u5220\u9664\u670d\u52a1\u7f16\u6392\u6570\u636e " + srvModelId);
        int num = this.srvModelInfoMapper.deleteSrvCompileDataById(srvModelId);
        return num;
    }

    public int deleteSpareData() {
        logger.debug("\u5f53\u524d\u6b63\u5728\u5220\u591a\u4f59\u7684\u670d\u52a1\u5f00\u53d1\u9664\u6570\u636e");
        int num = 0;
        num = this.srvModelInfoMapper.deleteSpareData();
        if (num > 0) {
            this.srvModelInoutMapper.deleteSpareData();
        }
        logger.debug("\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteSrvCompileData() {
        logger.debug("\u5f53\u524d\u6b63\u5728\u5220\u591a\u4f59\u7684\u670d\u52a1\u7f16\u6392\u9664\u6570\u636e");
        int num = 0;
        num = this.srvModelInfoMapper.deleteSrvCompileData();
        logger.debug("\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateByPk(SrvModelInfoDO inAppModelInfoDO) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inAppModelInfoDO.toString());
        int num = 0;
        SrvModelInfoPO srvModelInfo = new SrvModelInfoPO();
        this.beanCopy(inAppModelInfoDO, (Object)srvModelInfo);
        num = this.srvModelInfoMapper.updateByPk((Object)srvModelInfo);
        OsrvArrangeTablePO tableParam = new OsrvArrangeTablePO();
        tableParam.setRowOpTargetId(srvModelInfo.getSrvModelId());
        List refList = this.osrvArrangeTableMapper.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)refList)) {
            for (OsrvArrangeTablePO tb : refList) {
                String opName = tb.getRowOpTargetName();
                if (StringUtils.isBlank((CharSequence)opName)) continue;
                Object[] opNameA = StringUtils.split((String)opName, (String)"-");
                opNameA[opNameA.length - 1] = String.format("[%s]", srvModelInfo.getSrvModelName());
                opName = StringUtils.join((Object[])opNameA, (String)"-");
                tb.setRowOpTargetName(opName);
                OsrvArrangeTablePO updateObj = new OsrvArrangeTablePO();
                updateObj.setTableRowId(tb.getTableRowId());
                updateObj.setRowOpTargetName(tb.getRowOpTargetName());
                this.osrvArrangeTableMapper.updateByPk((Object)tb);
            }
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inAppModelInfoDO + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int batchUpdateSrvModelOpen(List<SrvModelInfoDO> modelList) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + modelList.size());
        int num = 0;
        num = this.srvModelInfoMapper.batchUpdateSrvModelOpen(this.beansCopy(modelList, SrvModelInfoPO.class));
        logger.debug("\u6839\u636e\u6761\u4ef6: \u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public List<SrvModelInfoDO> queryAllIsolateSrvByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        try {
            List<SrvModelInfoPO> appModelInfos = this.srvModelInfoMapper.queryAllIsolateSrvByPage(srvModelInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + appModelInfos.size());
            this.pageSet(appModelInfos, srvModelInfoPO);
            list = this.beansCopy(appModelInfos, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<SrvModelInfoDO> queryAllIsolateSrv(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        try {
            List<SrvModelInfoPO> appModelInfos = this.srvModelInfoMapper.queryAllIsolateSrv(srvModelInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + appModelInfos.size());
            this.pageSet(appModelInfos, srvModelInfoPO);
            list = this.beansCopy(appModelInfos, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public Integer deleteAllAppData(SrvModelInfoDO param) {
        return ((SrvModelInfoMapper)this.getMapper()).deleteAllAppData((SrvModelInfoPO)((Object)this.beanCopy(param, SrvModelInfoPO.class)));
    }

    public List<SrvModelInfoDO> queryTableModelIds(SrvModelInfoDO srvModelInfo) {
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfo, (Object)srvModelInfoPO);
        List<SrvModelInfoPO> tableModelIds = this.srvModelInfoMapper.queryAllIsolateSrvByPage(srvModelInfoPO);
        return this.beansCopy(tableModelIds, SrvModelInfoDO.class);
    }

    public List<SrvModelInfoDO> querySrvModelOnSysCodeByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        try {
            List<SrvModelInfoPO> appModelInfos = this.srvModelInfoMapper.querySrvModelOnSysCodeByPage(srvModelInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + appModelInfos.size());
            this.pageSet(appModelInfos, srvModelInfoPO);
            list = this.beansCopy(appModelInfos, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<SrvModelInfoDO> queryModelSrvByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        try {
            List<SrvModelInfoPO> appModelInfos = this.srvModelInfoMapper.queryModelSrvByPage(srvModelInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + appModelInfos.size());
            this.pageSet(appModelInfos, srvModelInfoPO);
            list = this.beansCopy(appModelInfos, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public SrvModelInfoDO queryByTableModelId(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + srvModelInfoDO);
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        try {
            SrvModelInfoPO srvModelInfo2 = this.srvModelInfoMapper.queryByTableModelIdByPage(srvModelInfoPO);
            if (Objects.nonNull((Object)srvModelInfo2)) {
                SrvModelInfoDO srvModelInfo2DO = (SrvModelInfoDO)this.beanCopy((Object)srvModelInfo2, new SrvModelInfoDO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + srvModelInfo2DO.toString());
                return srvModelInfo2DO;
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<SrvModelInfoDO> querySrvModelInfoRefByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        List<SrvModelInfoPO> srvModelInfoRefs = this.srvModelInfoMapper.querySrvModelInfoRefByPage(srvModelInfoPO);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + srvModelInfoRefs.size());
        List list = null;
        try {
            this.pageSet(srvModelInfoRefs, srvModelInfoPO);
            list = this.beansCopy(srvModelInfoRefs, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<SrvModelInfoDO> queryFuncInfoRefByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        List<SrvModelInfoPO> srvModelInfoRefs = this.srvModelInfoMapper.queryFuncInfoRefByPage(srvModelInfoPO);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + srvModelInfoRefs.size());
        List list = null;
        try {
            this.pageSet(srvModelInfoRefs, (BaseInfo)srvModelInfoDO);
            list = this.beansCopy(srvModelInfoRefs, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<SrvModelInfoDO> queryTableRefSrvRefByPage(SrvModelInfoDO srvModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        SrvModelInfoPO srvModelInfoPO = new SrvModelInfoPO();
        this.beanCopy(srvModelInfoDO, (Object)srvModelInfoPO);
        List<SrvModelInfoPO> srvModelInfoRefs = this.srvModelInfoMapper.queryTableRefSrvRefByPage(srvModelInfoPO);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + srvModelInfoRefs.size());
        List list = null;
        try {
            this.pageSet(srvModelInfoRefs, (BaseInfo)srvModelInfoDO);
            list = this.beansCopy(srvModelInfoRefs, SrvModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public Map<String, Object> queryAppsIndexSummary(String appId) {
        int num;
        String type;
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        List<Map<String, Object>> tableSummary = this.srvModelInfoMapper.queryModelInfoCount(appId);
        List<Map<String, Object>> srvSummary = this.srvModelInfoMapper.querySrvModelInfoCount(appId);
        HashMap<String, Object> summary = new HashMap<String, Object>();
        int tbNum = 0;
        int tbDataNum = 0;
        int isrvNum = 0;
        boolean osrvNum = false;
        int osrvFNum = 0;
        int osrvBNum = 0;
        int innerOsrvNum = 0;
        int compNum = 0;
        int isrvOpenNum = 0;
        int osrvOpenNum = 0;
        int innerOsrvOpenNum = 0;
        for (Map<String, Object> map : tableSummary) {
            type = MapUtils.getString(map, (Object)"object_type");
            num = MapUtils.getIntValue(map, (Object)"num", (int)0);
            if (type.equals(ObjectType.Table.getCode())) {
                tbNum = num;
                continue;
            }
            if (!type.equals(ObjectType.Data.getCode()) && !type.equals(ObjectType.FreeStyleData.getCode()) && !type.equals(ObjectType.Main.getCode()) && !type.equals(ObjectType.Second.getCode()) && !type.equals(ObjectType.Inout.getCode())) continue;
            tbDataNum += num;
        }
        for (Map<String, Object> map : srvSummary) {
            type = MapUtils.getString(map, (Object)"srv_model_catalog");
            num = MapUtils.getIntValue(map, (Object)"num", (int)0);
            if (type.equals(SrvModelCatalogEnum.SrvServer.getCode())) {
                isrvNum += num;
                continue;
            }
            if (type.equals(SrvModelCatalogEnum.ComponentServer.getCode())) {
                innerOsrvNum += num;
                continue;
            }
            if (type.equals(SrvModelCatalogEnum.BackServer.getCode())) {
                osrvBNum += num;
                continue;
            }
            if (type.equals(SrvModelCatalogEnum.TradeServer.getCode())) {
                osrvFNum += num;
                continue;
            }
            if (!type.equals(SrvModelCatalogEnum.SdkServer.getCode())) continue;
            compNum += num;
        }
        summary.put("tbNum", tbNum);
        summary.put("tbDataNum", tbDataNum);
        summary.put("isrvNum", isrvNum);
        summary.put("osrvNum", osrvFNum + osrvBNum);
        summary.put("osrvFNum", osrvFNum);
        summary.put("osrvBNum", osrvBNum);
        summary.put("innerOsrvNum", innerOsrvNum);
        summary.put("compNum", compNum);
        summary.put("isrvOpenNum", isrvOpenNum);
        summary.put("osrvOpenNum", osrvOpenNum);
        summary.put("innerOsrvOpenNum", innerOsrvOpenNum);
        return summary;
    }

    public Map<String, Object> queryAppsIndexGroupSummary(String subsId, String bizDbName) {
        List<Map<String, Object>> tableSummary = this.srvModelInfoMapper.queryModelInfoGroupCount(subsId, bizDbName);
        HashMap<String, Object> summary = new HashMap<String, Object>();
        int tbNum = 0;
        int tbDataNum = 0;
        for (Map<String, Object> map : tableSummary) {
            String type = MapUtils.getString(map, (Object)"object_type");
            int num = MapUtils.getIntValue(map, (Object)"num", (int)0);
            if (type.equals(ObjectType.Table.getCode())) {
                tbNum = num;
                continue;
            }
            if (!type.equals(ObjectType.Data.getCode()) && !type.equals(ObjectType.FreeStyleData.getCode()) && !type.equals(ObjectType.Main.getCode()) && !type.equals(ObjectType.Second.getCode()) && !type.equals(ObjectType.Inout.getCode())) continue;
            tbDataNum += num;
        }
        summary.put("tbNum", tbNum);
        summary.put("tbDataNum", tbDataNum);
        return summary;
    }

    public int mergeAppByAppId(String originalAppId, String targetAppId, List<Map<String, Object>> adjustContentList) {
        SrvModelInfoPO srvParam = new SrvModelInfoPO();
        srvParam.setAppId(originalAppId);
        srvParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        srvParam.setSize(50);
        List srvList = this.srvModelInfoMapper.queryListByPage((Object)srvParam);
        PaasAppsInfoDTO originApp = new PaasAppsInfoDTO();
        originApp.setAppId(originalAppId);
        originApp = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)originApp);
        PaasAppsInfoDTO targetApp = new PaasAppsInfoDTO();
        targetApp.setAppId(targetAppId);
        targetApp = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)targetApp);
        if (CollectionUtils.isNotEmpty((Collection)srvList)) {
            for (SrvModelInfoPO srv : srvList) {
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("desc", "\u7ec4\u4ef6\u670d\u52a1");
                content.put("beforeContent", String.format("%s[%s]\u670d\u52a1%s[%s]", originApp.getAppName(), originApp.getAppCode(), srv.getSrvModelName(), srv.getSrvModelCode()));
                content.put("afterContent", String.format("%s[%s]\u670d\u52a1%s[%s]", targetApp.getAppName(), targetApp.getAppCode(), srv.getSrvModelName(), srv.getSrvModelCode()));
                adjustContentList.add(content);
            }
        }
        return this.srvModelInfoMapper.mergeAppByAppId(originalAppId, targetAppId);
    }
}

