/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinrdm.sam.console.infra.repository.impl;

import com.irdstudio.allinrdm.sam.console.acl.repository.FnModelInfoRepository;
import com.irdstudio.allinrdm.sam.console.domain.entity.FnModelInfoDO;
import com.irdstudio.allinrdm.sam.console.infra.persistence.mapper.FnModelInfoMapper;
import com.irdstudio.allinrdm.sam.console.infra.persistence.po.FnModelInfoPO;
import com.irdstudio.allinrdm.sam.console.types.FnType;
import com.irdstudio.sdk.beans.core.base.BaseRepositoryImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="fnModelInfoRepositoryImpl")
public class FnModelInfoRepositoryImpl
extends BaseRepositoryImpl<FnModelInfoDO, FnModelInfoPO, FnModelInfoMapper>
implements FnModelInfoRepository {
    public int deleteBySubsId(String subsId) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + subsId);
        int num = 0;
        try {
            num = ((FnModelInfoMapper)this.getMapper()).deleteBySubsId(subsId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + subsId + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int deleteByModuleId(FnModelInfoDO fnModelInfoDO) {
        int num = 0;
        try {
            FnModelInfoPO hldFnInfo = new FnModelInfoPO();
            this.beanCopy(fnModelInfoDO, (Object)hldFnInfo);
            List children = ((FnModelInfoMapper)this.getMapper()).queryList((Object)hldFnInfo);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                for (FnModelInfoPO fn : children) {
                    num = ((FnModelInfoMapper)this.getMapper()).deleteByPk((Object)hldFnInfo);
                    num += this.recursionDeleteFn(hldFnInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + fnModelInfoDO + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public Integer queryMaxOrderBySubsId(String subsId, String fnAbvId) {
        return ((FnModelInfoMapper)this.getMapper()).queryMaxOrderBySubsId(subsId, fnAbvId);
    }

    public Integer deleteByCond(FnModelInfoDO param) {
        return ((FnModelInfoMapper)this.getMapper()).deleteByCond((FnModelInfoPO)((Object)this.beanCopy(param, FnModelInfoPO.class)));
    }

    public String queryCodeWithPrefix(String subsId, String fnType2) {
        String seq;
        String result = "";
        String prefix = FnType.Create.getPrefix();
        result = ((FnModelInfoMapper)this.getMapper()).queryCodeWithPrefix(subsId, prefix);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = prefix + "0001";
        }
        String numStr = StringUtils.replace((String)result, (String)prefix, (String)"");
        int num = Integer.parseInt(numStr);
        result = seq = prefix + StringUtils.leftPad((String)String.valueOf(num + 1), (int)4, (String)"0");
        return result;
    }

    private int recursionDeleteFn(FnModelInfoPO hldFnInfo) {
        String fnId = hldFnInfo.getFnId();
        FnModelInfoPO param = new FnModelInfoPO();
        param.setFnAbvId(fnId);
        List children = ((FnModelInfoMapper)this.getMapper()).queryList((Object)param);
        int count = 0;
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (FnModelInfoPO fn : children) {
                count = ((FnModelInfoMapper)this.getMapper()).deleteByPk((Object)fn);
                count += this.recursionDeleteFn(fn);
            }
        }
        return count;
    }

    public List<FnModelInfoDO> queryPaasAppInfo(FnModelInfoDO fnModelInfoDO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            FnModelInfoPO queryFnModelInfoPO = new FnModelInfoPO();
            this.beanCopy(fnModelInfoDO, (Object)queryFnModelInfoPO);
            List<FnModelInfoPO> hldFnInfos = ((FnModelInfoMapper)this.getMapper()).queryPaasAppInfo(queryFnModelInfoPO);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + hldFnInfos.size());
            list = this.beansCopy(hldFnInfos, FnModelInfoDO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

