/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinsaas.portal.facade.filter;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinsaas.portal.facade.AllinCloudPortalClient;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.ssm.session.SessionManager;
import com.irdstudio.sdk.ssm.util.GsonUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.validation.AssertionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4AWXFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4AWXFilter.class);
    private SessionManager sessionManager;
    private AllinCloudPortalClient portalService;
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
        try {
            this.portalService = (AllinCloudPortalClient)applicationcontext.getBean(AllinCloudPortalClient.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.debug("AllinCloudPortalClient bean \u672a\u5b9a\u4e49\uff0c\u5c06\u4f7f\u7528 sessionManager \u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u3002 {}", (Object)e.getMessage());
        }
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        String requestPath = request.getServletPath();
        Object authInfo = null;
        String ssoClient = request.getHeader("ssoclient");
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        if (StringUtils.isNotBlank((CharSequence)ssoClient)) {
            UserInfo userInfo = null;
            if (this.portalService == null) {
                com.irdstudio.sdk.ssm.vo.UserInfo adminUser = this.sessionManager.getLoginInfo(ssoClient);
                userInfo = (UserInfo)JSON.parseObject((String)JSON.toJSONString((Object)adminUser), UserInfo.class);
            } else {
                userInfo = this.portalService.sessionInfo(ssoClient);
            }
            if (userInfo != null) {
                com.irdstudio.sdk.ssm.vo.UserInfo ssmUser = (com.irdstudio.sdk.ssm.vo.UserInfo)JSON.parseObject((String)JSON.toJSONString((Object)userInfo), com.irdstudio.sdk.ssm.vo.UserInfo.class);
                this.sessionManager.setLoginInfo(ssmUser, request);
                AssertionImpl assertion = new AssertionImpl(userInfo.getUserId());
                session.setAttribute(CONST_CAS_ASSERTION, (Object)assertion);
            } else {
                response.setStatus(401);
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                ResponseData data = new ResponseData();
                data.createData((Object)false, "911", "\u4f1a\u8bdd\u5df2\u5931\u6548", false);
                String outputmessage = GsonUtils.toJson((Object)data);
                try (PrintWriter rsp = response.getWriter();){
                    rsp.write(outputmessage);
                }
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    public static Map<String, String> parseQuerystring(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (name == "") continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1].replaceAll("%20", "%2b"), "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return map;
    }
}

