/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.conf.application.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinschedule.console.admin.acl.repository.SAgentInfoRepository;
import com.irdstudio.allinschedule.console.admin.domain.entity.SAgentInfoDO;
import com.irdstudio.allinschedule.console.conf.acl.repository.BatchConfMasterRepository;
import com.irdstudio.allinschedule.console.conf.acl.repository.BatchConfTaskRepository;
import com.irdstudio.allinschedule.console.conf.acl.repository.BatchConfValidateRepository;
import com.irdstudio.allinschedule.console.conf.acl.repository.PluginConfMasterRepository;
import com.irdstudio.allinschedule.console.conf.domain.entity.BatchConfMasterDO;
import com.irdstudio.allinschedule.console.conf.domain.entity.BatchConfTaskDO;
import com.irdstudio.allinschedule.console.conf.domain.entity.BatchConfValidateDO;
import com.irdstudio.allinschedule.console.conf.domain.entity.PluginConfMasterDO;
import com.irdstudio.allinschedule.console.conf.facade.operation.BatchConfValidateService;
import com.irdstudio.allinschedule.console.conf.facade.operation.dto.BatchConfValidateDTO;
import com.irdstudio.allinschedule.console.conf.types.BatchState;
import com.irdstudio.allinschedule.console.conf.types.ValidRe;
import com.irdstudio.allinschedule.console.manual.facade.operation.dto.PluginExecutorDTO;
import com.irdstudio.allinschedule.console.manual.facade.operation.dto.ValidateRtnDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="BatchConfValidateServiceImpl")
public class BatchConfValidateServiceImpl
extends BaseServiceImpl<BatchConfValidateDTO, BatchConfValidateDO, BatchConfValidateRepository>
implements BatchConfValidateService {
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();
    @Autowired
    private SAgentInfoRepository sAgentInfoRepository;
    @Autowired
    private BatchConfMasterRepository batBatchInfoConfigRepository;
    @Autowired
    private BatchConfTaskRepository batTaskUnitConfigRepository;
    @Autowired
    private PluginConfMasterRepository pluginDefineRepository;
    private HttpClient httpClient = HttpClients.createDefault();

    public int insertSingle(BatchConfValidateDTO input) {
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(BatchConfValidateDTO input) {
        int output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public BatchConfValidateDTO queryByPk(BatchConfValidateDTO input) {
        BatchConfValidateDTO output = (BatchConfValidateDTO)super.queryByPk((BaseInfo)input);
        return output;
    }

    public int deleteByPk(BatchConfValidateDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String batchId, String userId) {
        BatchConfValidateService selfService = (BatchConfValidateService)SpringContextUtils.getBean(BatchConfValidateService.class);
        BatchConfValidateDTO delParam = new BatchConfValidateDTO();
        delParam.setBatchId(batchId);
        selfService.deleteByPk(delParam);
        BatchConfTaskDO taskParam = new BatchConfTaskDO();
        taskParam.setBatchId(batchId);
        List taskList = this.batTaskUnitConfigRepository.queryList((Object)taskParam);
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            taskDebounce.put(batchId, true);
            BatchConfMasterDO batchInfo = new BatchConfMasterDO();
            batchInfo.setBatchId(batchId);
            batchInfo = (BatchConfMasterDO)this.batBatchInfoConfigRepository.queryByPk((Object)batchInfo);
            if (batchInfo == null) {
                throw new RuntimeException("\u6279\u6b21\u4fe1\u606f\u4e3a\u7a7a");
            }
            SAgentInfoDO agentInfo = new SAgentInfoDO();
            agentInfo.setAgentId(batchInfo.getAgentId());
            agentInfo = (SAgentInfoDO)this.sAgentInfoRepository.queryByPk((Object)agentInfo);
            if (agentInfo == null) {
                throw new RuntimeException("\u6279\u6b21\u6267\u884c\u5668\u672a\u6307\u5b9a");
            }
            try {
                BatchConfValidateDTO valid;
                boolean validFlag = true;
                String now = CurrentDateUtil.getTodayDateEx2();
                ArrayList<BatchConfValidateDTO> validate = new ArrayList<BatchConfValidateDTO>(taskList.size());
                for (BatchConfTaskDO task : taskList) {
                    valid = new BatchConfValidateDTO();
                    valid.setBatchId(batchId);
                    valid.setTaskId(task.getTaskId());
                    valid.setValidTime(now);
                    valid.setCreateTime(now);
                    valid.setCreateUser(userId);
                    validate.add(valid);
                }
                selfService.batchInsert(validate);
                for (int i = 0; i < taskList.size(); ++i) {
                    BatchConfTaskDO task;
                    task = (BatchConfTaskDO)taskList.get(i);
                    valid = (BatchConfValidateDTO)validate.get(i);
                    PluginConfMasterDO pluginInfo = new PluginConfMasterDO();
                    pluginInfo.setPluginId(task.getPluginId());
                    pluginInfo = (PluginConfMasterDO)this.pluginDefineRepository.queryByPk((Object)pluginInfo);
                    if (pluginInfo == null) {
                        valid.setValidRe(ValidRe.Fail.getCode());
                        valid.setValidMsg("\u4efb\u52a1\u672a\u6307\u5b9a\u63d2\u4ef6");
                        valid.setValidTime(CurrentDateUtil.getTodayDateEx2());
                        this.insert((BaseInfo)valid);
                        continue;
                    }
                    PluginExecutorDTO validateParam = new PluginExecutorDTO();
                    validateParam.setBatchId(batchId);
                    validateParam.setTaskId(task.getTaskId());
                    validateParam.setPluginClass(pluginInfo.getPluginClass());
                    ResponseData<ValidateRtnDTO> resp = this.requestExecutorValidateApi(agentInfo, validateParam);
                    if (resp.isSuccess()) {
                        valid.setValidRe(ValidRe.Pass.getCode());
                        valid.setValidMsg("\u6821\u9a8c\u6210\u529f");
                    } else {
                        validFlag = false;
                        valid.setValidRe(ValidRe.Fail.getCode());
                        if (resp.getRows() != null) {
                            valid.setValidMsg(String.format("%s%s", StringUtils.join((Iterable)((ValidateRtnDTO)resp.getRows()).getMessage(), (String)","), ((ValidateRtnDTO)resp.getRows()).getErrorMsgSuffix()));
                        } else {
                            valid.setValidMsg(resp.getMessage());
                        }
                    }
                    valid.setValidTime(CurrentDateUtil.getTodayDateEx2());
                    this.insert((BaseInfo)valid);
                }
                if (validFlag) {
                    BatchConfMasterDO batchUpdate = new BatchConfMasterDO();
                    batchUpdate.setBatchId(batchId);
                    batchUpdate.setBatchState(BatchState.Validated.getCode());
                    this.batBatchInfoConfigRepository.updateByPk((Object)batchUpdate);
                }
                boolean bl = validFlag;
                return bl;
            }
            finally {
                taskDebounce.put(batchId, false);
            }
        }
        return false;
    }

    public boolean validateStat(String batchId) {
        return (Boolean)taskDebounce.get(batchId);
    }

    public ResponseData<ValidateRtnDTO> requestExecutorValidateApi(SAgentInfoDO agentInfo, PluginExecutorDTO validateParam) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(String.format("%s/plugin/validate", agentInfo.getAgentUrl()));
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)validateParam);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return (ResponseData)JSON.parseObject((String)json, ResponseData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

