/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.application.operation;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.irdstudio.allinschedule.console.admin.facade.operation.PaasAppsInfoService;
import com.irdstudio.allinschedule.console.admin.facade.operation.dto.PaasAppsInfoDTO;
import com.irdstudio.allinschedule.console.conf.domain.entity.JobBaseInfoDO;
import com.irdstudio.allinschedule.console.dev.acl.repository.JobBaseInfoRepository;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.CodeTemplateData;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.CodeTemplateRepoPullTask;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.SdEnvUtil;
import com.irdstudio.allinschedule.console.dev.facade.operation.JobBaseInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.JobSqlInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.JobBaseInfoDTO;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.JobSqlInfoDTO;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.FileUtil;
import com.irdstudio.framework.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jobBaseInfoServiceImpl")
public class JobBaseInfoServiceImpl
extends BaseServiceImpl<JobBaseInfoDTO, JobBaseInfoDO, JobBaseInfoRepository>
implements JobBaseInfoService,
FrameworkService {
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private RdmModuleInfoService rdmModuleInfoService;
    @Autowired
    private JobSqlInfoService jobSqlInfoService;
    Formatter javaFormatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());
    public static String TABLE_VAR_NOSPLIT = "XXX";
    public static String TABLE_VAR_SPLIT = "X-X-X";

    public Integer deleteByCond(JobBaseInfoDTO param) {
        return ((JobBaseInfoRepository)this.getRepository()).deleteByCond((JobBaseInfoDO)this.beanCopy(param, JobBaseInfoDO.class));
    }

    public Boolean generateCode(JobBaseInfoDTO job) {
        String appId = job.getAppId();
        String jobId = job.getJobId();
        String jobCode = job.getJobCode();
        try {
            CodeTemplateData codeData = new CodeTemplateData();
            codeData.setParamMap(new HashMap<String, Object>());
            codeData.getParamMap().put("jobInfo", job);
            codeData.setClassName(TmModelUtil.tableCodeToClassName((String)jobCode));
            codeData.setClassDesc(job.getJobDesc());
            codeData.setNowTime(CurrentDateUtil.getTodayDate());
            JobSqlInfoDTO sqlParam = new JobSqlInfoDTO();
            sqlParam.setJobId(jobId);
            List sqlList = this.jobSqlInfoService.queryList((Object)sqlParam);
            codeData.getParamMap().put("jobSqlInfoList", sqlList);
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = this.paasAppsInfoService.queryByPk(appInfo);
            CodeTemplateRepoPullTask templateTask = new CodeTemplateRepoPullTask();
            templateTask.syncRun();
            HashMap appsParam = new HashMap();
            String packagePrefixVal = "com.irdstudio";
            if (StringUtils.isNotBlank((CharSequence)MapUtils.getString(appsParam, (Object)"package_prefix"))) {
                packagePrefixVal = MapUtils.getString(appsParam, (Object)"package_prefix");
            }
            String comFeatureCodePackage = "";
            RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
            moduleInfo.setModuleId(job.getModuleId());
            moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
            if (moduleInfo != null) {
                comFeatureCodePackage = moduleInfo.getFeatureCode();
                packagePrefixVal = moduleInfo.getOrgCode();
            } else {
                comFeatureCodePackage = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
            }
            String appCodePackage = (packagePrefixVal + "." + comFeatureCodePackage).replaceAll("_|\\.|-", "/");
            CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
            ctdb.getMapData().put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
            ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
            ctdb.getMapData().put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "."));
            ctdb.getMapData().put("appsParam", appsParam);
            List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-infrastructure/src/main/resources/mybatis/mapper/${appCodePackage}/", "XXXMapperImpl.xml", "${appCode}-application/src/main/java/${appCodePackage}/application/operation/", "XXXServiceImpl.java");
            HashMap<String, String> expMap = new HashMap<String, String>();
            expMap.put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
            expMap.put("appCodePackage", appCodePackage);
            expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
            for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
                String path = mainCodeTemplateFiles.get(i);
                String templateFile = mainCodeTemplateFiles.get(i + 1);
                String targetPath = ExpressionUtil.parse((String)path, expMap);
                ctdb.getMapData().put("codeData", codeData);
                this.produceCodeFile("job", templateFile, codeData.getClassName(), "XXX", jobCode, null, targetPath, appInfo, ctdb);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("{}\u4efb\u52a1\u4ee3\u7801\u751f\u6210\u5f02\u5e38{}", new Object[]{jobId, e.getMessage(), e});
            return false;
        }
    }

    public static final String getTemplatePath(PaasAppsInfoDTO appInfo, String templateType) {
        String appTemplateId = appInfo.getAppTemplateId();
        File srvDir = new File(SdEnvUtil.TEMPLATE_PATH + File.separator + "allincloud-template" + File.separator + templateType);
        return srvDir.getAbsolutePath();
    }

    public static String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceCodeFile(String templateType, String templateFile, String replaceTarget, String replaceStr, String rootPath, String modelName, String codePath, PaasAppsInfoDTO appInfo, CodeTemplateDataBo ctdb) {
        block7: {
            String fileNameResult;
            block8: {
                String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
                String templatePath = JobBaseInfoServiceImpl.getTemplatePath(appInfo, templateType);
                ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
                String targetPath = SdEnvUtil.PROJECT_PATH + rootPath + File.separator + String.format("%s-%s", appCode, modelName).replace(".", "-") + File.separator + codePath;
                if (modelName == null) {
                    targetPath = SdEnvUtil.PROJECT_PATH + rootPath + File.separator + codePath;
                }
                if (!FileUtil.checkFileExist((String)(targetPath = JobBaseInfoServiceImpl.pathMatchSystem(targetPath))).booleanValue()) {
                    File targetDic = new File(targetPath);
                    targetDic.mkdirs();
                }
                fileNameResult = templateFile.replaceAll(replaceStr, replaceTarget);
                fileNameResult = fileNameResult.replaceAll(TABLE_VAR_SPLIT, replaceTarget.replace("_", "-"));
                String outputFileName = targetPath + fileNameResult;
                ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
                FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
                if (!fileNameResult.endsWith(".java")) break block8;
                FileInputStream io = null;
                FileOutputStream out = null;
                try {
                    io = new FileInputStream(new File(outputFileName));
                    String sourceJavaCode = IOUtils.toString((InputStream)io, (String)"utf-8");
                    String formatted = this.javaFormatter.formatSource(sourceJavaCode);
                    out = new FileOutputStream(new File(outputFileName));
                    IOUtils.write((String)formatted, (OutputStream)out, (String)"utf-8");
                }
                catch (Exception e) {
                    try {
                        logger.error(fileNameResult + "\u683c\u5f0f\u5316\u5931\u8d25 " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(io);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)io);
                    IOUtils.closeQuietly(out);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)io);
                IOUtils.closeQuietly((OutputStream)out);
                break block7;
            }
            if (fileNameResult.endsWith(".xml")) {
                // empty if block
            }
        }
    }

    public void produceCodeFile(String templateType, String templateFile, String replaceTarget, String replaceStr, String rootPath, String modelName, String codePath, String appId, CodeTemplateDataBo ctdb) {
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = this.paasAppsInfoService.queryByPk(appInfo);
        this.produceCodeFile(templateType, templateFile, replaceTarget, replaceStr, rootPath, modelName, codePath, appInfo, ctdb);
    }
}

