/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.application.operation.generate;

import com.irdstudio.allinschedule.console.dev.facade.operation.PaasTaskHisService;
import com.irdstudio.allinschedule.console.dev.facade.operation.PaasTaskInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.PaasTaskHisDTO;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.PaasTaskInfoDTO;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaTask.class);
    public static final int TASK_STATE_RUNNING = 2;
    public static final int TASK_STATE_SUCCESS = 6;
    public static final int TASK_STATE_FAILD = 7;
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();

    public void updateMetaTask(PaasTaskInfoDTO taskInfo, ExecuteRtnInfo rtn) {
        int state;
        PaasTaskInfoService paasTaskInfoService = (PaasTaskInfoService)SpringContextUtils.getBean(PaasTaskInfoService.class);
        PaasTaskHisService paasTaskHisService = (PaasTaskHisService)SpringContextUtils.getBean(PaasTaskHisService.class);
        taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        if (rtn != null) {
            state = rtn.isSuccessFlag() ? 6 : 7;
            taskInfo.setTaskState(String.valueOf(state));
            if (StringUtils.isNotBlank((CharSequence)rtn.getFailReason())) {
                taskInfo.setTaskErrorMsg(rtn.getFailReason());
            }
            String startTime = taskInfo.getStartTime();
            String endTime = taskInfo.getEndTime();
            try {
                Date startDate = DateUtils.parseDate((String)startTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                Date endData = DateUtils.parseDate((String)endTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                long costTime = endData.getTime() - startDate.getTime();
                BigDecimal re = new BigDecimal(costTime).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                taskInfo.setCostTime(re);
            }
            catch (Exception e) {
                logger.error("\u8fd0\u884c\u8017\u65f6\u8ba1\u7b97\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            }
        } else {
            state = 2;
            taskInfo.setTaskState(String.valueOf(state));
        }
        if (StringUtils.isNotBlank((CharSequence)taskInfo.getTaskErrorMsg()) && taskInfo.getTaskErrorMsg().length() > 300) {
            taskInfo.setTaskErrorMsg(StringUtils.substring((String)taskInfo.getTaskErrorMsg(), (int)0, (int)299));
        }
        paasTaskInfoService.updateByPk((Object)taskInfo);
        if (rtn != null) {
            PaasTaskHisDTO history = new PaasTaskHisDTO();
            BeanUtility.beanCopy((Object)taskInfo, (Object)history);
            history.setTaskHisId(UUIDUtil.getShortUUID());
            paasTaskHisService.insert((Object)history);
        }
    }
}

