/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.application.operation.generate;

import com.irdstudio.allinschedule.console.admin.facade.operation.PaasAppsInfoService;
import com.irdstudio.allinschedule.console.admin.facade.operation.dto.PaasAppsInfoDTO;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.JGitUtil;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.SdEnvUtil;
import com.irdstudio.allinschedule.console.dev.fegin.operation.PaasEnvParamService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.TerminalExecUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRepoPullTask
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(AppRepoPullTask.class);
    private static String gitUserName;
    private static String gitPassword;
    private static String branchName;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private String appId = null;
    private String gitUrl = null;
    private String appPath = null;

    public AppRepoPullTask(String appId, String gitUrl) {
        this.appId = appId;
        this.gitUrl = gitUrl;
    }

    public AppRepoPullTask(String appId) {
        this.appId = appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning.set(true);
        Object conn = null;
        try {
            if (gitUserName == null) {
                PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
                gitUserName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.username").getParamValue();
                gitPassword = paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.password").getParamValue();
                branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.prjtemplate.branch.name").getParamValue();
            }
            if (StringUtils.isBlank((CharSequence)this.gitUrl)) {
                PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(this.appId);
                appInfo = paasAppsInfoService.queryByPk(appInfo);
                this.gitUrl = appInfo.getAppGitUrl();
            }
            if (StringUtils.isBlank((CharSequence)this.gitUrl)) {
                return;
            }
            String gitLocalPathFileName = this.appId + "-remote";
            String gitLocalPath = SdEnvUtil.PROJECT_PATH;
            this.appPath = new File(gitLocalPath + gitLocalPathFileName).getAbsolutePath();
            boolean flag = false;
            if (gitLocalPath != null) {
                flag = this.repositoryCreate(this.appPath, this.gitUrl, gitUserName, gitPassword, branchName);
                if (flag) {
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.gitUrl);
                } else {
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.gitUrl);
                }
                return;
            }
            return;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
        }
        this.isRunning.set(false);
    }

    public void asyncRun() {
        this.start();
    }

    public void syncRun() {
        this.run();
    }

    private boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public String getAppPath() {
        return this.appPath;
    }
}

