/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.application.operation.generate;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinschedule.console.admin.facade.operation.PaasAppsInfoService;
import com.irdstudio.allinschedule.console.admin.facade.operation.dto.PaasAppsInfoDTO;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.AbstractMetaTask;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.CodeTemplateRepoPullTask;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.SdEnvUtil;
import com.irdstudio.allinschedule.console.dev.facade.operation.JobBaseInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.PaasTaskJobgenService;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.JobBaseInfoDTO;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.PaasTaskInfoDTO;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.PaasTaskJobgenDTO;
import com.irdstudio.allintpaas.sdk.sequence.types.YesOrNO;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.FilterItem;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(JobGenTask.class);
    private PaasTaskInfoDTO taskInfo;
    private PaasAppsInfoService paasAppsInfoService;

    public JobGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List jobList;
            PaasTaskJobgenService paasTaskJobgenService = (PaasTaskJobgenService)SpringContextUtils.getBean(PaasTaskJobgenService.class);
            this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            JobBaseInfoService jobBaseInfoService = (JobBaseInfoService)SpringContextUtils.getBean(JobBaseInfoService.class);
            PaasTaskJobgenDTO fngenDTO = new PaasTaskJobgenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskJobgenDTO)paasTaskJobgenService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String moduleId = this.taskInfo.getModuleId();
            String jobId = fngenDTO.getJobId();
            String comId = fngenDTO.getModuleId();
            JobBaseInfoDTO jobParam = new JobBaseInfoDTO();
            jobParam.setSubsId(subsId);
            jobParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)jobId)) {
                if (StringUtils.contains((CharSequence)jobId, (CharSequence)",")) {
                    FilterItem jobIdFilter = new FilterItem();
                    jobIdFilter.setOp(FilterItem.FilterOpEnum.In.getCode());
                    jobIdFilter.setKey("jobId");
                    jobIdFilter.setValues(Arrays.asList(StringUtils.split((String)jobId, (String)",")));
                    jobParam.setFilterCond(JSON.toJSONString(Arrays.asList(jobIdFilter)));
                } else {
                    jobParam.setJobId(jobId);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)comId)) {
                if (StringUtils.contains((CharSequence)comId, (CharSequence)",")) {
                    FilterItem comFiler = new FilterItem();
                    comFiler.setOp(FilterItem.FilterOpEnum.In.getCode());
                    comFiler.setKey("comId");
                    comFiler.setValues(Arrays.asList(StringUtils.split((String)comId, (String)",")));
                    jobParam.setFilterCond(JSON.toJSONString(Arrays.asList(comFiler)));
                } else {
                    jobParam.setComId(comId);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)moduleId)) {
                jobParam.setModuleId(moduleId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(jobList = jobBaseInfoService.queryList((Object)jobParam)))) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = this.paasAppsInfoService.queryByPk(appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                String rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId;
                File rootDir = new File(rootPath);
                FileUtils.deleteQuietly((File)rootDir);
                if (!rootDir.exists()) {
                    rootDir.mkdirs();
                }
                for (JobBaseInfoDTO job : jobList) {
                    job.setLoginUserId(this.taskInfo.getLoginUserId());
                    jobBaseInfoService.generateCode(job);
                    String id = job.getJobCode();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    if (!idDir.exists()) continue;
                    FileUtils.copyDirectory((File)idDir, (File)rootDir);
                }
            }
            if (StringUtils.equals((CharSequence)fngenDTO.getRegenRepo(), (CharSequence)YesOrNO.YES.getCode())) {
                fngenDTO.setRegenRepo(YesOrNO.NO.getCode());
                paasTaskJobgenService.updateByPk((Object)fngenDTO);
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u4efb\u52a1\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u4efb\u52a1\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }
}

