/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.web.operation;

import com.irdstudio.allinschedule.console.dev.application.operation.generate.AppRepoPullTask;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.SdEnvUtil;
import com.irdstudio.allinschedule.console.dev.facade.operation.JobBaseInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.JobBaseInfoDTO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.FileUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class JobBaseInfoController
extends BaseController<JobBaseInfoDTO, JobBaseInfoService> {
    @RequestMapping(value={"/api/job/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<JobBaseInfoDTO>> queryHldJobInfoAll(JobBaseInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getAppId(), (CharSequence)",")) {
            dto.setAppIdList(Arrays.asList(StringUtils.split((String)dto.getAppId(), (String)",")));
            dto.setAppId(null);
        }
        if (StringUtils.contains((CharSequence)dto.getComId(), (CharSequence)",")) {
            dto.setComIdList(Arrays.asList(StringUtils.split((String)dto.getComId(), (String)",")));
            dto.setComId(null);
        }
        List outputVo = ((JobBaseInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/job/base/info/{jobId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<JobBaseInfoDTO> queryByPk(@PathVariable(value="jobId") String jobId) {
        JobBaseInfoDTO inVo = new JobBaseInfoDTO();
        inVo.setJobId(jobId);
        JobBaseInfoDTO outputVo = (JobBaseInfoDTO)((JobBaseInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/job/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody JobBaseInfoDTO inJobBaseInfoDTO) {
        int outputVo = ((JobBaseInfoService)this.getService()).deleteByPk((Object)inJobBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/job/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody JobBaseInfoDTO inJobBaseInfoDTO) {
        this.setUserInfoToVO(inJobBaseInfoDTO);
        inJobBaseInfoDTO.setUpdateUser(inJobBaseInfoDTO.getLoginUserId());
        inJobBaseInfoDTO.setUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((JobBaseInfoService)this.getService()).updateByPk((Object)inJobBaseInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/job/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertHldJobInfo(@RequestBody JobBaseInfoDTO inJobBaseInfoDTO) {
        this.setUserInfoToVO(inJobBaseInfoDTO);
        if (StringUtils.isBlank((CharSequence)inJobBaseInfoDTO.getJobId())) {
            inJobBaseInfoDTO.setJobId(UUIDUtil.getUUID());
        }
        inJobBaseInfoDTO.setCreateUser(inJobBaseInfoDTO.getLoginUserId());
        inJobBaseInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inJobBaseInfoDTO.setUpdateUser(inJobBaseInfoDTO.getLoginUserId());
        inJobBaseInfoDTO.setUpdateTime(inJobBaseInfoDTO.getCreateTime());
        SeqInstInfoService seqInstInfoService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
        inJobBaseInfoDTO.setJobCode(seqInstInfoService.nextSequence("JOB-SEQ", inJobBaseInfoDTO.getSubsId()));
        int outputVo = ((JobBaseInfoService)this.getService()).insert((Object)inJobBaseInfoDTO);
        return this.getResponseData(inJobBaseInfoDTO.getJobId());
    }

    @RequestMapping(value={"/client/JobBaseInfoService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody JobBaseInfoDTO param) {
        return ((JobBaseInfoService)this.getService()).deleteByCond(param);
    }

    @RequestMapping(value={"/client/JobBaseInfoService/generateCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean generateCode(@RequestBody JobBaseInfoDTO param) {
        return ((JobBaseInfoService)this.getService()).generateCode(param);
    }

    @RequestMapping(value={"/api/job/base/info/change/belong/deletes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryBeLongDeleteFiles(JobBaseInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getJobCode();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            ArrayList result = new ArrayList();
            files.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filePath", f.getAbsolutePath().replaceFirst(dir.getAbsolutePath(), "").replaceAll(File.separator, "/"));
                map.put("fileName", f.getName());
                result.add(map);
            });
            if (CollectionUtils.isNotEmpty(result)) {
                Map map = (Map)result.get(0);
                map.put("total", result.size());
            }
            return this.getResponseData(result);
        }
        return this.getResponseData(Collections.emptyList());
    }

    @RequestMapping(value={"/api/job/base/info/change/belong/deletes/confirm"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<String> beLongDeleteFilesConfirm(@RequestBody JobBaseInfoDTO dto) {
        String appId = dto.getAppId();
        String id = dto.getJobCode();
        File dir = new File(SdEnvUtil.PROJECT_PATH, id);
        if (dir.exists()) {
            List files = FileUtil.getDirAllFile((File)dir);
            FileUtils.deleteQuietly((File)dir);
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(dto.getAppId());
            appRepoPullTask.syncRun();
            String appPath = appRepoPullTask.getAppPath();
            try {
                Files.move(new File(appPath).toPath(), dir.toPath(), new CopyOption[0]);
                for (File deleteFile : files) {
                    if (!deleteFile.exists()) continue;
                    FileUtils.deleteQuietly((File)deleteFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getResponseData("\u64cd\u4f5c\u6210\u529f");
    }
}

