/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.console.dev.web.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinschedule.console.admin.facade.operation.PaasAppsInfoService;
import com.irdstudio.allinschedule.console.admin.facade.operation.dto.PaasAppsInfoDTO;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.AbstractMetaTask;
import com.irdstudio.allinschedule.console.dev.application.operation.generate.JGitUtil;
import com.irdstudio.allinschedule.console.dev.facade.operation.PaasTaskInfoService;
import com.irdstudio.allinschedule.console.dev.facade.operation.dto.PaasTaskInfoDTO;
import com.irdstudio.allinschedule.console.dev.fegin.operation.AllinCloudPortalClient;
import com.irdstudio.allinschedule.console.dev.fegin.operation.PaasEnvParamService;
import com.irdstudio.allinschedule.console.dev.fegin.operation.dto.SUserProfileDTO;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.DirectoryTreeUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskInfoController
extends BaseController<PaasTaskInfoDTO, PaasTaskInfoService> {
    private ConcurrentMap<String, Boolean> taskDebounce = AbstractMetaTask.taskDebounce;
    @Value(value="${tdp.project.path:}")
    private String codePath;

    @RequestMapping(value={"/api/paas/task/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTaskInfoDTO>> queryPaasTaskInfoAll(PaasTaskInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getTaskCategory(), (CharSequence)",")) {
            String[] catagorys = StringUtils.split((String)dto.getTaskCategory(), (String)",");
            dto.setTaskCategoryList(Arrays.asList(catagorys));
            dto.setTaskCategory(null);
        }
        List outputVo = ((PaasTaskInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTaskInfoDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        PaasTaskInfoDTO inVo = new PaasTaskInfoDTO();
        inVo.setTaskId(taskId);
        PaasTaskInfoDTO outputVo = (PaasTaskInfoDTO)((PaasTaskInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        int outputVo = ((PaasTaskInfoService)this.getService()).deleteByPk((Object)inPaasTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        this.setUserInfoToVO(inPaasTaskInfoDTO);
        inPaasTaskInfoDTO.setLastUpdateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTaskInfoService)this.getService()).updateByPk((Object)inPaasTaskInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasTaskInfo(@RequestBody PaasTaskInfoDTO inPaasTaskInfoDTO) {
        int outputVo;
        this.setUserInfoToVO(inPaasTaskInfoDTO);
        inPaasTaskInfoDTO.setCreateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTaskInfoDTO.setLastUpdateUser(inPaasTaskInfoDTO.getLoginUserId());
        inPaasTaskInfoDTO.setLastUpdateTime(inPaasTaskInfoDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inPaasTaskInfoDTO.getTaskId())) {
            inPaasTaskInfoDTO.setTaskId(UUIDUtil.getShortUUID());
        } else {
            outputVo = ((PaasTaskInfoService)this.getService()).updateByPk((Object)inPaasTaskInfoDTO);
            if (outputVo == 1) {
                return this.getResponseData(inPaasTaskInfoDTO.getTaskId());
            }
        }
        outputVo = ((PaasTaskInfoService)this.getService()).insert((Object)inPaasTaskInfoDTO);
        return this.getResponseData(inPaasTaskInfoDTO.getTaskId());
    }

    @RequestMapping(value={"/client/PaasTaskInfoService/executeTask"}, method={RequestMethod.POST})
    @ResponseBody
    Integer executeTask(@RequestParam(value="taskId") String taskId, @RequestParam(value="userId") String userId) {
        return ((PaasTaskInfoService)this.getService()).executeTask(taskId, userId);
    }

    @RequestMapping(value={"/api/paas/task/info/exec"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> executePaasTask(@RequestParam(value="taskId") String taskId) {
        String userId = this.getUserInfo().getUserId();
        try {
            int outputVo = ((PaasTaskInfoService)this.getService()).executeTask(taskId, userId);
            return this.getResponseData(outputVo);
        }
        catch (Exception e) {
            this.taskDebounce.put(taskId, false);
            logger.error(e.getMessage(), (Throwable)e);
            ResponseData resp = this.getResponseData(null);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @RequestMapping(value={"/api/paas/task/info/exec/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> getExecutePaasTaskStat(@RequestParam(value="taskId") String taskId) {
        int outputVo = 0;
        if (this.taskDebounce.get(taskId) != null && ((Boolean)this.taskDebounce.get(taskId)).booleanValue()) {
            outputVo = 1;
        }
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/code/view/{produceId}"})
    @ResponseBody
    public ResponseData<String> codeProduce(@PathVariable(value="produceId") String produceId) {
        if (StringUtils.isEmpty((CharSequence)produceId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u4ee3\u7801\u751f\u6210\u6807\u8bc6!");
            return data;
        }
        logger.info("\u4ee3\u7801\u76ee\u5f55\uff1a" + this.codePath + produceId);
        return this.getResponseData(DirectoryTreeUtil.getTreeJson((String)(this.codePath + produceId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/code/file/open"})
    @ResponseBody
    public ResponseData<String> codeFileOpen(@RequestParam(name="file") String file) {
        if (StringUtils.isEmpty((CharSequence)file)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u7684\u6587\u4ef6!");
            return data;
        }
        StringBuffer content = new StringBuffer("");
        if (!StringUtils.isEmpty((CharSequence)file)) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.codePath + File.separator + file), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("content", content.toString());
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @GetMapping(value={"/api/code/produce/push/current"})
    @ResponseBody
    public ResponseData<Boolean> currentPathPushToRepo(@RequestParam(value="codePath", required=false) String userThisCodePathId, @RequestParam(value="commitMsg", required=false) String commitMsg, @RequestParam(value="appId") String appId) {
        boolean flag = true;
        String currentUserId = this.getUserInfo().getUserId();
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            return this.getResponseData(null, "", "\u8bf7\u5728\u4e2a\u4eba\u4e2d\u5fc3\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        String gitPassword = userProfile.getGitAccessToken();
        if (StringUtils.isBlank((CharSequence)gitPassword)) {
            gitPassword = userProfile.getGitPassword();
        }
        String gitUser = currentUserId;
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitUsername())) {
            gitUser = userProfile.getGitUsername();
        }
        String userEmail = String.format("%s@%s.com", currentUserId, "irdstudio");
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = paasAppsInfoService.queryByPk(appInfo);
        if (appInfo == null) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String id = userThisCodePathId;
        String sourcePath = this.codePath + id;
        JGitUtil jGitUtil = new JGitUtil(sourcePath, appInfo.getAppGitUrl(), gitUser, gitPassword);
        try {
            jGitUtil.addAll();
            if (StringUtils.isBlank((CharSequence)commitMsg)) {
                commitMsg = "auto code generate commit on id#" + id;
            }
            jGitUtil.commit(gitUser, userEmail, commitMsg);
            jGitUtil.push(appInfo.getAppGitUrl(), Boolean.valueOf(false));
            jGitUtil.close();
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{userThisCodePathId, appInfo.getAppGitUrl(), e});
            throw new RuntimeException("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38");
        }
        return this.getResponseData(true);
    }

    @GetMapping(value={"/api/code/produce/push"})
    @ResponseBody
    public ResponseData<Boolean> codeProducePushToRepo(@RequestParam(value="produceId", required=false) String produceId, @RequestParam(value="codePath", required=false) String userThisCodePathId, @RequestParam(value="commitMsg", required=false) String commitMsg, @RequestParam(value="userAppId", required=false) Boolean userAppId, @RequestParam(value="appId") String appId) {
        boolean flag = true;
        String currentUserId = this.getUserInfo().getUserId();
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            return this.getResponseData(null, "", "\u8bf7\u5728\u4e2a\u4eba\u4e2d\u5fc3\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        String gitPassword = userProfile.getGitAccessToken();
        if (StringUtils.isBlank((CharSequence)gitPassword)) {
            gitPassword = userProfile.getGitPassword();
        }
        String gitUser = currentUserId;
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitUsername())) {
            gitUser = userProfile.getGitUsername();
        }
        String userEmail = String.format("%s@%s.com", currentUserId, "irdstudio");
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = paasAppsInfoService.queryByPk(appInfo);
        if (appInfo == null) {
            return this.getResponseData(null, "", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String id = StringUtils.isNotBlank((CharSequence)userThisCodePathId) ? userThisCodePathId : (userAppId != false ? appId : produceId);
        String sourcePath = this.codePath + id;
        String targetPath = this.codePath + id + "-remote";
        String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue();
        JGitUtil jGitUtil = new JGitUtil(targetPath, appInfo.getAppGitUrl(), gitUser, gitPassword);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(targetPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(targetPath, appInfo.getAppGitUrl(), gitUser, gitPassword);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return this.getResponseData(null, "", "\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25\uff01");
                }
            }
        }
        File localProjectDir = new File(sourcePath);
        if (localProjectDir.exists() && localProjectDir.isDirectory()) {
            File[] localSubDir;
            for (File sub : localSubDir = localProjectDir.listFiles()) {
                File target = new File(targetPath, sub.getName());
                if (sub.isDirectory()) {
                    if (sub.getName().equals(".git")) continue;
                    try {
                        FileUtils.copyDirectory((File)sub, (File)target);
                    }
                    catch (IOException e) {
                        logger.error("\u590d\u5236\u4ee3\u7801\u751f\u6210\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, sub.getName(), e});
                    }
                    continue;
                }
                try {
                    FileUtils.copyFile((File)sub, (File)target);
                }
                catch (IOException e) {
                    logger.error("\u590d\u5236\u4ee3\u7801\u751f\u6210\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, sub.getName(), e});
                }
            }
        }
        try {
            jGitUtil.addAll();
            if (StringUtils.isBlank((CharSequence)commitMsg)) {
                commitMsg = "auto code generate commit on id#" + id;
            }
            jGitUtil.commit(gitUser, userEmail, commitMsg);
            jGitUtil.push(appInfo.getAppGitUrl(), Boolean.valueOf(false));
            jGitUtil.close();
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38 {} {}", new Object[]{produceId, appInfo.getAppGitUrl(), e});
            throw new RuntimeException("\u63a8\u9001\u4ee3\u7801\u5230\u4ed3\u5e93\u5f02\u5e38");
        }
        return this.getResponseData(true);
    }
}

