/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.resource;

import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.datasource.DataSourceParm;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.datasource.PoolDataSource;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.encode.CustomConnection;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.encode.Util;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.resource.RsCallableStatement;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.resource.RsInterface;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.resource.RsPreparedStatement;
import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.imdbcp.resource.RsStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class RsConnection
extends CustomConnection {
    public static final String PN = "[Resuource]";
    private ArrayList useResources = new ArrayList();
    private String lastSql = null;
    private long lastSqlTime = 0L;
    private DataSourceParm parm = null;
    private boolean health = true;
    PoolDataSource ds = null;
    private long maxUseTime = 0L;

    public RsConnection(Connection con, DataSourceParm parm) {
        super(con, parm.getCharSet(), parm.getEncodeType());
        this.parm = parm;
        this.lastSqlTime = System.currentTimeMillis();
        this.maxUseTime = this.lastSqlTime + 72000000L;
    }

    @Override
    public Statement createStatement(int p0, int p1, int p2) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        try (Statement _stmt = this.con.createStatement(p0, p1, p2);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsStatement _rsst = new RsStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsst);
            RsStatement rsStatement = _rsst;
            return rsStatement;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        try (Statement _stmt = this.con.createStatement();){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsStatement _rsst = new RsStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsst);
            RsStatement rsStatement = _rsst;
            return rsStatement;
        }
    }

    @Override
    public Statement createStatement(int p0, int p1) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        try (Statement _stmt = this.con.createStatement(p0, p1);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsStatement _rsst = new RsStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsst);
            RsStatement rsStatement = _rsst;
            return rsStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0, int p1) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX, p1);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0, String[] p1) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX, p1);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0, int p1, int p2, int p3) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX, p1, p2, p3);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0, int[] p1) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX, p1);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String p0, int p1, int p2) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (PreparedStatement _stmt = this.con.prepareStatement(enCodeX, p1, p2);){
            if (this.parm.getFetchSize() > 0) {
                _stmt.setFetchSize(this.parm.getFetchSize());
            }
            RsPreparedStatement _rsps = new RsPreparedStatement(_stmt, this.charSet, this.encodeType);
            this.addResource(_rsps);
            _rsps.setLastSql(p0);
            RsPreparedStatement rsPreparedStatement = _rsps;
            return rsPreparedStatement;
        }
    }

    @Override
    public CallableStatement prepareCall(String p0, int p1, int p2) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (CallableStatement _cs = this.con.prepareCall(enCodeX, p1, p2);){
            if (this.parm.getFetchSize() > 0) {
                _cs.setFetchSize(this.parm.getFetchSize());
            }
            RsCallableStatement _rscs = new RsCallableStatement(_cs, this.charSet, this.encodeType);
            this.addResource(_rscs);
            _rscs.setLastSql(p0);
            RsCallableStatement rsCallableStatement = _rscs;
            return rsCallableStatement;
        }
    }

    @Override
    public CallableStatement prepareCall(String p0) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (CallableStatement _cs = this.con.prepareCall(enCodeX);){
            if (this.parm.getFetchSize() > 0) {
                _cs.setFetchSize(this.parm.getFetchSize());
            }
            RsCallableStatement _rscs = new RsCallableStatement(_cs, this.charSet, this.encodeType);
            this.addResource(_rscs);
            _rscs.setLastSql(p0);
            RsCallableStatement rsCallableStatement = _rscs;
            return rsCallableStatement;
        }
    }

    @Override
    public CallableStatement prepareCall(String p0, int p1, int p2, int p3) throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
            throw new SQLException("[Resuource]\u8fde\u63a5\u6c60\u5f02\u5e38\uff01\u8fde\u63a5\u5df2\u7ecf\u4e3a\u7a7a\uff01");
        }
        String enCodeX = Util.encodeString(p0, this.charSet, this.encodeType);
        try (CallableStatement _cs = this.con.prepareCall(enCodeX, p1, p2, p3);){
            if (this.parm.getFetchSize() > 0) {
                _cs.setFetchSize(this.parm.getFetchSize());
            }
            RsCallableStatement _rscs = new RsCallableStatement(_cs, this.charSet, this.encodeType);
            this.addResource(_rscs);
            _rscs.setLastSql(p0);
            RsCallableStatement rsCallableStatement = _rscs;
            return rsCallableStatement;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.con == null) {
            this.setHealth(false);
        }
        this.closeAllResource();
        this.checkCommit();
        if (this.isHealth() && this.getMaxUseTime() > System.currentTimeMillis()) {
            this.setLastSql(null);
            this.ds.freeConnection(this);
        } else {
            this.realClose();
        }
    }

    public boolean checkCommit() {
        if (this.con == null) {
            this.setHealth(false);
            return false;
        }
        try {
            if (!this.getAutoCommit()) {
                System.err.println("[Resuource]\u8fde\u63a5\u6ca1\u6709\u5173\u95ed\u4e8b\u52a1\uff0csql=" + this.lastSql);
                if (this.isHealth()) {
                    this.setAutoCommit(true);
                } else {
                    try {
                        this.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setAutoCommit(true);
                }
                this.setHealth(false);
                return false;
            }
            return true;
        }
        catch (Exception se) {
            this.setHealth(false);
            return false;
        }
    }

    public boolean isOverTime() {
        if (!this.isHealth()) {
            return true;
        }
        if (this.lastSqlTime + (long)(this.parm.getHealthTime() * 1000) < System.currentTimeMillis()) {
            this.setHealth(false);
            System.err.println("[Resuource]\u8fde\u63a5\u8d85\u65f6\u6ca1\u6709\u91ca\u653e\uff0csql=" + this.lastSql);
            return true;
        }
        return false;
    }

    public void closeAllResource() {
        if (this.useResources == null) {
            this.setHealth(false);
            return;
        }
        if (this.useResources.size() > 0) {
            this.setHealth(false);
            ArrayList list = (ArrayList)this.useResources.clone();
            for (RsInterface rsi : list) {
                if (rsi == null) continue;
                System.err.println("[Resuource]\u6ca1\u6709\u91ca\u653e\u6570\u636e\u5e93\u8d44\u6e90" + rsi.getClass().getName() + ",sql=" + rsi.getLastSql());
                try {
                    rsi.close();
                }
                catch (Exception e) {
                    System.err.println("[Resuource]\u5f3a\u5236\u662f\u5426\u8d44\u6e90\u51fa\u9519\uff01sql=" + rsi.getLastSql());
                    e.printStackTrace(System.err);
                }
            }
            list.clear();
        }
    }

    public void addResource(RsInterface rs) {
        rs.setBaseConnnection(this);
        this.useResources.add(rs);
    }

    public void removeResource(RsInterface rs) {
        this.useResources.remove(rs);
        rs.setBaseConnnection(null);
    }

    public void realClose() {
        if (this.con == null) {
            return;
        }
        this.ds.clearConnection(this);
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.con = null;
        this.ds = null;
        this.parm = null;
        if (this.useResources != null && this.useResources.size() > 0) {
            System.err.println("[Resuource]\u5f3a\u5236\u5173\u95ed\u8fde\u63a5\u65f6\uff0c\u4ecd\u6709\u672a\u5173\u95ed\u8d44\u6e90\uff01");
            this.useResources.clear();
        }
        this.useResources = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnected() {
        if (this.con == null) {
            this.setHealth(false);
            return false;
        }
        Statement st = null;
        try {
            st = this.createStatement();
            st.execute(this.parm.getCheckSQL());
        }
        catch (Exception e) {
            this.setHealth(false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public void setLastSql(String sql) {
        this.lastSql = sql;
        this.lastSqlTime = System.currentTimeMillis();
    }

    public boolean isHealth() {
        return this.health;
    }

    public void setHealth(boolean health) {
        this.health = health;
    }

    public PoolDataSource getDataSource() {
        return this.ds;
    }

    public void setDataSource(PoolDataSource ds) {
        this.ds = ds;
    }

    public String getLastSql() {
        return this.lastSql;
    }

    public long getMaxUseTime() {
        return this.maxUseTime;
    }
}

