/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.assembly.license.dm;

import com.irdstudio.allinschedule.executor.engine.executor.core.assembly.license.dm.SInstLicense;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SInstLicenseDao {
    private static final Logger logger = LoggerFactory.getLogger(SInstLicenseDao.class);
    Connection conn = null;

    public SInstLicenseDao(Connection conn) {
        this.conn = conn;
    }

    public SInstLicense queryWithKeys(String sysInstId) throws SQLException {
        SInstLicense dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_inst_license WHERE sys_inst_id=?");
            ps.setString(1, sysInstId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new SInstLicense();
                dc.setSysInstId(rs.getString("sys_inst_id"));
                dc.setHostName(rs.getString("host_name"));
                dc.setWebPort(rs.getString("web_port"));
                dc.setSysCode(rs.getString("sys_code"));
                dc.setSysName(rs.getString("sys_name"));
                dc.setAuthTarget(rs.getString("auth_target"));
                dc.setAuthBeginDate(rs.getString("auth_begin_date"));
                dc.setAuthEndDate(rs.getString("auth_end_date"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySInstLicenseWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerInst(SInstLicense instLicense) {
        boolean bFlag = false;
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("DELETE FROM s_inst_license WHERE sys_inst_id=?");
            ps.setString(1, instLicense.getSysInstId());
            ps.execute();
            ps.close();
            ps = this.conn.prepareStatement("INSERT INTO s_inst_license(SYS_INST_ID,HOST_NAME,WEB_PORT,SYS_CODE,SYS_NAME,AUTH_TARGET,AUTH_BEGIN_DATE,AUTH_END_DATE,REMARK) VALUES(?,?,?,?,?,?,?,?,?)");
            ps.setString(1, instLicense.getSysInstId());
            ps.setString(2, instLicense.getHostName());
            ps.setString(3, instLicense.getWebPort());
            ps.setString(4, instLicense.getSysCode());
            ps.setString(5, instLicense.getSysName());
            ps.setString(6, instLicense.getAuthTarget());
            ps.setString(7, instLicense.getAuthBeginDate());
            ps.setString(8, instLicense.getAuthEndDate());
            ps.setString(9, instLicense.getRemark());
            ps.execute();
            bFlag = true;
        }
        catch (SQLException e) {
            logger.error("\u6ce8\u518c\u7cfb\u7edf\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error("\u5173\u95edprepareStatement\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return bFlag;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

