/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.batch;

import com.irdstudio.allinschedule.executor.engine.executor.core.dao.BatchConfMasterDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.BatchConfTaskDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.BatchInstMasterDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchConfMaster;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchConfTask;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchInstMaster;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.executor.SafeReleaseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class BatchDataUtil {
    public static synchronized BatchConfTask getBatchConfTask(Connection conn, String taskId) throws SQLException {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new SQLException("\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        BatchConfTaskDao batTaskUnitConfigDao = new BatchConfTaskDao(conn);
        BatchConfTask batTaskUnitConfig = null;
        batTaskUnitConfig = batTaskUnitConfigDao.queryWithKeys(taskId);
        return batTaskUnitConfig;
    }

    public static synchronized BatchConfMaster getBatchConfMaster(Connection conn, String batchId) throws SQLException {
        BatchConfMasterDao batBatchInfoConfigDao = new BatchConfMasterDao(conn);
        return batBatchInfoConfigDao.queryWithKeys(batchId);
    }

    public static synchronized BatchInstMaster getBatchInstMaster(Connection conn, String batchId) throws SQLException {
        BatchInstMasterDao batInstBatchDao = new BatchInstMasterDao(conn);
        return batInstBatchDao.queryWithKeys(batchId);
    }

    public static synchronized BatchInstMaster getBatchInstMasterByBatchSerialNo(Connection conn, String batchSerialNo) throws SQLException {
        BatchInstMasterDao batInstBatchDao = new BatchInstMasterDao(conn);
        return batInstBatchDao.queryWithBatchSerialNo(batchSerialNo);
    }

    public static synchronized SSubsInfo getSSubsInfo(Connection conn, String subsId) throws SQLException {
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        return sSubsInfoDao.querySSubsInfoWithKeys(subsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskSkiped(String taskId) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        boolean isSkiped;
        block5: {
            isSkiped = false;
            ps = null;
            rs = null;
            String state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM batch_inst_task WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    state = rs.getString("task_intervene_state");
                }
                if (state == null || !state.equals("1") && !state.equals("3")) break block5;
                isSkiped = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return isSkiped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTaskState(String taskId) {
        Connection conn;
        String state;
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            ps = null;
            rs = null;
            state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM batch_inst_task WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                state = rs.getString("task_intervene_state");
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return state;
    }
}

