/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.BatchConfStageDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchConfStage;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchInstMaster;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.DateCalculate;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.db.ProxySQL;
import com.irdstudio.framework.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchInstMasterDao {
    Connection conn = null;

    public BatchInstMasterDao(Connection conn) {
        this.conn = conn;
    }

    public BatchInstMaster queryWithKeys(String batchId) throws SQLException {
        BatchInstMaster dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_master WHERE batch_id=?");
            ps.setString(1, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatchInstMaster)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatchInstMaster.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstMasterWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public BatchInstMaster queryByBatchSerialNo(String batchSerialNo) throws SQLException {
        BatchInstMaster dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_master WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatchInstMaster)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatchInstMaster.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstMasterWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatchInstMaster> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatchInstMaster> dcList = new ArrayList<BatchInstMaster>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_master " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatchInstMaster dc = (BatchInstMaster)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatchInstMaster.class));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstMasterWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateStage(BatchInstMaster batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            BatchConfStageDao stageDao = new BatchConfStageDao(this.conn);
            BatchConfStage stageInfo = stageDao.queryWithKeys(batchInst.getStageId(), batchInst.getBatchId());
            ps = this.conn.prepareStatement("update batch_inst_master set batch_state=?,stage_id=?,stage_name=? where batch_serial_no=?");
            ps.setString(1, String.valueOf(3));
            ps.setString(2, batchInst.getStageId());
            ps.setString(3, stageInfo.getStageName());
            ps.setString(4, batchInst.getBatchSerialNo());
            ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
    }

    public void updateBatchToEnd(BatchInstMaster batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update batch_inst_master set batch_state=?,end_time=?,cost_time=?,remark=? where batch_serial_no=?");
            String endTime = CurrentDateUtil.getTodayDateEx2();
            ps.setString(1, batchInst.getBatchState());
            ps.setString(2, endTime);
            ps.setBigDecimal(3, DateCalculate.computeIntervalMills(batchInst.getStartTime(), endTime));
            ps.setString(4, batchInst.getRemark());
            ps.setString(5, batchInst.getBatchSerialNo());
            ps.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO batch_inst_master_h SELECT * FROM batch_inst_master WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM batch_inst_master WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public BatchInstMaster queryWithBatchSerialNo(String batchSerialNo) throws SQLException {
        BatchInstMaster dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_master WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = (BatchInstMaster)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatchInstMaster.class));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstMasterWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public Map<String, Object> getExtParam(BatchInstMaster batInstBatch) {
        Map<String, Object> extParamMap = null;
        try {
            String extParam = batInstBatch.getExtParam();
            extParamMap = (Map)JSON.parseObject((String)extParam, Map.class);
            if (extParamMap == null) {
                extParamMap = new HashMap();
            }
        }
        catch (Exception e) {
            extParamMap = new HashMap<String, Object>();
        }
        return extParamMap;
    }

    public boolean updateByPk(final BatchInstMaster paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("batch_inst_master");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("batch_serial_no")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("batch_serial_no = ? ");
                param.add(paramVO.getBatchSerialNo());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return rs == 1;
    }

    public List<BatchInstMaster> queryList(final BatchInstMaster paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("batch_inst_master");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.ORDER_BY("end_time desc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<BatchInstMaster> list = new ArrayList<BatchInstMaster>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                BatchInstMaster bean = (BatchInstMaster)((Object)POJOUtils.generatePOJO((ResultSet)rs, BatchInstMaster.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryList is wrong", e);
        }
        return list;
    }
}

