/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.dao;

import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchInstTaskH;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatchInstTaskHDao {
    Connection conn = null;

    public BatchInstTaskHDao(Connection conn) {
        this.conn = conn;
    }

    public BatchInstTaskH queryWithKeys(String taskId, String batchSerialNo) throws SQLException {
        BatchInstTaskH dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_task_h WHERE task_id=? and batch_serial_no=?");
            ps.setString(1, taskId);
            ps.setString(2, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatchInstTaskH();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstTaskHWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatchInstTaskH> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatchInstTaskH> dcList = new ArrayList<BatchInstTaskH>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM batch_inst_task_h " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatchInstTaskH dc = new BatchInstTaskH();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatchInstTaskHWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

