/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.dao;

import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.SAgentInfo;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinschedule.executor.engine.types.ExecutorStateEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SAgentInfoDao {
    Connection conn = null;

    public SAgentInfoDao(Connection conn) {
        this.conn = conn;
    }

    public SAgentInfo queryAgentInfoById(String agentId) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        SAgentInfo agentInfo = null;
        try {
            ps = this.conn.prepareStatement("select * from s_agent_info where agent_id = ?");
            ps.setString(1, agentId);
            rs = ps.executeQuery();
            if (rs.next()) {
                agentInfo = new SAgentInfo();
                agentInfo.setAgentId(rs.getString("agent_id"));
                agentInfo.setAgentName(rs.getString("agent_name"));
                agentInfo.setAgentState(rs.getString("agent_state"));
                agentInfo.setAgentUrl(rs.getString("agent_url"));
                agentInfo.setStartTime(rs.getString("start_time"));
                agentInfo.setStopTime(rs.getString("stop_time"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryAgentInfoById is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return agentInfo;
    }

    public void updateStateToRunning(String agentId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update s_agent_info set agent_state=?,start_time=? where agent_id = ?");
            String startTime = CurrentDateUtil.getTodayDateEx2();
            ps.setString(1, ExecutorStateEnum.RUNING.getCode());
            ps.setString(2, startTime);
            ps.setString(3, agentId);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int insertSAgentInfo(SAgentInfo sAgentInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into s_agent_info ( agent_id,agent_name,agent_state,agent_url,start_time,stop_time) values (?,?,?,?,?,?)");
            ps.setObject(1, sAgentInfo.getAgentId());
            ps.setObject(2, sAgentInfo.getAgentName());
            ps.setObject(3, sAgentInfo.getAgentState());
            ps.setObject(4, sAgentInfo.getAgentUrl());
            ps.setObject(5, sAgentInfo.getStartTime());
            ps.setObject(6, sAgentInfo.getStopTime());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert sAgentInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(SAgentInfo sAgentInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from s_agent_info where 1=1 AND agent_id = ? ");
            ps.setObject(1, sAgentInfo.getAgentId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete SAgentInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(SAgentInfo sAgentInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update s_agent_info set  agent_name = ? , agent_state = ? , agent_url = ? , start_time = ?, stop_time = ?  where 1=1 AND agent_id = ? ");
            ps.setObject(1, sAgentInfo.getAgentName());
            ps.setObject(2, sAgentInfo.getAgentState());
            ps.setObject(3, sAgentInfo.getAgentUrl());
            ps.setObject(4, sAgentInfo.getStartTime());
            ps.setObject(5, sAgentInfo.getStopTime());
            ps.setObject(6, sAgentInfo.getAgentId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update SAgentInfo is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public SAgentInfo queryByPk(SAgentInfo sAgentInfo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        SAgentInfo result = null;
        try {
            ps = this.conn.prepareStatement("select agent_id,agent_name,agent_state,agent_url,start_time,stop_time from s_agent_info where 1=1  AND agent_id = ? ");
            ps.setObject(1, sAgentInfo.getAgentId());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new SAgentInfo();
                result.setAgentId(rs.getString("agent_id"));
                result.setAgentName(rs.getString("agent_name"));
                result.setAgentState(rs.getString("agent_state"));
                result.setAgentUrl(rs.getString("agent_url"));
                result.setStartTime(rs.getString("start_time"));
                result.setStopTime(rs.getString("stop_time"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update SAgentInfo is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

