/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.plugin;

import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchConfTask;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.dataload.PluginInstLoadtxt;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.pub.Convert;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.pub.JvmUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLogService {
    private static final Logger logger = LoggerFactory.getLogger(PluginLogService.class);
    private static PluginLogService instance = null;

    private PluginLogService() {
    }

    public static synchronized PluginLogService getInstance() {
        if (instance == null) {
            try {
                instance = new PluginLogService();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePluginInstLog(String szBatchSn, int nPluginId, String szPluginName, String szActionName, String szActionResult, String szActionDetailDesc, String szTaskId, String szTaskName) {
        if (szActionDetailDesc == null) {
            szActionDetailDesc = "";
        } else if (szActionDetailDesc.length() > 4000) {
            szActionDetailDesc = szActionDetailDesc.substring(0, 2000);
        }
        if (szActionName == null) {
            szActionName = "";
        } else if (szActionName.length() > 254) {
            szActionName = szActionName.substring(0, 126);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            ps = conn.prepareStatement("insert into plugin_inst_log (batch_sn,plugin_id,plugin_name,action_name,action_result,action_detail_info,record_time,task_id,task_name) values(?,?,?,?,?,?,?,?,?)");
            ps.setString(1, szBatchSn);
            ps.setInt(2, nPluginId);
            ps.setString(3, szPluginName);
            ps.setString(4, szActionName);
            ps.setString(5, szActionResult);
            ps.setString(6, szActionDetailDesc);
            ps.setString(7, CurrentDateUtil.getTodayDateEx4());
            ps.setString(8, szTaskId);
            ps.setString(9, szTaskName);
            ps.execute();
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage());
                }
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    public boolean updateBatchTaskToRunning(String szTaskId, String batchSerialNo) throws SQLException {
        boolean bFlag = false;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            ps = conn.prepareStatement("UPDATE batch_inst_task set task_run_state=?,start_time=? where task_id=? AND batch_serial_no=?");
            ps.setString(1, "2");
            ps.setString(2, CurrentDateUtil.getTodayDateEx2());
            ps.setString(3, szTaskId);
            ps.setString(4, batchSerialNo);
            ps.execute();
            bFlag = true;
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage());
                }
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return bFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBatchTaskToEnd(BatchConfTask taskConf, long startMills, String state, String batchSerialNo) {
        boolean bFlag = false;
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer info = new StringBuffer();
        info.append("\u6700\u5927\u8fde\u63a5\u6570\uff1a").append(TConnPool.getDefaultPool().getConnectionCount()).append(",");
        info.append(JvmUtil.getJvmMemoryWithM());
        long endMills = System.currentTimeMillis();
        int skipTactic = Convert.StrToInt(taskConf.getTaskSkipTactic(), 2);
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            ps = conn.prepareStatement("update batch_inst_task set task_run_state=?,end_time=?,cost_time=?,task_intervene_state=?,state_desc=? where task_id=? AND batch_serial_no=?");
            ps.setString(1, state);
            ps.setString(2, CurrentDateUtil.getTodayDateEx2());
            ps.setBigDecimal(3, new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0)));
            ps.setString(4, skipTactic == 0 ? "1" : "0");
            ps.setString(5, info.toString());
            ps.setString(6, taskConf.getTaskId());
            ps.setString(7, batchSerialNo);
            ps.execute();
            bFlag = true;
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage());
                }
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return bFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBatchTaskToEndEx(BatchConfTask taskConf, long startMills, String state, String batchSerialNo) {
        boolean bFlag = false;
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer info = new StringBuffer();
        info.append("\u6700\u5927\u8fde\u63a5\u6570\uff1a").append(TConnPool.getDefaultPool().getConnectionCount()).append(",");
        info.append(JvmUtil.getJvmMemoryWithM());
        long endMills = System.currentTimeMillis();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            ps = conn.prepareStatement("update batch_inst_task set task_run_state=?,start_time=?,end_time=?,cost_time=?,task_intervene_state=?,state_desc=? where task_id=? AND batch_serial_no=?");
            ps.setString(1, state);
            ps.setString(2, CurrentDateUtil.getTodayDateEx2());
            ps.setString(3, CurrentDateUtil.getTodayDateEx2());
            ps.setBigDecimal(4, new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0)));
            ps.setString(5, "1");
            ps.setString(6, info.toString());
            ps.setString(7, taskConf.getTaskId());
            ps.setString(8, batchSerialNo);
            ps.execute();
            bFlag = true;
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage());
                }
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return bFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeLoadResult(PluginInstLoadtxt loadResult) {
        boolean bFlag = false;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            ps = conn.prepareStatement("delete from plugin_inst_loadtxt where batch_serial_no=? and table_name=?");
            ps.setString(1, loadResult.getBatchSerialNo());
            ps.setString(2, loadResult.getTableName());
            ps.execute();
            ps.close();
            ps = conn.prepareStatement("insert into plugin_inst_loadtxt(batch_serial_no,batch_date,batch_id,up_sysname,table_name,table_cnname,table_type,table_load_mode,load_from_file,file_size,start_time,end_time,cost_time,read_rows,load_rows,reject_rows,load_result,remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setString(1, loadResult.getBatchSerialNo());
            ps.setString(2, loadResult.getBatchDate());
            ps.setString(3, loadResult.getBatchId());
            ps.setString(4, loadResult.getUpSysname());
            ps.setString(5, loadResult.getTableName());
            ps.setString(6, loadResult.getTableCnname());
            ps.setString(7, loadResult.getTableType());
            ps.setString(8, loadResult.getTableLoadMode());
            ps.setString(9, loadResult.getLoadFromFile());
            ps.setBigDecimal(10, loadResult.getFileSize());
            ps.setString(11, loadResult.getStartTime());
            ps.setString(12, loadResult.getEndTime());
            ps.setBigDecimal(13, loadResult.getCostTime());
            ps.setInt(14, loadResult.getReadRows());
            ps.setInt(15, loadResult.getLoadRows());
            ps.setInt(16, loadResult.getRejectRows());
            ps.setString(17, loadResult.getLoadResult());
            ps.setString(18, loadResult.getRemark());
            ps.execute();
            bFlag = true;
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage());
                }
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        return bFlag;
    }
}

