/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.plugin.common;

import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.common.PluginConfSysupd;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.common.PluginConfSysupdDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.session.CustomTransaction;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.session.TransactionUtil;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.DateCalculate;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.date.DateConvert;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsInfoUpdatePlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SubsInfoUpdatePlugin.class);
    private List<PluginConfSysupd> sysupdList;
    private CustomTransaction tran;
    private static final int URPS_SUBS_DATA_DATE_ACT = 1;
    private static final int URPS_SUBS_LAST_DATA_DATE_ACT = 2;
    private static final int URPS_SUBS_LOAD_DATE_ACT = 3;
    private static final int URPS_SUBS_BAT_DATE_ACT = 4;
    private static final int UPD_SUBS_DATA_DATE_ACT = 5;
    private static final int UPD_SUBS_LAST_DATA_DATE_ACT = 6;
    private static final int UPD_SUBS_LOAD_DATE_ACT = 7;
    private static final int UPD_SUBS_BAT_DATE_ACT = 8;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginConfSysupdDao sysupdDao = new PluginConfSysupdDao(conn);
        this.sysupdList = sysupdDao.queryWithPluginConfId(szConfIdentify);
        if (this.sysupdList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u7cfb\u7edf\u4fe1\u606f\u66f4\u65b0\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Connection conn = null;
        conn = this.getPluginConnection();
        this.tran = TransactionUtil.createTransaction(conn);
        boolean bFlag = false;
        for (int i = 0; i < this.sysupdList.size(); ++i) {
            PluginConfSysupd psc = this.sysupdList.get(i);
            int iAction = Integer.valueOf(psc.getSysupdAction());
            String sql = "update s_subs_info set ";
            switch (iAction) {
                case 1: {
                    sql = sql + "subs_data_date=(select t.subs_data_date from (select subs_data_date from s_subs_info where subs_code='URPS') t) ";
                    break;
                }
                case 2: {
                    sql = sql + "subs_last_data_date=(select t.subs_last_data_date from (select subs_last_data_date from s_subs_info where subs_code='URPS') t)";
                    break;
                }
                case 3: {
                    sql = sql + "subs_load_date=subs_data_date";
                    break;
                }
                case 4: {
                    sql = sql + "subs_bat_date=subs_data_date";
                    break;
                }
                case 5: {
                    sql = sql + "subs_data_date='" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(this.context.getCurrentDataDate()), 1)) + "'";
                    break;
                }
                case 6: {
                    sql = sql + "subs_last_data_date='" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(this.context.getLastDataDate()), 1)) + "'";
                    break;
                }
                case 7: {
                    sql = sql + "subs_load_date='" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(this.context.getLoadFinishedDate()), 1)) + "'";
                    break;
                }
                case 8: {
                    sql = sql + "subs_bat_date='" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(this.context.getBatFinishedDate()), 1)) + "'";
                }
            }
            sql = sql + " where subs_code='" + this.context.getSubsCode() + "'";
            logger.info(sql);
            try {
                this.tran.executeSql(sql);
                bFlag = true;
                continue;
            }
            catch (SQLException e) {
                this.context.setSzLastErrorMsg(e.getMessage());
                logger.error(e.getMessage());
                bFlag = false;
            }
        }
        try {
            if (bFlag) {
                this.tran.commit();
            } else {
                this.tran.rollback();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            bFlag = false;
            this.context.setSzLastErrorMsg("\u63d0\u4ea4\u6216\u56de\u6eda\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            TransactionUtil.releaseTransaction(this.tran);
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return bFlag;
    }
}

