/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.executor;

import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.allinschedule.executor.engine.executor.core.util.vo.UniKeyValueObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutor {
    private static final int MAX_QUERY_SIZE = 10000;

    public static UniKeyValueObject querySingleResult(Connection conn, String sql) throws SQLException {
        return SqlExecutor.getSingleResult(conn, sql, false);
    }

    public static UniKeyValueObject querySingleResultEx(Connection conn, String sql) throws SQLException {
        return SqlExecutor.getSingleResult(conn, sql, true);
    }

    public static List<UniKeyValueObject> queryMultipleResult(Connection conn, String sql) throws SQLException {
        return SqlExecutor.getMultipleResult(conn, sql, false);
    }

    public static List<UniKeyValueObject> queryMultipleResultEx(Connection conn, String sql) throws SQLException {
        return SqlExecutor.getMultipleResult(conn, sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object queryOnlyOneValue(Connection conn, String sql) throws SQLException {
        ResultSet rs = null;
        String result = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            SafeReleaseUtil.close(rs, st, null);
            throw throwable;
        }
        SafeReleaseUtil.close(rs, st, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UniKeyValueObject getSingleResult(Connection conn, String sql, boolean flag) throws SQLException {
        UniKeyValueObject uvo = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            int index = 0;
            if (rs.next() && index < 10000) {
                ++index;
                uvo = new UniKeyValueObject(flag);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                for (int i = 1; i <= numCols; ++i) {
                    uvo.addVariable(rsmd.getColumnLabel(i), rs.getObject(i));
                }
            }
        }
        catch (Throwable throwable) {
            SafeReleaseUtil.close(rs, st, null);
            throw throwable;
        }
        SafeReleaseUtil.close(rs, st, null);
        return uvo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UniKeyValueObject> getMultipleResult(Connection conn, String sql, boolean flag) throws SQLException {
        ArrayList<UniKeyValueObject> uvoList = new ArrayList<UniKeyValueObject>();
        ResultSet rs = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql);
            while (rs != null && rs.next()) {
                UniKeyValueObject uvo = new UniKeyValueObject(flag);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                for (int i = 1; i <= numCols; ++i) {
                    uvo.addVariable(rsmd.getColumnLabel(i), rs.getObject(i));
                }
                uvoList.add(uvo);
            }
        }
        catch (Throwable throwable) {
            SafeReleaseUtil.close(rs, st, null);
            throw throwable;
        }
        SafeReleaseUtil.close(rs, st, null);
        return uvoList;
    }
}

