/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.core.util.network;

import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.log.TLogger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class IPUtil {
    private static String logCataName = "IPUtil";

    public static List<String> getAllLocalIP() {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return ipList;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            TLogger.getLogger(logCataName).debug("NetworkInterface:" + ni.getName());
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip == null || !ip.isSiteLocalAddress() || ip.isLoopbackAddress() || !(ip instanceof Inet4Address)) continue;
                TLogger.getLogger(logCataName).info("Local IP Address:" + ip.getHostAddress());
                ipList.add(ip.getHostAddress());
            }
        }
        return ipList;
    }

    public static boolean isLocalHostIP(String ip) {
        if (ip == null || "".equals(ip)) {
            return false;
        }
        List<String> ipList = IPUtil.getAllLocalIP();
        for (int i = 0; i < ipList.size(); ++i) {
            if (ipList.get(i) == null || !ipList.get(i).equals(ip.trim())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            IPUtil.getAllLocalIP();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

