/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.rest.job;

import com.irdstudio.allinschedule.executor.engine.executor.core.dao.BatchConfMasterDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.SSrvsCronConfDao;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchConfMaster;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.allinschedule.executor.engine.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinschedule.executor.engine.executor.rest.schedule.QuartzJobEngine;
import com.irdstudio.allinschedule.executor.engine.executor.rest.schedule.QuartzManager;
import com.irdstudio.allinschedule.executor.engine.executor.rest.schedule.ScheduleJobUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPollingJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(BatchPollingJob.class);
    private static final Map<String, SSrvsCronConf> batJoinInSchedule = new ConcurrentHashMap<String, SSrvsCronConf>();
    private static final AtomicBoolean running = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (running.get()) {
            return;
        }
        running.set(true);
        logger.info("\u5f00\u59cb\u68c0\u67e5\u6279\u6b21\u4e2d\u662f\u5426\u6709\u5b9a\u65f6\u8c03\u5ea6\u6279\u6b21");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            SSrvsCronConfDao sSrvsCronConfDao = new SSrvsCronConfDao(conn);
            BatchConfMasterDao batBatchInfoConfigDao = new BatchConfMasterDao(conn);
            List<BatchConfMaster> batchList = batBatchInfoConfigDao.queryWithCond("WHERE launch_type = '1' ", "order by batch_id");
            HashMap<String, BatchConfMaster> thisTimePolling = new HashMap<String, BatchConfMaster>();
            if (CollectionUtils.isNotEmpty(batchList)) {
                for (BatchConfMaster batch : batchList) {
                    int re;
                    SSrvsCronConf addConfVO;
                    thisTimePolling.put(batch.getBatchId(), batch);
                    if (!batJoinInSchedule.containsKey(batch.getBatchId())) {
                        addConfVO = new SSrvsCronConf();
                        addConfVO.setJobCode(batch.getBatchId());
                        addConfVO = sSrvsCronConfDao.queryByPK(addConfVO);
                        if (addConfVO == null) {
                            addConfVO = new SSrvsCronConf();
                            addConfVO.setJobCode(batch.getBatchId());
                            addConfVO.setJobDesc(batch.getBatchName());
                            addConfVO.setCronExpression(batch.getBatchCronValue());
                            addConfVO.setAgentId(batch.getAgentId());
                            addConfVO.setSubsId(batch.getSubsId());
                            addConfVO.setJobState("S");
                            addConfVO.setJobClass("com.irdstudio.allinschedule.executor.engine.executor.rest.job.BatchStarter");
                            addConfVO.setJobClassType("local");
                            addConfVO.setJobMethod("doExcetue");
                            addConfVO.setAgainTime(3);
                            addConfVO.setRetrySecond(60);
                            sSrvsCronConfDao.insertSSrvsCronConf(addConfVO);
                            if (addConfVO.getJobState().equals("S")) {
                                addConfVO.setJobState("A");
                                sSrvsCronConfDao.updateByPk(addConfVO);
                            }
                            QuartzManager.addJob(addConfVO.getJobCode(), ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + addConfVO.getJobCode(), ScheduleJobUtil.TRIGGER_GROUP_NAME, QuartzJobEngine.class, addConfVO.getCronExpression());
                        }
                        batJoinInSchedule.put(batch.getBatchId(), addConfVO);
                        continue;
                    }
                    addConfVO = batJoinInSchedule.get(batch.getBatchId());
                    if (StringUtils.equals((CharSequence)addConfVO.getCronExpression(), (CharSequence)batch.getBatchCronValue())) continue;
                    addConfVO.setJobCode(batch.getBatchId());
                    addConfVO.setJobDesc(batch.getBatchName());
                    addConfVO.setCronExpression(batch.getBatchCronValue());
                    addConfVO.setAgentId(batch.getAgentId());
                    addConfVO.setSubsId(batch.getSubsId());
                    addConfVO.setJobState("S");
                    addConfVO.setJobClass("com.irdstudio.allinschedule.executor.engine.executor.rest.job.BatchStarter");
                    addConfVO.setJobClassType("local");
                    addConfVO.setJobMethod("doExcetue");
                    addConfVO.setAgainTime(3);
                    addConfVO.setRetrySecond(60);
                    if (addConfVO.getJobState().equals("S")) {
                        addConfVO.setJobState("A");
                    }
                    if ((re = sSrvsCronConfDao.updateByPk(addConfVO)) == 0) {
                        sSrvsCronConfDao.insertSSrvsCronConf(addConfVO);
                    }
                    QuartzManager.removeJob(addConfVO.getJobCode(), ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + addConfVO.getJobCode(), ScheduleJobUtil.TRIGGER_GROUP_NAME);
                    QuartzManager.addJob(addConfVO.getJobCode(), ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + addConfVO.getJobCode(), ScheduleJobUtil.TRIGGER_GROUP_NAME, QuartzJobEngine.class, addConfVO.getCronExpression());
                }
                ArrayList<String> removeKeys = new ArrayList<String>();
                for (Map.Entry<String, SSrvsCronConf> entry : batJoinInSchedule.entrySet()) {
                    if (thisTimePolling.containsKey(entry.getKey())) continue;
                    String jobCode = entry.getValue().getJobCode();
                    QuartzManager.removeJob(jobCode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + jobCode, ScheduleJobUtil.TRIGGER_GROUP_NAME);
                    removeKeys.add(jobCode);
                    sSrvsCronConfDao.deleteByPk(entry.getValue());
                }
                for (String jobCode : removeKeys) {
                    batJoinInSchedule.remove(jobCode);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            running.set(false);
            if (conn != null) {
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        logger.info("\u7ed3\u675f\u68c0\u67e5\u6279\u6b21\u4e2d\u662f\u5426\u6709\u5b9a\u65f6\u8c03\u5ea6\u6279\u6b21");
    }
}

