/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinschedule.executor.engine.executor.rest.job;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.BatchInstMaster;
import com.irdstudio.allinschedule.executor.engine.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.allinschedule.executor.engine.executor.core.plugin.invoke.FeignClientInvokePlugin;
import com.irdstudio.allinschedule.executor.engine.executor.rest.job.ScheduleJob;
import com.irdstudio.allinschedule.executor.engine.facade.operation.PluginConfParamService;
import com.irdstudio.allinschedule.executor.engine.facade.operation.PluginConfServiceService;
import com.irdstudio.allinschedule.executor.engine.facade.operation.dto.PluginConfParamDTO;
import com.irdstudio.allinschedule.executor.engine.facade.operation.dto.PluginConfServiceDTO;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class FeignClientInvokeStarter
implements ScheduleJob {
    private static final Logger logger = LoggerFactory.getLogger(FeignClientInvokeStarter.class);

    @Override
    public void doExecute(Connection conn, SSrvsCronConf conf) {
        logger.info("\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6267\u884c\u8c03\u7528\u5f00\u59cb");
        try {
            if (conf != null && StringUtils.isNotEmpty((CharSequence)conf.getJobCode())) {
                String defaultAction = "run";
                String jobCode = conf.getJobCode();
                NacosDiscoveryClient nacosClient = (NacosDiscoveryClient)SpringContextUtils.getBean(NacosDiscoveryClient.class);
                Decoder decoder = (Decoder)SpringContextUtils.getBean(Decoder.class);
                Encoder encoder = (Encoder)SpringContextUtils.getBean(Encoder.class);
                Client client = (Client)SpringContextUtils.getBean(Client.class);
                Contract contract = (Contract)SpringContextUtils.getBean(Contract.class);
                PluginConfServiceService pluginServiceConfService = (PluginConfServiceService)SpringContextUtils.getBean(PluginConfServiceService.class);
                PluginConfParamService pluginServiceParamService = (PluginConfParamService)SpringContextUtils.getBean(PluginConfParamService.class);
                PluginConfServiceDTO serviceConfig = new PluginConfServiceDTO();
                serviceConfig.setPluginConfId(jobCode);
                serviceConfig.setConfSort(Integer.valueOf(1));
                serviceConfig = pluginServiceConfService.queryByPk(serviceConfig);
                String serviceId = serviceConfig.getServiceId();
                List nacosServiceList = nacosClient.getInstances(serviceId);
                if (CollectionUtils.isEmpty((Collection)nacosServiceList)) {
                    logger.error("\u672a\u627e\u5230\u6307\u5b9a\u670d\u52a1\u5b9e\u4f8b " + serviceId);
                    return;
                }
                ServiceInstance serviceInstance = (ServiceInstance)nacosServiceList.get(0);
                String appPath = (String)serviceInstance.getMetadata().get("appPath");
                try {
                    FeignClientInvokePlugin.JobInvokeService service = (FeignClientInvokePlugin.JobInvokeService)Feign.builder().client(client).encoder(encoder).decoder(decoder).contract(contract).options(new Request.Options(300000, 300000)).retryer(Retryer.NEVER_RETRY).target(FeignClientInvokePlugin.JobInvokeService.class, String.format("http://%s/%s", serviceInstance.getServiceId(), appPath));
                    HashMap<String, String> extParam = new HashMap<String, String>();
                    if (StringUtils.isNotBlank((CharSequence)serviceConfig.getParamGroupId())) {
                        PluginConfParamDTO param = new PluginConfParamDTO();
                        param.setParamGroupId(serviceConfig.getParamGroupId());
                        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
                        List paramList = pluginServiceParamService.queryList(param);
                        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
                            for (PluginConfParamDTO serviceParam : paramList) {
                                extParam.put(serviceParam.getServiceParamName(), serviceParam.getServiceParamValue());
                            }
                        }
                    }
                    BatchInstMaster invokeParam = new BatchInstMaster();
                    invokeParam.setBatchId(jobCode);
                    invokeParam.setBatchName(conf.getJobDesc());
                    int output = service.execute(serviceConfig.getServiceMethod(), invokeParam);
                    logger.info(serviceConfig.getServiceMethod() + "\u670d\u52a1\u6267\u884c\u7ed3\u679c\uff1a" + output);
                    return;
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                    return;
                }
            }
            logger.error("\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6267\u884c\u51fa\u9519, \u6ca1\u6709\u6307\u5b9a\u5b9a\u65f6\u6279\u6b21\uff01");
        }
        catch (Exception e) {
            logger.error("\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6267\u884c\u51fa\u9519\uff01", (Throwable)e);
        }
        logger.info("\u8fdc\u7a0b\u670d\u52a1\u8c03\u7528\u6267\u884c\u8c03\u7528\u7ed3\u675f");
    }
}

