/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.admin.web.controller.api;

import com.irdstudio.allintcp.sdk.admin.facade.operation.SModuleInfoService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SRolemoduleService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SRolesubsService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SRoleuserService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SUserProfileService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SModuleInfoDTO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SRolemoduleDTO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SRolesubsDTO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SRoleuserDTO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SUserProfileDTO;
import com.irdstudio.allintcp.sdk.dict.facade.operation.SDicService;
import com.irdstudio.allintcp.sdk.dict.facade.operation.dto.SDicDTO;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
public class PortalClientController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractController.class);
    @Autowired
    private SRoleuserService sRoleuserService;
    @Autowired
    private SDicService sDicService;
    @Autowired
    private SModuleInfoService sModuleInfoService;
    @Autowired
    private SUserService sUserService;
    @Autowired
    private SUserProfileService sUserProfileService;
    @Autowired
    private SRolemoduleService sRolemoduleService;
    @Autowired
    private SRolesubsService sRolesubsService;
    @Autowired
    private SeqInstInfoService seqInstInfoService;

    @RequestMapping(value={"/s/roleusers"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SRoleuserDTO> querySRoleuserAll(@RequestBody SRoleuserDTO vo) {
        List outputVo = this.sRoleuserService.queryList((Object)vo);
        return outputVo;
    }

    @RequestMapping(value={"/s/dics"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SDicDTO> queryDicList(@RequestBody SDicDTO sDicDTO) {
        return this.sDicService.queryList((Object)sDicDTO);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer addDic(@RequestBody SDicDTO sDicDTO) {
        return this.sDicService.insert((Object)sDicDTO);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.PUT})
    @ResponseBody
    public Integer updateDic(@RequestBody SDicDTO sDicDTO) {
        return this.sDicService.updateByPk(sDicDTO);
    }

    @RequestMapping(value={"/s/dic"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Integer deleteDic(@RequestBody SDicDTO sDicDTO) {
        return this.sDicService.deleteByPk(sDicDTO);
    }

    @RequestMapping(value={"/s/module/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SModuleInfoDTO> querySModuleInfoAll(@RequestBody SModuleInfoDTO vo) {
        List outputVo = this.sModuleInfoService.queryList((Object)vo);
        return outputVo;
    }

    @RequestMapping(value={"/s/module/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public Integer updateModuleByPk(@RequestBody SModuleInfoDTO sModuleInfo) {
        return this.sModuleInfoService.updateByPk((Object)sModuleInfo);
    }

    @RequestMapping(value={"/s/module/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Integer deleteModuleByPk(@RequestBody SModuleInfoDTO sModuleInfo) {
        return this.sModuleInfoService.deleteByPk((Object)sModuleInfo);
    }

    @RequestMapping(value={"/s/user/{actorno}"}, method={RequestMethod.GET})
    @ResponseBody
    public SUserDTO querySUserByPk(@PathVariable(value="actorno") String actorno) {
        SUserDTO inVo = new SUserDTO();
        inVo.setActorno(new String(actorno));
        SUserDTO outputVo = (SUserDTO)this.sUserService.queryByPk((Object)inVo);
        return outputVo;
    }

    @RequestMapping(value={"/s/user/profile/{actorno}"}, method={RequestMethod.GET})
    @ResponseBody
    public SUserProfileDTO querySUserProfileByPk(@PathVariable(value="actorno") String actorno) {
        SUserProfileDTO inVo = new SUserProfileDTO();
        inVo.setActorno(actorno);
        SUserProfileDTO outputVo = (SUserProfileDTO)this.sUserProfileService.queryByPk((Object)inVo);
        return outputVo;
    }

    @RequestMapping(value={"/s/rolesubss/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SRolesubsDTO> querySRolesubsAllNotPage(@RequestBody SRolesubsDTO vo) {
        return this.sRolesubsService.queryList((Object)vo);
    }

    @RequestMapping(value={"/s/rolemodules/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SRolemoduleDTO> querySRolemoduleAllNotPage(@RequestBody SRolemoduleDTO vo) {
        return this.sRolemoduleService.queryList((Object)vo);
    }

    @RequestMapping(value={"/s/users"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SUserDTO> querySUserList(@RequestBody SUserDTO param) {
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        return this.sUserService.queryList((Object)param);
    }

    @RequestMapping(value={"/s/users/batchInsert"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer batchSUserList(@RequestBody List<SUserDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int outputVo = 0;
            for (SUserDTO user : list) {
                user.setState("0");
                int num = this.sUserService.insert((Object)user);
                if (num <= 0) continue;
                ++outputVo;
            }
            return outputVo;
        }
        return 0;
    }

    @RequestMapping(value={"/AllinCloudPortalClient/deleteSRoleSubsByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteSRoleSubsByCond(@RequestBody SRolesubsDTO rolesubsDTO) {
        return this.sRolesubsService.deleteByCond(rolesubsDTO);
    }

    @RequestMapping(value={"/AllinCloudPortalClient/batchInsertRoleSubs"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer batchInsertRoleSubs(@RequestBody List<SRolesubsDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int outputVo = 0;
            for (SRolesubsDTO roleSubs : list) {
                int re = this.sRolesubsService.insert((Object)roleSubs);
                if (re <= 0) continue;
                ++outputVo;
            }
            return outputVo;
        }
        return 0;
    }

    @RequestMapping(value={"/client/SeqInstInfoService/nextSequence"}, method={RequestMethod.POST})
    @ResponseBody
    public String nextSequence(@RequestParam(value="seqId") String seqId, @RequestParam(value="owner", required=false) String owner) {
        return this.seqInstInfoService.nextSequence(seqId, owner);
    }
}

