/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.admin.application.operation;

import com.irdstudio.allintcp.sdk.admin.acl.repository.SRolerightRepository;
import com.irdstudio.allintcp.sdk.admin.domain.entity.SRolerightDO;
import com.irdstudio.allintcp.sdk.admin.facade.operation.SRolerightService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SRolerightDTO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.ZTreeVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="SRolerightServiceImpl")
public class SRolerightServiceImpl
extends BaseServiceImpl<SRolerightDTO, SRolerightDO, SRolerightRepository>
implements SRolerightService {
    private static final String RESOURCE_DESCRIBE = "\u83dc\u5355\u8bbf\u95ee";

    public int saveSRoleRight(SRolerightDTO sRolerightVO) {
        int result = 0;
        SRolerightDO sRoleright = new SRolerightDO();
        this.beanCopy(sRolerightVO, sRoleright);
        result += ((SRolerightRepository)this.getRepository()).deleteSRoleRight(sRoleright);
        List<String> actIdList = null;
        String actIdStr = sRolerightVO.getActIdStr();
        if (!StringUtils.isEmpty((String)actIdStr)) {
            actIdList = Arrays.asList(actIdStr.split(","));
        }
        if (Objects.nonNull(actIdList) && actIdList.size() > 0) {
            String sourceId = sRoleright.getResourceid();
            String roleNo = sRoleright.getRoleno();
            List<SRolerightDO> sRoleRightList = this.getParentResActId(sourceId, roleNo);
            for (String actId : actIdList) {
                SRolerightDO temp = new SRolerightDO();
                temp.setRoleno(roleNo);
                temp.setResourceid(sourceId);
                temp.setActid(actId);
                sRoleRightList.add(temp);
            }
            result = ((SRolerightRepository)this.getRepository()).batchInsert(sRoleRightList);
        }
        return result;
    }

    public int saveSRoleRightTree(List<ZTreeVO> tree, String roleno) {
        int result = 0;
        SRolerightDO sRoleright = new SRolerightDO();
        sRoleright.setRoleno(roleno);
        result = ((SRolerightRepository)this.getRepository()).deleteByPk((Object)sRoleright);
        List<SRolerightDO> sRolerightList = this.getTreeSRoleRights(tree, roleno);
        result = ((SRolerightRepository)this.getRepository()).batchInsert(sRolerightList);
        return result;
    }

    private List<SRolerightDO> getTreeSRoleRights(List<ZTreeVO> tree, String roleno) {
        ArrayList<SRolerightDO> result = new ArrayList<SRolerightDO>();
        for (ZTreeVO item : tree) {
            SRolerightDO sRoleright = new SRolerightDO();
            if (item.getIsBase().booleanValue() && item.getChecked().booleanValue()) {
                sRoleright.setRoleno(roleno);
                sRoleright.setResourceid(item.getId());
                sRoleright.setActid("visit");
                if (item.getChildren() != null && item.getChildren().size() > 0) {
                    result.addAll(this.getTreeSRoleRights(item.getChildren(), roleno));
                }
                result.add(sRoleright);
                continue;
            }
            if (!item.getChecked().booleanValue()) continue;
            sRoleright.setRoleno(roleno);
            sRoleright.setResourceid(item.getId());
            sRoleright.setActid(item.getId());
            result.add(sRoleright);
        }
        return result;
    }

    private List<SRolerightDO> getParentResActId(String resourceId, String roleNo) {
        ArrayList<SRolerightDO> result = new ArrayList<SRolerightDO>();
        List sRoleRightList = ((SRolerightRepository)this.getRepository()).queryParentResInfo(resourceId, RESOURCE_DESCRIBE, roleNo);
        while (Objects.nonNull(sRoleRightList) && sRoleRightList.size() > 0) {
            SRolerightDO sRoleright = (SRolerightDO)sRoleRightList.get(0);
            if (StringUtils.isNotBlank((String)sRoleright.getActid())) {
                sRoleright.setRoleno(roleNo);
                result.add(sRoleright);
            }
            sRoleRightList = ((SRolerightRepository)this.getRepository()).queryParentResInfo(sRoleright.getResourceid(), RESOURCE_DESCRIBE, roleNo);
        }
        return result;
    }
}

