/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.admin.web.operation;

import com.irdstudio.allintcp.sdk.admin.facade.operation.SResourceService;
import com.irdstudio.allintcp.sdk.admin.facade.operation.dto.SResourceDTO;
import com.irdstudio.allintcp.sdk.admin.web.ssm.util.TreeNodeUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.core.vo.ZTreeVO;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SResourceController
extends BaseController<SResourceDTO, SResourceService> {
    @RequestMapping(value={"/api/s/resources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceDTO>> querySResourceAll(SResourceDTO vo) {
        List outputVo = ((SResourceService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resource/{resourceid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SResourceDTO> queryByPk(@PathVariable(value="resourceid") String resourceid) {
        SResourceDTO inVo = new SResourceDTO();
        inVo.setResourceid(new String(resourceid));
        SResourceDTO outputVo = (SResourceDTO)((SResourceService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SResourceDTO inSResourceVo) {
        int outputVo = ((SResourceService)this.getService()).deleteByPk((Object)inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SResourceDTO inSResourceVo) {
        int outputVo = ((SResourceService)this.getService()).updateByPk((Object)inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSResource(@RequestBody SResourceDTO inSResourceVo) {
        int outputVo = ((SResourceService)this.getService()).insert((Object)inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resources/all/menus"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<SResourceDTO>> queryAllMenuTree(@RequestParam(value="actorno") String actorno) {
        List result = ((SResourceService)this.getService()).queryAllByActorno(actorno);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/admin/menu/onelevel"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceDTO>> queryOneLevelAll(SResourceDTO vo) {
        if (StringUtils.isBlank((CharSequence)vo.getSystempk())) {
            return ResponseData.create(null, (String)"-1", (String)"\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6", (boolean)false);
        }
        vo.setParentid("root");
        List outputVo = ((SResourceService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/admin/menu/submenus"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceDTO>> querySubmenusAll(SResourceDTO vo) {
        if (StringUtils.isBlank((CharSequence)vo.getParentid())) {
            return ResponseData.create(null, (String)"-1", (String)"\u83dc\u5355\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6", (boolean)false);
        }
        List outputVo = ((SResourceService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/resources/{subsId}/{actorno}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ZTreeVO> queryMenusAll(@PathVariable(value="subsId") String subsId, @PathVariable(value="actorno") String actorno, @RequestParam(value="onlyFirst", required=false) boolean onlyFirst) {
        ArrayList<ZTreeVO> outputVo = null;
        List result = Collections.emptyList();
        if (onlyFirst) {
            SResourceDTO params = new SResourceDTO();
            params.setParentid(subsId);
            params.setLoginUserId(actorno);
            result = ((SResourceService)this.getService()).queryList((Object)params);
        } else {
            result = ((SResourceService)this.getService()).queryAllByActorno(actorno);
        }
        if (Objects.nonNull(result)) {
            outputVo = TreeNodeUtil.getSResourceTree(result, subsId);
        }
        return outputVo;
    }

    @RequestMapping(value={"/api/s/resources/onetree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<SResourceDTO>> queryMenuOneTree(@RequestParam(value="actorno") String actorno, @RequestParam(value="resourceid", required=false) String resourceid) {
        List result = ((SResourceService)this.getService()).queryAllByActorno(actorno);
        if (StringUtils.isBlank((CharSequence)resourceid)) {
            return this.getResponseData(result);
        }
        ArrayList<SResourceDTO> output = new ArrayList<SResourceDTO>();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (SResourceDTO re : result) {
                map.put(re.getResourceid(), re);
                String parentId = re.getParentid();
                String pkey = "$$pkey-" + parentId;
                ArrayList<SResourceDTO> children = (ArrayList<SResourceDTO>)map.get(pkey);
                if (children == null) {
                    children = new ArrayList<SResourceDTO>();
                    map.put(pkey, children);
                }
                children.add(re);
            }
            SResourceDTO root = (SResourceDTO)map.get(resourceid);
            if (root != null) {
                output.add(root);
                this.findMenuTreeChild(resourceid, map, output);
            }
        }
        return this.getResponseData(output);
    }

    private void findMenuTreeChild(String parentId, Map<String, Object> map, List<SResourceDTO> output) {
        String pkey = "$$pkey-" + parentId;
        List children = (List)map.get(pkey);
        if (children != null) {
            for (SResourceDTO re : children) {
                output.add(re);
                this.findMenuTreeChild(re.getResourceid(), map, output);
            }
        }
    }

    @RequestMapping(value={"/api/s/resources"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ZTreeVO> querySubsMenusAll(@RequestParam(value="subsId") String subsId, @RequestParam(value="userId", required=false) String actorno, @RequestParam(value="onlyFirst", required=false) boolean onlyFirst) {
        ArrayList<ZTreeVO> outputVo = null;
        List result = Collections.emptyList();
        if (onlyFirst) {
            SResourceDTO params = new SResourceDTO();
            params.setParentid(subsId);
            params.setLoginUserId(actorno);
            result = ((SResourceService)this.getService()).queryList((Object)params);
        } else {
            result = ((SResourceService)this.getService()).queryAllByActorno(actorno);
        }
        if (Objects.nonNull(result)) {
            outputVo = TreeNodeUtil.getSResourceTree(result, subsId);
        }
        return outputVo;
    }

    @RequestMapping(value={"/api/s/resource/all/{subsId}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ZTreeVO> queryMenusAll(SResourceDTO vo, @PathVariable(value="subsId") String subsId) {
        ArrayList<ZTreeVO> outputVo = null;
        List result = ((SResourceService)this.getService()).queryList((Object)vo);
        if (Objects.nonNull(result)) {
            outputVo = TreeNodeUtil.getSResourceTree(result, subsId);
        }
        return outputVo;
    }

    @RequestMapping(value={"/api/s/resource/Rights/{roleno}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ZTreeVO> queryMenusRights(@PathVariable(value="roleno") String roleno) {
        List<ZTreeVO> outputVo = null;
        List result = ((SResourceService)this.getService()).queryMenusRights(roleno);
        if (Objects.nonNull(result) && CollectionUtils.isNotEmpty(outputVo = TreeNodeUtil.getSResourceRightTree(result))) {
            for (ZTreeVO t : outputVo) {
                if (!CollectionUtils.isNotEmpty((Collection)t.getChildren())) continue;
                for (ZTreeVO child : t.getChildren()) {
                    child.setState("open");
                }
            }
        }
        return outputVo;
    }
}

