/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.query.manual.application.operation;

import com.irdstudio.allintcp.sdk.query.facade.operation.dto.QryModelInfoDTO;
import com.irdstudio.allintcp.sdk.query.manual.facade.operation.QueryService;
import com.irdstudio.allintcp.sdk.query.manual.facade.operation.dto.QryModelSortDTO;
import com.irdstudio.allintcp.sdk.query.manual.facade.operation.dto.QryTableConfigDTO;
import com.irdstudio.framework.beans.core.base.FrameworkService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImpl
extends SqlSessionDaoSupport
implements QueryService,
FrameworkService {
    public static Logger logger = LoggerFactory.getLogger(QueryServiceImpl.class);
    public static Map<String, QryTableConfigDTO> queryConfigMap = new HashMap<String, QryTableConfigDTO>();

    protected void checkDaoConfig() {
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)SpringContextUtils.getBean(SqlSessionFactory.class);
        this.setSqlSessionFactory(sqlSessionFactory);
        super.checkDaoConfig();
    }

    public String getMapperId(String method) {
        return method;
    }

    public List<Map<String, Object>> queryListByMapperId(String qryId, String method, Map<String, Object> params) {
        QryModelInfoDTO qryModel = queryConfigMap.get(qryId).getQryInfo();
        List sortList = (List)params.get("sortList");
        String descOrder = MapUtils.getString(params, (Object)"descOrder");
        String ascOrder = MapUtils.getString(params, (Object)"ascOrder");
        BaseInfo paramHandlerObj = new BaseInfo();
        if (CollectionUtils.isNotEmpty((Collection)sortList)) {
            for (QryModelSortDTO sort : sortList) {
                if (StringUtils.equalsIgnoreCase((CharSequence)sort.getSortType(), (CharSequence)"asc")) {
                    paramHandlerObj.setAscOrder(sort.getJavaPropertyName());
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)sort.getSortType(), (CharSequence)"desc")) continue;
                paramHandlerObj.setDescOrder(sort.getJavaPropertyName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)descOrder) || StringUtils.isNotBlank((CharSequence)ascOrder)) {
            paramHandlerObj.setAscOrder(ascOrder);
            paramHandlerObj.setDescOrder(descOrder);
        }
        params.put("order", paramHandlerObj.getOrder());
        String filterCond = MapUtils.getString(params, (Object)"filterCond");
        if (StringUtils.isNotBlank((CharSequence)filterCond)) {
            paramHandlerObj.setFilterCond(filterCond);
            params.put("filterItemList", paramHandlerObj.getFilterItemList());
        }
        List result = this.getSqlSession().selectList(this.getMapperId(method), params);
        paramHandlerObj.setTotal(MapUtils.getInteger(params, (Object)"total"));
        paramHandlerObj.setSize(MapUtils.getInteger(params, (Object)"size"));
        paramHandlerObj.setPage(MapUtils.getInteger(params, (Object)"page"));
        this.pageSetMap(result, paramHandlerObj);
        return result;
    }
}

