/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.report.manual.application.operation;

import com.irdstudio.allintcp.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintcp.sdk.report.facade.operation.RptModelInfoService;
import com.irdstudio.allintcp.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.allintcp.sdk.report.facade.operation.dto.RptModelInfoDTO;
import com.irdstudio.allintcp.sdk.report.manual.facade.operation.RptExportManualService;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.print.PageSize;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service(value="RptExportManualServiceImpl")
public class RptExportManualServiceImpl
implements RptExportManualService {
    private static Logger logger = LoggerFactory.getLogger(RptExportManualServiceImpl.class);
    @Autowired
    private RptInstInfoService rptInstInfoService;
    @Autowired
    private RptModelInfoService rptModelInfoService;
    @Value(value="${allintcp.sdk.report.export.path:/var/tmp/apps/}")
    private String pdfFileStorageRoot;
    @Value(value="${chromium.webdriver:}")
    private String webDriver;
    @Value(value="${cas.client-host-url:}")
    private String serverHost;
    @Value(value="${server.servlet.contextPath:}")
    private String serverContextPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportToPdf(String rptInstId, String rptModelId, String startDate, String endDate, Map<String, String> queryMap) {
        RptInstInfoDTO instInfo = new RptInstInfoDTO();
        instInfo.setRptInstId(rptInstId);
        instInfo = this.rptInstInfoService.queryByPk(instInfo);
        if (instInfo == null) {
            RptModelInfoDTO rptModel = new RptModelInfoDTO();
            rptModel.setRptModelId(rptInstId);
            rptModel = this.rptModelInfoService.queryByPk(rptModel);
            if (rptModel != null) {
                instInfo = new RptInstInfoDTO();
                instInfo.setRptInstId(rptInstId);
                instInfo.setRptInstName(rptModel.getRptModelName());
                instInfo.setRptInstPage(rptModel.getRptInstPage());
            }
        }
        ChromeDriver driver = null;
        try {
            Object url;
            System.setProperty("webdriver.chrome.driver", this.webDriver);
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"headless", "no-sandbox"});
            options.addArguments(new String[]{"--no-sandbox"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--window-size=1920,1024"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            driver = new ChromeDriver(options);
            String serverHost = this.serverHost;
            if (StringUtils.endsWith((CharSequence)serverHost, (CharSequence)"/")) {
                serverHost = serverHost.substring(0, serverHost.length() - 1);
            }
            url = StringUtils.startsWith((CharSequence)(url = instInfo.getRptInstPage()), (CharSequence)"/") ? String.format("%s%s", serverHost, url) : String.format("%s%s/%s", serverHost, this.serverContextPath, url);
            if (StringUtils.indexOf((CharSequence)(url = (String)url + String.format("&startDate=%s&endDate=%s&mode=print&tabTitle=%s", startDate, endDate, instInfo.getRptInstName())), (CharSequence)"${") >= 0) {
                url = ExpressionUtil.parse((String)url, queryMap);
            }
            driver.get((String)url);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, Duration.ofSeconds(60L));
            wait.until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)By.className((String)"el-table__row")));
            int pageHeight = NumberUtils.toInt((String)driver.executeScript("return $('body').height()", new Object[0]).toString());
            PrintOptions printOptions = new PrintOptions();
            printOptions.setShrinkToFit(false);
            printOptions.setPageSize(new PageSize((double)pageHeight * 0.04, 68.6));
            printOptions.setScale(1.2);
            Pdf webPdf = driver.print(printOptions);
            String base64Pdf = webPdf.getContent();
            byte[] decodedBytes = Base64Utils.decodeFromString((String)base64Pdf);
            File file = new File(this.pdfFileStorageRoot, rptInstId + ".pdf");
            try (FileOutputStream fop = new FileOutputStream(file);){
                IOUtils.write((byte[])decodedBytes, (OutputStream)fop);
            }
            logger.info("\u62a5\u8868\u5bfc\u51fapdf {} size {}", (Object)file.getAbsolutePath(), (Object)(file.length() / 0x100000L));
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            logger.error("\u62a5\u8868\u5bfc\u51fapdf\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
        return null;
    }
}

