(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 我的报表实例
    exports.MyRptInstInfoList = {
        props: {
            tabTitle: String,
            rootPath: String,
            rptModelCategory: String,
            rptInstValue: String,
        },
        inject: ['searchParams', 'signUserId'],
        data(){
            return {
                dgUrl: this.rootPath + 'api/RptInstInfo/queryList',
                signUserId: signUserId,
                queryParams: {
                    "rptInstId": "",
                    "rptInstName": "",
                    "rptInstType": "",
                    "rptInstRealtime": "",
                    "tableModelName": "",
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                if (self.rptInstValue && self.rptInstValue.length > 0) {
                    let conds = JSON.parse(params.filterCond || '[]');
                    conds.push({"op":"i","key":"rptInstValue","values": self.rptInstValue.split(',') })
                    params.filterCond = JSON.stringify(conds)
                }
                return params
            },
            queryList() {
                const self = this;
                if (!self.rptInstValue) {
                    return;
                }
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            doView(row){
                const self = this
                ElementDialog.createDialog(`查看`,`${self.rootPath}page/allintcp/sdk/report/RptInstInfoView.html?rptInstId=${row.rptInstId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doReportView(row){
                const self = this
                window.parent.addTab(`${row.rptInstName}浏览`,`${this.rootPath}page/allintcp/sdk/report/manual/ReportView.html?winTitle=${row.rptInstName}浏览&rptModelId=${row.rptModelId}&rptInstId=${row.rptInstId}`)
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            },
        },
        computed:{
            breadcrumb() {
                return `报表列表`
            },

            DIC() {
                return {
                    GROUP_RPT_MODEL_TYPE: [
                        {'enname': '', 'cnname': '全部'},
                        { 'enname': 'C', 'cnname': '周期报表' },
                        { 'enname': 'R', 'cnname': '实时报表' },
                    ],

                    RPT_MODEL_CATEGORY: [
                        { 'enname': 'A', 'cnname': '分析报表' },
                        { 'enname': 'C', 'cnname': '统计报表' },
                    ],
                    RPT_MODEL_TYPE: [
                        { 'enname': 'C', 'cnname': '周期报表' },
                        { 'enname': 'I', 'cnname': '指标分析报表' },
                        { 'enname': 'R', 'cnname': '实时报表' },
                    ],
                    RPT_MODEL_CYCLE: [
                        { 'enname': 'D', 'cnname': '日报' },
                        { 'enname': 'M', 'cnname': '月报' },
                        { 'enname': 'R', 'cnname': '实时' },
                        { 'enname': 'S', 'cnname': '季报' },
                        { 'enname': 'W', 'cnname': '周报' },
                        { 'enname': 'Y', 'cnname': '年报' },
                    ],
                    STD_PUB_YN: [
                        { 'enname': 'N', 'cnname': '否' },
                        { 'enname': 'Y', 'cnname': '是' },
                    ],
                    RPT_MODEL_VISIT: [
                        { 'enname': 'C', 'cnname': '公共' },
                        { 'enname': 'P', 'cnname': '私有' },
                    ],
                }
            },
            filterConfig() {
                return [
                    { key: 'rptInstId', name: '报表编号', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCode', name: '报表代码', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstName', name: '报表名称', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCategory', name: '报表类别', type: 'checkbox', opType: this.DIC.RPT_MODEL_CATEGORY, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstType', name: '报表类型', type: 'checkbox', opType: this.DIC.RPT_MODEL_TYPE, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                    { key: 'rptInstCycle', name: '报表周期', type: 'checkbox', opType: this.DIC.RPT_MODEL_CYCLE, opOption: window.FILTER_OP_TYPE.filter(el=>['i', 'ni'].indexOf(el.enname) >= 0),},
                ]
            },
            sortConfig() {
                return [
                    {label: '按报表编号顺序', key: 'rptInstId', type: 'asc'},
                    {label: '按报表编号倒序', key: 'rptInstId', type: 'desc'},
                    {label: '按报表排序字段顺序', key: 'orderValue', type: 'asc'},
                    {label: '按报表排序字段倒序', key: 'orderValue', type: 'desc'},
                ]
            },
            groupConfig() {
                return [
                    {
                        id: 1,
                        label: '按报表类型',
                        key: 'rptInstType',
                        dgUrl: this.dgUrl,
                        queryParams: this.queryParams,
                        queryParamsHandler: this.queryParamsHandler,
                        change: this.allSearch,
                        opType: this.DIC.GROUP_RPT_MODEL_TYPE,
                    },
                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.groupItem = self.groupConfig[0];
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                    <group-dropdown v-model="groupItem" :group-config="groupConfig"></group-dropdown>
                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             enable-search
                             :all-items="[]"
                             @all-search="allSearch"
                >
                    <template #more>
                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                            <el-row v-if="groupItem">
                                <el-col :span="24">
                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </template>
                </page-search>
                <template v-if="listView">
                    <el-table :data="tableData"
                              v-loading="loading"
                              stripe border
                              highlight-current-row
                              @current-change="handlerTableCurrentChange" @row-dblclick="doReportView"
                              tooltip-effect="light"
                              :tooltip-options="{placement : 'bottom'}"
                              style="width: 100%" >
                        <el-table-column type="index" width="45" ></el-table-column>
                        <el-table-column resizable prop="rptInstId" label="报表编号"  show-overflow-tooltip   >
                            <template #default="{row, $index}">
                                <el-link type="primary" :underline="false" @click="doView(row)">{{row.rptInstId}}</el-link>
                            </template>
                        </el-table-column>
                        <el-table-column resizable prop="rptInstName" label="报表名称"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column resizable prop="rptInstCategory" label="报表类别"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_CATEGORY', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="rptInstType" label="报表类型"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_TYPE', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="rptInstCycle" label="报表周期"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('RPT_MODEL_CYCLE', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="rptSubscribeFlag" label="是否可订阅"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('STD_PUB_YN', value)" >
                        </el-table-column>
                        <el-table-column resizable prop="rptFillFlag" label="是否可填充"  show-overflow-tooltip  :formatter="(row, column , value)=>formatterDic('STD_PUB_YN', value)" >
                        </el-table-column>
                        <el-table-column label="操作" fixed="right" width="180" header-align="center">
                            <template #default="{row, $index}">
                                <el-button class="button" text type="default"  @click="doReportView(row)"><el-icon><i class="iconfont icon-yulan"></i></el-icon>浏览</el-button>
                            </template>
                        </el-table-column>
                    </el-table>
                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                </template>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }

}));