/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.report.autoconfigure;

import com.irdstudio.allintcp.sdk.report.manual.application.operation.AutoLoadReportDataServiceImpl;
import com.irdstudio.allintcp.sdk.report.manual.application.operation.ReportServiceImpl;
import com.irdstudio.allintcp.sdk.report.manual.facade.operation.ReportService;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.irdstudio.allintcp.sdk.report"})
public class AllintpaasSdkReportAutoConfiguration {
    @Bean
    public MapperScannerConfigurer allintcpSdkReportMapperScannerConfigurer() {
        MapperScannerConfigurer scanner = new MapperScannerConfigurer();
        scanner.setBasePackage("com.irdstudio.allintcp.sdk.report.**.infra.persistence.mapper");
        return scanner;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringContextUtils.class})
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils utils = new SpringContextUtils();
        utils.setApplicationContext(ctx);
        return utils;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReportService.class})
    public ReportService rptService(SqlSessionFactory sqlSessionFactory) {
        ReportServiceImpl service = new ReportServiceImpl();
        service.setSqlSessionFactory(sqlSessionFactory);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean(value={AutoLoadReportDataServiceImpl.class})
    @ConditionalOnProperty(value={"allintcp.sdk.report.load.data.enabled"}, matchIfMissing=true)
    public AutoLoadReportDataServiceImpl autoLoadReportDataService() {
        AutoLoadReportDataServiceImpl service = new AutoLoadReportDataServiceImpl();
        return service;
    }

    @ConditionalOnMissingBean(type={"com.irdstudio.allintcp.sdk.bi.autoconfigure.AllintpaasSdkBiAutoConfiguration.AllintpaasSdkBiMvcConfig"})
    @Configuration
    @EnableWebMvc
    public class AllintpaasSdkReportMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*/**"}).addResourceLocations(new String[]{"classpath:/front/"});
        }
    }
}

