(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    const BaseCard = {
        props: {
            innerCardName: String,
            cardInfo: {
                type: Object,
            }
        },
        inject: ['DIC', 'colors', 'widths', 'pageHeadTitle', 'windowHeight', 'windowWidth', 'signUserId', 'fixedFlag', 'searchParams'],
        data(){
            return {
                localCard: {...this.cardInfo} ,
                cardMorePop: false,
                fullscreen: false,
                oldWidth: 0,

                resizeStart: false,
                topPosition: {}, // 左上角原位置
                originTopOffset: {}, // 左上角原位置
                originBottomOffset: {}, // 右下角原位置
                nowOffset: {}, // 现在位置
                cardW: 0,
                cardH: this.cardInfo.cardHeight > 0 ? this.cardInfo.cardHeight : 0,
                mouseMoveSpan: 0,

                dialogVisible: false,
                loading: false,
                // 卡片配置项
                cardPropsMap: {},

                filterSelected: "",
                filters: [],

                viewModel: "list", // 视图
            }
        },
        methods: {
            changeCardColor(color) {
                this.cardColor = color ;
                this.cardMorePop = false ;
                this.cardInfoChange();
            },
            changeCardWidth(width) {
                this.cardWidth = width;
                this.cardMorePop = false ;
                this.cardInfoChange();
            },
            fullscreenHandler() {
                this.fullscreen = !this.fullscreen;
                if (this.fullscreen) {
                    this.oldWidth = this.cardWidth;
                    this.cardWidth = 24;
                } else {
                    this.cardWidth = this.oldWidth
                }
                this.$emit('fullscreen', this.cardInfo, this.fullscreen);
            },
            resizeCardStart(e) {
                this.resizeStart = true;
                this.topPosition = $(this.$el).position();
                this.originTopOffset = $(this.$el).offset();
                this.originBottomOffset = $(this.$el).find('.card-bottom-move-btn').offset();
            },
            resizeCardEnd: function(e) {
                this.resizeStart = false;
                // console.log(this.$el, this.cardWidth)
                this.cardWidth = this.mouseMoveSpan;
                this.localCard.cardHeight = this.cardH
                this.cardInfoChange();
            },
            resizeCardProcess: function(e) {
                if (this.resizeStart) {
                    this.nowOffset = { top: e.pageY, left: e.pageX}
                    this.cardH = this.nowOffset.top - this.originTopOffset.top - 100;
                } else {
                    return false;
                }
            },
            cardInfoChange() {
                this.$emit('cardInfoChange', this.localCard);
            },
            removeCard() {
                this.$emit('removeCard', this.localCard);
            },
            openCardConfig() {
                const self = this;
                self.dialogVisible = true;
            },
            saveCardConfig() {
                const self = this;
                self.loading = true;
                this.$refs.form.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.unref(self.localCard);
                        $.restfulPostJson('../../../../api/s/portal/page/layout',
                            { layoutId: jsonData.layoutId, cardId: jsonData.cardId, cardName: jsonData.cardName,cardProps: self.localCard.cardProps, pageId: jsonData.pageId},
                            function(data) {
                                self.loading = false;
                                self.dialogVisible = false;
                                ElementPlus.ElMessage({
                                    showClose: true,
                                    message: '保存成功',
                                    grouping: true,
                                    type: 'success',
                                })
                                if (self.updateCard) {
                                    self.updateCard();
                                }
                            }, function(e){ self.loading = false; }, true);
                    } else {
                        self.loading = false;
                    }
                })
            },
            // 卡片内容函数
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            handleSizeChange(size) {
                const self = this;
                self.pageInfo.size = size;
                self.queryList();
            },
            handleCurrentChange(page) {
                const self = this;
                self.pageInfo.page = page;
                self.queryList();
            },
            filterSelectedChange(val) {
                if (val) {
                    const f = this.filterConfig.find(function(el){
                        return el.key == val
                    })
                    if (f) {
                        this.filters.push(f)
                        if (this.queryParams) {
                            this.queryParams[f.key] = ""
                        }
                    }
                    this.filterSelected = "";
                }
            },
            deleteFilter(f, index) {
                if (index >=0) {
                    if (this.queryParams) {
                        delete this.queryParams[f.key]
                    }
                    this.filters.splice(index, 1)
                }
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            }
        },
        watch: {
            resizeStart(newVal){
                if (this.fixedFlag) {
                    return;
                }
                if (newVal) {
                    $('main.main').on('mousemove', this.resizeCardProcess)
                    $('main.main').on('mouseup', this.resizeCardEnd)
                } else {
                    $('main.main').off('mousemove', this.resizeCardProcess)
                    $('main.main').off('mouseup', this.resizeCardEnd)
                }
            }
        },
        computed:{
            cardColor: {
                get() {
                    return this.localCard.cardColor == '#FFFFFF' ? '' : this.localCard.cardColor
                },
                set(val) {
                    this.localCard.cardColor = val
                }
            },
            cardName: {
                get() {
                    return this.localCard.cardName
                },
                set(val) {
                    this.localCard.cardName = val
                }
            },
            cardWidth: {
                get() {
                    return this.localCard.cardWidth * 1
                },
                set(val) {
                    this.localCard.cardWidth = val
                }
            },
            pureTheme() {
                return $(this.$el).hasClass('pure-theme')
            },
            styleObject() {
                let height = 'inherit';
                if (this.fullscreen) {
                    height = this.windowHeight.value + 'px'
                } else if (this.fixedFlag) {
                    if (this.cardH > 0 && this.cardH < 300 ) {
                        height = this.cardH + 'px'
                    }
                } else if (this.cardH > 0 ) {
                    height = this.cardH + 'px'
                }
                return {
                    height: height,
                    'padding-bottom': this.dashboardView ? '40px' : ''
                }
            },
            shadowDivStyle() {
                let width = (this.nowOffset.left - this.topPosition.left - 30);
                let divWidth = width;
                const w13 = this.windowWidth.value * (1/3), w12 = this.windowWidth.value * (1/2), w23 = this.windowWidth.value * (2/3), w1 = this.windowWidth.value ;
                if (width > (w1 - 100)) {
                    divWidth = w1;
                    this.mouseMoveSpan = 24
                } else if (width > (w23 - 100) && width <= (w1 - 100)) {
                    divWidth = w23;
                    this.mouseMoveSpan = 16
                } else if (width > (w12 - 100 ) && width <= (w23 - 100)) {
                    divWidth = w12;
                    this.mouseMoveSpan = 12
                } else {
                    divWidth = w13;
                    this.mouseMoveSpan = 8
                }
                let heightOffset = this.pureTheme ? 110 : 50;
                let widthOffset = this.pureTheme ? 10 : 10;
                return {
                    background: '#7676765c',
                    height: (this.nowOffset.top - this.topPosition.top - heightOffset),
                    width: divWidth - widthOffset,
                    top: this.topPosition.top,
                    left: this.topPosition.left,
                }
            },
            rules(){
                return {
                    cardName: [
                        { required: true, message: '卡片名称不能为空' },
                    ],
                }
            },
            filtersMap() {
                const map = {};
                this.filters.forEach(function(el) {
                    map[el.key] = true;
                })
                return map;
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            }
        },
    }
    if (!exports.CardComponents) {
        exports.CardComponents = {}
    }

    exports.CardComponents.BaseCard = BaseCard;

}));