/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintcp.sdk.filesrv.web.operation;

import com.irdstudio.allintcp.sdk.filesrv.application.log.ServiceLog;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.FspConfStorageService;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.FspInstFileService;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.FspInstFolderService;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.SeqInstInfoService;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.dto.FspConfStorageDTO;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.dto.FspInstFileDTO;
import com.irdstudio.allintcp.sdk.filesrv.facade.operation.dto.FspInstFolderDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.primeframework.jwt.Signer;
import org.primeframework.jwt.domain.JWT;
import org.primeframework.jwt.hmac.HMACSigner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class FspApiController
extends AbstractController {
    @Value(value="${fsp.file.storage.root:/}")
    private String fspFileStorageRoot;
    @Value(value="${fsp.tmp.file.storage.root:/var/tmp/fsp/}")
    private String fspTmpFileStorageRoot;
    @Autowired
    protected FspInstFileService fspInstFileService;
    @Autowired
    protected FspInstFolderService fspInstFolderService;
    @Autowired
    protected FspConfStorageService fspConfStorageService;
    @Autowired
    protected SeqInstInfoService seqInstInfoService;
    @Value(value="${docservice.jwt.secret}")
    private String tokenSecret;

    @ServiceLog(serviceType=ServiceLog.ServiceLogType.Upload, bizKey="${result.getRows()}")
    @RequestMapping(value={"/client/fsp/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public String upload_client(@RequestParam(value="storageSceneId") String storageSceneId, @RequestParam(value="subsCode", required=false) String subsCode, @RequestParam(value="appCode", required=false) String appCode, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="userId", required=false) String userId, @RequestPart(value="file") MultipartFile file) {
        return (String)this.upload(storageSceneId, subsCode, appCode, subsId, appId, projectId, owner, userId, file).getRows();
    }

    @ServiceLog(serviceType=ServiceLog.ServiceLogType.Upload, bizKey="${result.getRows()}")
    @RequestMapping(value={"/api/fsp/upload"}, method={RequestMethod.POST})
    public ResponseData<String> upload(@RequestParam(value="storageSceneId") String storageSceneId, @RequestParam(value="subsCode", required=false) String subsCode, @RequestParam(value="appCode", required=false) String appCode, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="projectId", required=false) String projectId, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="userId", required=false) String userId, @RequestPart(value="file") MultipartFile file) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = this.getUserInfo().getUserId();
        }
        FspConfStorageDTO fspConf = new FspConfStorageDTO();
        fspConf.setSubsCode(subsCode);
        fspConf.setAppCode(appCode);
        fspConf.setStorageSceneId(storageSceneId);
        List fspConfList = this.fspConfStorageService.queryListByPage((Object)fspConf);
        if (CollectionUtils.isNotEmpty((Collection)fspConfList)) {
            fspConf = (FspConfStorageDTO)fspConfList.get(0);
            String folderTemplate = fspConf.getFolderTemplate();
            Object fileTemplate = fspConf.getFileTemplate();
            Object folderPath = folderTemplate;
            if (StringUtils.isNotBlank((CharSequence)fileTemplate)) {
                if (!StringUtils.startsWith((CharSequence)fileTemplate, (CharSequence)"/")) {
                    fileTemplate = "/" + (String)fileTemplate;
                }
                folderPath = (String)folderPath + (String)fileTemplate;
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("subsId", subsId);
            param.put("appId", appId);
            param.put("projectId", projectId);
            if (StringUtils.isNotBlank((CharSequence)owner)) {
                String[] owners = StringUtils.split((String)owner, (String)",");
                for (int i = 0; i < owners.length; ++i) {
                    String ownerStr = owners[i];
                    if (StringUtils.isBlank((CharSequence)ownerStr)) {
                        ownerStr = "";
                    }
                    param.put(String.format("owner%s", i + 1), ownerStr);
                }
            }
            Calendar calender = Calendar.getInstance();
            param.put("YYYY", DateFormatUtils.format((Calendar)calender, (String)"yyyy"));
            param.put("MM", DateFormatUtils.format((Calendar)calender, (String)"MM"));
            param.put("DD", DateFormatUtils.format((Calendar)calender, (String)"dd"));
            param.put("HH", DateFormatUtils.format((Calendar)calender, (String)"HH"));
            param.put("mm", DateFormatUtils.format((Calendar)calender, (String)"mm"));
            param.put("ss", DateFormatUtils.format((Calendar)calender, (String)"ss"));
            param.put("YYYYMMDD", DateFormatUtils.format((Calendar)calender, (String)"yyyyMMdd"));
            param.put("YYYYMMDDHHmmss", DateFormatUtils.format((Calendar)calender, (String)"yyyyMMddHHmmss"));
            param.put("YYYYMMDDHHmmssSSS", DateFormatUtils.format((Calendar)calender, (String)"yyyyMMddHHmmssSSS"));
            param.put("UUID", UUIDUtil.getUUID());
            param.put("SUUID", UUIDUtil.getShortUUID());
            String folder = ExpressionUtil.parse((String)folderPath, param);
            FspInstFolderDTO folderInst = new FspInstFolderDTO();
            folderInst.setFolderLocation(folder);
            List folderList = this.fspInstFolderService.queryListByPage((Object)folderInst);
            if (CollectionUtils.isEmpty((Collection)folderList)) {
                folderInst = new FspInstFolderDTO();
                folderInst.setFolderLocation(folder);
                folderInst.setFolderId(UUIDUtil.getUUID());
                folderInst.setCreateUser(userId);
                folderInst.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                folderInst.setLastModifyUser(userId);
                folderInst.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                folderInst.setSubsId(subsId);
                folderInst.setAppId(appId);
                folderInst.setProjectId(projectId);
                folderInst.setStorageSceneId(storageSceneId);
                this.fspInstFolderService.insertSingle(folderInst);
            } else {
                folderInst = (FspInstFolderDTO)folderList.get(0);
            }
            FspInstFileDTO fileInst = new FspInstFileDTO();
            fileInst.setFileId(this.seqInstInfoService.nextSequence("FILE-SEQ", storageSceneId));
            String fileName = file.getOriginalFilename();
            long fileSize = file.getSize();
            String fileType = StringUtils.substring((String)fileName, (int)(StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)".") + 1));
            fileInst.setFileName(fileName);
            fileInst.setFileType(fileType);
            fileInst.setFolderId(folderInst.getFolderId());
            fileInst.setFileSize(new BigDecimal(fileSize));
            fileInst.setFileLocation(folderInst.getFolderLocation() + "/" + fileInst.getFileId());
            fileInst.setStorageSceneId(storageSceneId);
            fileInst.setSubsId(subsId);
            fileInst.setAppId(appId);
            fileInst.setProjectId(projectId);
            fileInst.setCreateUser(userId);
            fileInst.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            fileInst.setLastModifyUser(userId);
            fileInst.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            this.fspInstFileService.insertSingle(fileInst);
            File realDir = new File(this.fspFileStorageRoot, folder);
            if (!realDir.exists()) {
                realDir.mkdirs();
            }
            File realFile = new File(realDir, fileInst.getFileId());
            try {
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)realFile);
            }
            catch (IOException e) {
                this.fspInstFileService.deleteByPk(fileInst);
                throw new RuntimeException("\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u5230\u76ee\u5f55\u5f02\u5e38 " + e.getMessage(), e);
            }
            return this.getResponseData(fileInst.getFileId());
        }
        throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1\u914d\u7f6e");
    }

    @ServiceLog(serviceType=ServiceLog.ServiceLogType.Download, bizKey="${args[0]}")
    @RequestMapping(value={"/client/fsp/download"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> download(@RequestParam(value="fileId", required=true) String fileId, @RequestParam(value="userId", required=false) String userId) {
        FspInstFileDTO fileInst = new FspInstFileDTO();
        fileInst.setFileId(fileId);
        fileInst = this.fspInstFileService.queryByPk(fileInst);
        if (fileInst == null) {
            throw new RuntimeException(String.format("%s\u5bf9\u5e94\u6587\u4ef6\u4e0d\u5b58\u5728", fileId));
        }
        String fileLocation = fileInst.getFileLocation();
        File file = new File(this.fspFileStorageRoot, fileLocation);
        if (!file.exists()) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", fileInst.getFileName(), fileId));
        }
        String fileName = fileInst.getFileName();
        String fileType = fileInst.getFileType();
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            String contentType = "application/octet-stream";
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + new String(fileName.getBytes(), "iso-8859-1") + "\""})).body((Object)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38%s", fileInst.getFileName(), fileId, e.getMessage()));
        }
    }

    @ServiceLog(serviceType=ServiceLog.ServiceLogType.Preview, bizKey="${args[0]}")
    @RequestMapping(value={"/api/fsp/preview"}, method={RequestMethod.GET})
    public void preview(@RequestParam(value="fileId", required=true) String fileId, @RequestParam(value="userId", required=false) String userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        userId = this.getUserInfo() != null && StringUtils.isNotBlank((CharSequence)this.getUserInfo().getUserId()) ? this.getUserInfo().getUserId() : userId;
        FspInstFileDTO fileInst = new FspInstFileDTO();
        fileInst.setFileId(fileId);
        fileInst = this.fspInstFileService.queryByPk(fileInst);
        if (fileInst == null) {
            throw new RuntimeException(String.format("%s\u5bf9\u5e94\u6587\u4ef6\u4e0d\u5b58\u5728", fileId));
        }
        String fileLocation = fileInst.getFileLocation();
        File file = new File(this.fspFileStorageRoot, fileLocation);
        if (!file.exists()) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", fileInst.getFileName(), fileId));
        }
        response.sendRedirect(String.format("%s/page/allintcp/sdk/filesrv/preview.html?fileId=%s&userId=%s", request.getContextPath(), fileId, userId));
    }

    @RequestMapping(value={"/api/fsp/health"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> checkHealth() {
        return this.getResponseData("\u6b63\u5e38");
    }

    @RequestMapping(value={"/api/fsp/token"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> genToken(@RequestBody Map<String, Object> payloadClaims) {
        return this.getResponseData(this.createToken(payloadClaims));
    }

    public String createToken(Map<String, Object> payloadClaims) {
        try {
            HMACSigner signer = HMACSigner.newSHA256Signer((String)this.tokenSecret);
            JWT jwt = new JWT();
            for (String key : payloadClaims.keySet()) {
                jwt.addClaim(key, payloadClaims.get(key));
            }
            return JWT.getEncoder().encode(jwt, (Signer)signer);
        }
        catch (Exception e) {
            return "";
        }
    }

    @RequestMapping(value={"/client/fsp/update/coedit"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> coEditUpdateFile(@RequestParam(value="fileId") String fileId, @RequestParam(value="userId") String userId, @RequestBody Map<String, Object> callbackData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int status = MapUtils.getInteger(callbackData, (Object)"status");
        if (status == 2) {
            String downloadUri = MapUtils.getString(callbackData, (Object)"url");
            FspInstFileDTO fileInst = new FspInstFileDTO();
            fileInst.setFileId(fileId);
            fileInst = this.fspInstFileService.queryByPk(fileInst);
            if (fileInst == null) {
                throw new RuntimeException(String.format("%s\u5bf9\u5e94\u6587\u4ef6\u4e0d\u5b58\u5728", fileId));
            }
            String fileName = fileInst.getFileName();
            String fileLocation = fileInst.getFileLocation();
            File file = new File(this.fspFileStorageRoot, fileLocation);
            if (!file.exists()) {
                throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", fileInst.getFileName(), fileId));
            }
            HttpURLConnection connection = null;
            try {
                URL url = new URL(downloadUri);
                connection = (HttpURLConnection)url.openConnection();
                InputStream stream = connection.getInputStream();
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("%s\u66f4\u65b0\u5f02\u5e38 %s", fileName, e.getMessage()), e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        result.put("error", 0);
        return result;
    }
}

