(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {

    
    exports.RPT000032Rpt = {
        props: {
            startDate: String,
            endDate: String,
        },
        inject: ['DIC', 'searchParams', 'windowHeight', 'windowWidth'],
        data(){
            return {
                // 卡片内容数据
                queryParams: {
                    
                },
                tableData: [],
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                filterCond: [],


                spacer : Vue.h(ElementPlus.ElDivider, { direction: 'vertical' }),

            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            queryParamsHandler(params){
                const self = this;
                
                let localFilterCond = JSON.parse(JSON.stringify(this.filterCond)) || []
                // 添加报表周期条件
                localFilterCond.push({ "op":"btw","key":"batch_date","values": [self.startDate, self.endDate] })
                // 过滤条件
                if (localFilterCond && localFilterCond.length > 0) {
                    params.filterCond = JSON.stringify(localFilterCond)
                }
                params.startDate = self.startDate;
                params.endDate = self.endDate;
                return params
            },
            // 卡片内容函数
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.toRaw(self.pageInfo),
                    ...Vue.toRaw(self.queryParams)
                }
                params[self.allName] = self.all
                self.queryParamsHandler(params)
                $.restfulPostJson(contextPath + 'api/rpt/query/RPT00003/2', params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
        },
        computed:{
            DIC() {
                return {
                }
            },
            tabTitle() {
                return this.cardName
            },
        },
        mounted() {
            const self = this;

        },
        unmounted() {

        },
        template: `
<el-col :span="24" >
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" breadcrumb="批次日报" card-header>
                <template #right>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                        enable-search
                        :all-items="[]"
                >
                </page-search>
                <el-table :data="tableData"
                            v-loading="loading"
                            stripe
                            highlight-current-row
                            tooltip-effect="light"
                            :tooltip-options="{placement : 'bottom'}"
                            style="width: 100%" >
                    <el-table-column type="index" width="45" ></el-table-column>
                    <el-table-column prop="batch_date" label="批次日期" show-overflow-tooltip  ></el-table-column>
                    <el-table-column prop="batch_name" label="批次名称" show-overflow-tooltip  ></el-table-column>
                    <el-table-column prop="start_time" label="启动时间" show-overflow-tooltip  ></el-table-column>
                    <el-table-column prop="end_time" label="结束时间" show-overflow-tooltip  ></el-table-column>
                    <el-table-column prop="cost_time" label="运行时长" show-overflow-tooltip  ></el-table-column>
                    <el-table-column prop="subs_id" label="应用系统编号" show-overflow-tooltip  ></el-table-column>
                </el-table>
                <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
            </el-col>
        </el-row>
    </el-card>
</el-col>
        `
    }


}));