/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.manual.web.operation;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allintpaas.batch.admin.facade.operation.SAgentInfoService;
import com.irdstudio.allintpaas.batch.admin.facade.operation.dto.SAgentInfoDTO;
import com.irdstudio.allintpaas.batch.conf.facade.operation.BatBatchInfoConfigService;
import com.irdstudio.allintpaas.batch.conf.facade.operation.BatTaskUnitConfigService;
import com.irdstudio.allintpaas.batch.conf.facade.operation.dto.BatBatchInfoConfigDTO;
import com.irdstudio.allintpaas.batch.conf.facade.operation.dto.BatTaskUnitConfigDTO;
import com.irdstudio.allintpaas.batch.monitor.facade.operation.BatInstTaskService;
import com.irdstudio.allintpaas.batch.monitor.facade.operation.dto.BatInstBatchDTO;
import com.irdstudio.allintpaas.batch.monitor.facade.operation.dto.BatInstTaskDTO;
import com.irdstudio.framework.beans.core.util.StringUtil;
import com.irdstudio.framework.beans.core.util.TimeUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.core.vo.ZTreeVO;
import com.irdstudio.framework.beans.web.controller.BaseController;
import com.irdstudio.framework.beans.web.http.DefRestfulHttpClient;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class BatBatchAgentController
extends BaseController<BatBatchInfoConfigDTO, BatBatchInfoConfigService> {
    @Autowired
    private SAgentInfoService sAgentInfoService;
    @Autowired
    private BatTaskUnitConfigService batTaskUnitConfigService;
    @Autowired
    private BatInstTaskService batInstTaskService;

    @RequestMapping(value={"/api/bat/batch/info/action"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> startBatch(@RequestParam(value="batchSerialNo") String batchSerialNo, @RequestParam(value="batchId") String batchId, @RequestParam(value="batchAction") String batchAction, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="envId", required=false) String envId) {
        ResponseData data;
        block9: {
            BatBatchInfoConfigDTO params = new BatBatchInfoConfigDTO();
            params.setBatchId(batchId);
            BatBatchInfoConfigDTO batchConf = ((BatBatchInfoConfigService)this.getService()).queryByPk(params);
            SAgentInfoDTO inVo = new SAgentInfoDTO();
            inVo.setAgentId(batchConf.getAgentId());
            SAgentInfoDTO agentInfo = this.sAgentInfoService.queryByPk(inVo);
            data = null;
            if (agentInfo != null && StringUtils.isNotEmpty((CharSequence)agentInfo.getAgentUrl())) {
                try {
                    ResponseVO response;
                    if ("none".equals(batchSerialNo)) {
                        batchSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                    }
                    if ((response = BatBatchAgentController.actionBatch(agentInfo.getAgentUrl(), null, batchId, batchAction, envId)) != null && StringUtils.isNotEmpty((CharSequence)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(true);
                        if (response != null && StringUtils.isNotEmpty((CharSequence)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01");
                            logger.info("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01agentId:" + agentInfo.getAgentId() + ", agent\u5730\u5740\uff1a" + agentInfo.getAgentUrl() + ", \u6279\u6b21\u53f7\uff1a" + batchId + ", \u6279\u6b21\u52a8\u4f5c\uff1a" + batchAction + "\uff0c\u6279\u6b21\u6d41\u6c34\u53f7\uff1a" + batchSerialNo);
                        }
                        break block9;
                    }
                    data = this.getResponseData(false);
                    if (response != null && StringUtils.isNotEmpty((CharSequence)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block9;
                    }
                    data.setMessage("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(false);
                    data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f");
                data = this.getResponseData(false);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            }
        }
        return data;
    }

    @RequestMapping(value={"/api/bat/batch/info/action/post"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> startMarketBatch(@RequestBody BatInstBatchDTO param) {
        ResponseData data;
        block14: {
            BatBatchInfoConfigDTO params = new BatBatchInfoConfigDTO();
            params.setBatchId(param.getBatchId());
            BatBatchInfoConfigDTO batchConf = ((BatBatchInfoConfigService)this.getService()).queryByPk(params);
            String batchSerialNo = param.getBatchSerialNo();
            String extParam = param.getExtParam();
            HashMap<String, String> extParamMap = null;
            try {
                extParamMap = (HashMap<String, String>)JSON.parseObject((String)extParam, Map.class);
                if (extParamMap == null) {
                    extParamMap = new HashMap();
                }
            }
            catch (Exception e) {
                extParamMap = new HashMap<String, String>();
            }
            String createUserId = param.getLoginUserId();
            if (this.getUserInfo() != null) {
                createUserId = this.getUserInfo().getUserId();
            }
            extParamMap.put("createUserId", createUserId);
            param.setExtParam(JSON.toJSONString(extParamMap));
            SAgentInfoDTO inVo = new SAgentInfoDTO();
            inVo.setAgentId(batchConf.getAgentId());
            SAgentInfoDTO agentInfo = this.sAgentInfoService.queryByPk(inVo);
            data = null;
            if (agentInfo != null && StringUtils.isNotEmpty((CharSequence)agentInfo.getAgentUrl())) {
                try {
                    ResponseVO response;
                    if (StringUtils.isBlank((CharSequence)batchSerialNo)) {
                        batchSerialNo = "none";
                    }
                    if (StringUtils.equals((CharSequence)"none", (CharSequence)batchSerialNo)) {
                        batchSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                    }
                    if ((response = BatBatchAgentController.actionBatchPost(agentInfo.getAgentUrl(), batchSerialNo, param.getBatchId(), "run", param)) != null && StringUtils.isNotEmpty((CharSequence)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(batchSerialNo);
                        if (response != null && StringUtils.isNotEmpty((CharSequence)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01");
                            logger.info("\u6279\u6b21\u6267\u884c\u6210\u529f\uff01agentId:" + agentInfo.getAgentId() + ", agent\u5730\u5740\uff1a" + agentInfo.getAgentUrl() + ", \u6279\u6b21\u53f7\uff1a" + param.getBatchId() + ", \u6279\u6b21\u52a8\u4f5c\uff1arun\uff0c\u6279\u6b21\u6d41\u6c34\u53f7\uff1a" + batchSerialNo);
                        }
                        break block14;
                    }
                    data = this.getResponseData(null);
                    if (response != null && StringUtils.isNotEmpty((CharSequence)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block14;
                    }
                    data.setMessage("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u6279\u6b21\u6267\u884c\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(null);
                    data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u6267\u884c\u8282\u70b9");
                data = this.getResponseData(null);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u6267\u884c\u8282\u70b9\uff01");
            }
        }
        return data;
    }

    public static ResponseVO actionBatch(String agentUrl, String batchSerialNo, String batchId, String batchAction, String envId) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/api/batch/start?batchSerialNo={batchSerialNo}&batchId={batchId}&batchAction={batchAction}&envId={envId}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchSerialNo, batchId, batchAction, envId});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    public static ResponseVO actionBatchPost(String agentUrl, String batchSerialNo, String batchId, String batchAction, BatInstBatchDTO param) {
        ResponseVO response = null;
        try {
            DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
            response = (ResponseVO)defaultClient.httpCall(agentUrl + "/batch/start?batchSerialNo={batchSerialNo}&batchId={batchId}&batchAction={batchAction}", HttpMethod.POST, (Object)param, ResponseVO.class, new Object[]{batchSerialNo, batchId, batchAction});
        }
        catch (Exception e) {
            response = new ResponseVO();
            response.setFlag("fail");
            response.setMsg("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
        }
        return response;
    }

    @RequestMapping(value={"/client/bat/batch/info/action/startBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> startBatchForClient(@RequestBody BatInstBatchDTO param) {
        return this.startMarketBatch(param);
    }

    public static String getBatchLogs(String agentUrl, String batchId, String batchSerialNo) throws Exception {
        DefRestfulHttpClient defaultClient = new DefRestfulHttpClient();
        ResponseVO responseVO = (ResponseVO)defaultClient.httpCall(agentUrl + "/batch/log?batchId={batchId}&batchSerialNo={batchSerialNo}", HttpMethod.GET, null, ResponseVO.class, new Object[]{batchId, batchSerialNo});
        if ("fail".equals(responseVO.getFlag())) {
            throw new Exception(responseVO.getMsg());
        }
        return responseVO.getMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/batch/logs/run/{batchId}"}, method={RequestMethod.GET})
    public void getBatchRunLogs(@PathVariable(value="batchId") String batchId, @RequestParam(value="batchSerialNo") String batchSerialNo, HttpServletResponse response) {
        String output = "";
        try {
            BatBatchInfoConfigDTO batBatchInfoConfigVO = new BatBatchInfoConfigDTO();
            batBatchInfoConfigVO.setBatchId(batchId);
            batBatchInfoConfigVO = ((BatBatchInfoConfigService)this.getService()).queryByPk(batBatchInfoConfigVO);
            if (Objects.isNull(batBatchInfoConfigVO)) {
                throw new Exception("\u901a\u8fc7\u6279\u6b21\u53f7\u83b7\u53d6\u6279\u6b21\u4fe1\u606f\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6279\u6b21\u53f7\u4e3a:" + batchId);
            }
            String agentId = batBatchInfoConfigVO.getAgentId();
            SAgentInfoDTO sAgentInfoVO = new SAgentInfoDTO();
            sAgentInfoVO.setAgentId(agentId);
            sAgentInfoVO = this.sAgentInfoService.queryByPk(sAgentInfoVO);
            if (Objects.isNull(sAgentInfoVO)) {
                throw new Exception("\u901a\u8fc7\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u83b7\u53d6\u4ee3\u7406\u8282\u70b9\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u4e3a:" + agentId);
            }
            String agentUrl = sAgentInfoVO.getAgentUrl();
            if (StringUtil.isNullorBank((String)agentUrl)) {
                throw new Exception("\u4ee3\u7406\u8282\u70b9\u5730\u5740\u4e3a\u7a7a\uff0c\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u4e3a:" + agentId);
            }
            output = BatBatchAgentController.getBatchLogs(agentUrl, batchId, batchSerialNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            output = "\u83b7\u53d6\u6279\u6b21\u76d1\u63a7\u65e5\u5fd7\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
        }
        output = output.replaceAll("[\n\r]", "<br>");
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter((OutputStream)response.getOutputStream());
            printWriter.write(output);
            printWriter.flush();
        }
    }

    @RequestMapping(value={"/api/bat/inst/task/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ZTreeVO> queryInstTaskTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        ArrayList<ZTreeVO> taskTree = new ArrayList<ZTreeVO>();
        String text = batchId + "(" + batchSerialNo + ")";
        ZTreeVO root = new ZTreeVO();
        root.setId(batchSerialNo);
        root.setText(text);
        root.setChildren(new ArrayList());
        taskTree.add(root);
        HashMap<String, ZTreeVO> stageMap = new HashMap<String, ZTreeVO>();
        BatInstTaskDTO batInstTaskVo = new BatInstTaskDTO();
        batInstTaskVo.setBatchId(batchId);
        batInstTaskVo.setBatchSerialNo(batchSerialNo);
        List batInstTasks = this.batInstTaskService.queryList(batInstTaskVo);
        for (int i = 0; i < batInstTasks.size(); ++i) {
            ZTreeVO stageNode;
            BatInstTaskDTO task = (BatInstTaskDTO)batInstTasks.get(i);
            ZTreeVO taskNode = new ZTreeVO();
            taskNode.setId(task.getTaskId());
            taskNode.setText(task.getTaskName());
            taskNode.setAttributes((Object)task);
            taskNode.setIconCls("icon-task");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new ZTreeVO();
                stageNode.setId(task.getStageId());
                stageNode.setText(task.getStageName());
                stageNode.setChildren(new ArrayList());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (ZTreeVO)stageMap.get(task.getStageId());
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @RequestMapping(value={"/api/bat/inst/task/hangup"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> hangUp(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatInstTaskDTO updateParam = new BatInstTaskDTO();
        updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
        updateParam.setTaskId(inBatInstTaskVo.getTaskId());
        updateParam.setTaskInterveneState("2");
        int outputVo = this.batInstTaskService.updateByPk(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/hangdown"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> hangDown(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatInstTaskDTO updateParam = new BatInstTaskDTO();
        updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
        updateParam.setTaskId(inBatInstTaskVo.getTaskId());
        updateParam.setTaskInterveneState("0");
        int outputVo = this.batInstTaskService.updateByPk(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/skip"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> skip(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatTaskUnitConfigDTO params = new BatTaskUnitConfigDTO();
        params.setTaskId(inBatInstTaskVo.getTaskId());
        BatTaskUnitConfigDTO configVO = this.batTaskUnitConfigService.queryByPk(params);
        ResponseData data = null;
        if (configVO != null && StringUtils.isNotEmpty((CharSequence)configVO.getTaskSkipTactic()) && !configVO.getTaskSkipTactic().equals("2")) {
            BatInstTaskDTO updateParam = new BatInstTaskDTO();
            updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
            updateParam.setTaskId(inBatInstTaskVo.getTaskId());
            updateParam.setTaskInterveneState("1");
            int outputVo = this.batInstTaskService.updateByPk(inBatInstTaskVo);
            data = this.getResponseData(outputVo);
        } else {
            data = this.getResponseData(-1);
            data.setMessage("\u8be5\u4efb\u52a1\u4e0d\u5141\u8bb8\u7f6e\u8fc7\uff01");
        }
        return data;
    }

    public static class ResponseVO {
        public static final String SUCCESS = "success";
        public static final String FAIL = "fail";
        private String flag = "fail";
        private String msg;

        public String getFlag() {
            return this.flag;
        }

        public void setFlag(String flag) {
            this.flag = flag;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

