/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.plugin.dataload;

import com.irdstudio.allintpaas.batch.engine.executor.core.plugin.dataload.PluginLoadConf;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.meta.MetaTable;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.session.CustomTransaction;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.jdbc.session.TransactionUtil;
import com.irdstudio.allintpaas.batch.engine.executor.core.tinycore.log.ILogger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportFromTxt {
    private PluginLoadConf conf = null;
    private String fullFilePath = null;
    private String dataSplit = "";
    private PreparedStatement pst = null;
    private boolean isReadedComplete;
    private BufferedReader br;
    private int fileRecordCount;
    private int faildRecordCount;
    private int currBatchCount;
    private MetaTable table;
    private String sqlHead;
    private CustomTransaction tran = null;
    private ILogger logger = null;
    private Connection conn = null;

    public ImportFromTxt(PluginLoadConf loadConf, ILogger logger, Connection conn) {
        this.conf = loadConf;
        this.fullFilePath = loadConf.getLoadFromFile();
        this.logger = logger;
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        boolean flag = true;
        double before = System.currentTimeMillis();
        this.fillMetaTable(this.conn);
        try {
            this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fullFilePath), this.conf.getFileCharset()), this.conf.getLoadBufferSize() * 1024);
            this.dataSplit = StringEscapeUtils.escapeJava((String)this.conf.getLoadSeparator());
            if (this.dataSplit.trim().equals("|")) {
                this.dataSplit = "\\" + this.dataSplit;
            } else if (this.dataSplit.trim().equals("||")) {
                this.dataSplit = "\\|\\\\|";
            }
            StringBuffer iSql = new StringBuffer("INSERT INTO ");
            StringBuffer vSql = new StringBuffer(" VALUES(");
            iSql.append(this.conf.getTableName()).append("(");
            for (int k = 0; k < this.table.fieldCount - 1; ++k) {
                iSql.append(this.table.fields[k]).append(",");
                vSql.append("?,");
            }
            iSql.append(this.table.fields[this.table.fieldCount - 1]).append(")");
            vSql.append("?)");
            this.tran = TransactionUtil.createTransaction(this.conn);
            this.sqlHead = iSql.append(vSql).toString();
            this.pst = this.conn.prepareStatement(this.sqlHead);
            this.pst.setFetchSize(10000);
            int start = 0;
            int end = 10000;
            while (!this.isReadedComplete) {
                this.fetchDataToBatchPst(start, end);
                this.batchInsertIntoTable();
                start = end + 1;
                end += 10000;
            }
            this.logger.info("\u6587\u672c\u6587\u4ef6\u603b\u8bb0\u5f55\u6570:" + this.fileRecordCount);
            this.logger.info("\u5bfc\u5165\u6210\u529f\u8bb0\u5f55\u6570:" + (this.fileRecordCount - this.faildRecordCount));
            this.logger.info("\u5bfc\u5165\u5931\u8d25\u8bb0\u5f55\u6570:" + this.faildRecordCount);
            double after = System.currentTimeMillis();
            this.logger.info("\u8017\u65f6[" + (after - before) / 1000.0 + "]\u79d2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u6570\u636e\u51fa\u9519!", e);
            flag = false;
        }
        finally {
            try {
                if (this.br != null) {
                    this.br.close();
                    this.br = null;
                }
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5bf9\u8c61\u65f6\u5f02\u5e38!", e);
            }
            if (this.pst != null) {
                try {
                    this.pst.close();
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage());
                }
            }
            this.pst = null;
            this.conf = null;
            this.table = null;
            TransactionUtil.releaseTransaction(this.tran);
        }
        return flag;
    }

    private void fillMetaTable(Connection conn) {
        this.table = null == this.conf.getLoadFields() || "".equals(this.conf.getLoadFields()) ? MetaTable.getInstWithTable(conn, this.conf.getTableName()) : MetaTable.getInstWithQuery(conn, "select " + this.conf.getLoadFields() + " from " + this.conf.getTableName());
    }

    private void batchInsertIntoTable() {
        try {
            long t1 = System.currentTimeMillis();
            this.pst.executeBatch();
            this.tran.commit();
            this.pst.clearBatch();
            this.logger.info("\u6279\u91cf\u6267\u884c\u8017\u65f6\uff1a" + new BigDecimal(System.currentTimeMillis() - t1).divide(BigDecimal.valueOf(1000.0)) + "\u79d2:\u6bcf\u6b21\u6761\u6570=" + this.pst.getFetchSize());
        }
        catch (BatchUpdateException e) {
            try {
                this.faildRecordCount += this.currBatchCount;
                this.tran.rollback();
            }
            catch (SQLException e1) {
                this.logger.info("\u4e8b\u52a1\u56de\u6eda\u65f6\u51fa\u9519!", e);
            }
            this.logger.info("\u6279\u91cf\u63d0\u4ea4\u65f6\u51fa\u9519!", e);
        }
        catch (SQLException e) {
            try {
                this.tran.rollback();
            }
            catch (SQLException e1) {
                this.logger.info("\u4e8b\u52a1\u56de\u6eda\u65f6\u51fa\u9519!", e);
            }
            this.logger.error(e.getMessage());
            this.faildRecordCount += this.currBatchCount;
        }
        finally {
            this.currBatchCount = 0;
            try {
                this.pst.clearBatch();
            }
            catch (SQLException e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    public void fetchDataToBatchPst(int start, int end) throws Exception {
        String s = null;
        try {
            if ("Y".equals(this.conf.getIsFirstline()) && start == 0) {
                s = this.br.readLine();
            }
            if ((s = this.br.readLine()) == null) {
                this.isReadedComplete = true;
            }
            while (s != null) {
                if (!"".equals(s.trim())) {
                    ++this.fileRecordCount;
                    if (this.fileRecordCount >= start) {
                        if (this.bindValueToBatchSQL(s)) {
                            this.pst.addBatch();
                            ++this.currBatchCount;
                        }
                        if (this.fileRecordCount == end) break;
                    }
                }
                s = this.br.readLine();
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private boolean bindValueToBatchSQL(String values) {
        String[] frecord = values.split(this.dataSplit, -1);
        int dataLength = frecord.length;
        if (dataLength < this.table.fieldCount) {
            ++this.faildRecordCount;
            this.logger.info("\u6587\u4ef6[" + this.fullFilePath + "]\u7b2c[" + this.fileRecordCount + "]\u884c\u7684\u5b57\u6bb5\u6570[" + dataLength + "]\u5c11\u4e8e\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u6570[" + this.table.fieldCount + "]");
            return false;
        }
        try {
            for (int i = 0; i < this.table.fieldCount; ++i) {
                String data = frecord[i].trim();
                if ("Y".equals(this.conf.getIsDealEmptyStr()) && StringUtils.isNotEmpty((CharSequence)this.conf.getDealEmptyStr()) && this.conf.getDealEmptyStr().equals(data) || "".equals(data)) {
                    data = null;
                }
                this.pst.setObject(i + 1, data);
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public int getFileRecordCount() {
        return this.fileRecordCount;
    }

    public int getFaildRecordCount() {
        return this.faildRecordCount;
    }
}

