/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.batch.engine.executor.core.assembly.imdbcp.encode;

import java.sql.SQLException;

public class Util {
    private Util() {
    }

    public static String encodeString(String sourceStr, String charSet, int type) throws SQLException {
        if (type == 0 || sourceStr == null) {
            return sourceStr;
        }
        byte[] bytes = sourceStr.getBytes();
        if (bytes.length <= 0) {
            return sourceStr;
        }
        try {
            if (type == 1) {
                return new String(bytes, charSet);
            }
            if (Util.isNeedEncode(bytes)) {
                return new String(bytes, charSet);
            }
            return sourceStr;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public static String decodeString(String sourceStr, String charSet, int type) throws SQLException {
        if (type == 0 || sourceStr == null) {
            return sourceStr;
        }
        try {
            byte[] bytes = sourceStr.getBytes(charSet);
            if (bytes.length <= 0) {
                return sourceStr;
            }
            if (type == 1) {
                return new String(bytes);
            }
            if (Util.isNeedEncode(bytes)) {
                return new String(bytes);
            }
            return sourceStr;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public static Object encodeObject(Object obj, String charSet, int type) throws SQLException {
        if (obj instanceof String) {
            return Util.encodeString((String)obj, charSet, type);
        }
        return obj;
    }

    public static Object decodeObject(Object obj, String charSet, int type) throws SQLException {
        if (obj instanceof String) {
            return Util.decodeString((String)obj, charSet, type);
        }
        return obj;
    }

    private static boolean isNeedEncode(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            return true;
        }
        return false;
    }
}

